package ext.scroll.events {
import ext.scroll.Scroller;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.scroll.events.Scroller_x_yEvent")]
public class Scroller_x_yEvent extends FlExtEvent {
  /**
   * Fires whenever the scrolling is started.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#event-scrollstart Original Ext JS documentation of 'scrollstart'
   * @see ext.scroll.Scroller
   * @eventType onScrollStart
   */
  public static const SCROLL_START:String = "onScrollStart";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "x", "y", "eOpts"];

  public function Scroller_x_yEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get source():Scroller;

  /**
   * The current x position.
   */
  public native function get x():Number;

  /**
   * The current y position.
   */
  public native function get y():Number;
}
}