package ext.scroll.events {
import ext.scroll.Scroller;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.scroll.events.Scroller_x_y_deltaX_deltaYEvent")]
public class Scroller_x_y_deltaX_deltaYEvent extends FlExtEvent {
  /**
   * Fires whenever the Scroller is scrolled.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#event-scroll Original Ext JS documentation of 'scroll'
   * @see ext.scroll.Scroller
   * @eventType onScroll
   */
  public static const SCROLL:String = "onScroll";
  /**
   * Fires whenever the scrolling is ended.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.scroll.Scroller.html#event-scrollend Original Ext JS documentation of 'scrollend'
   * @see ext.scroll.Scroller
   * @eventType onScrollEnd
   */
  public static const SCROLL_END:String = "onScrollEnd";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "x", "y", "deltaX", "deltaY", "eOpts"];

  public function Scroller_x_y_deltaX_deltaYEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The change in x value.
   */
  public native function get deltaX():Number;

  /**
   * The change in y value.
   */
  public native function get deltaY():Number;

  public native function get source():Scroller;

  /**
   * The new x position.
   */
  public native function get x():Number;

  /**
   * The new y position.
   */
  public native function get y():Number;
}
}