package ext.selection {
import ext.grid.CellContext;

[Native("Ext.selection.CellModel", require)]
/**
 * @see ext.selection.events.CellSelectionModel_record_row_columnEvent.DESELECT
 * @eventType ext.selection.events.CellSelectionModel_record_row_columnEvent.DESELECT
 */
[Event(name='onDeselect', type='ext.selection.events.CellSelectionModel_record_row_columnEvent')]
/**
 * @see ext.selection.events.CellSelectionModel_record_row_columnEvent.SELECT
 * @eventType ext.selection.events.CellSelectionModel_record_row_columnEvent.SELECT
 */
[Event(name='onSelect', type='ext.selection.events.CellSelectionModel_record_row_columnEvent')]
/**
 * A selection model for <i>grid panels</i> (→<code>ext.grid.GridPanel</code>) which allows selection of a single cell
 * at a time.
 * <p>Implements cell based navigation via keyboard.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var store = Ext.create('Ext.data.Store', {
 *     fields: ['name', 'email', 'phone'],
 *     data: [
 *         { name: 'Lisa', email: 'lisa&#64;simpsons.com',  phone: '555-111-1224' },
 *         { name: 'Bart', email: 'bart&#64;simpsons.com',  phone: '555-222-1234' },
 *         { name: 'Homer', email: 'homer&#64;simpsons.com', phone: '555-222-1244' },
 *         { name: 'Marge', email: 'marge&#64;simpsons.com', phone: '555-222-1254' }
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     title: 'Simpsons',
 *     store: store,
 *     width: 400,
 *     renderTo: Ext.getBody(),
 *     columns: [
 *         { text: 'Name',  dataIndex: 'name' },
 *         { text: 'Email', dataIndex: 'email', flex: 1 },
 *         { text: 'Phone', dataIndex: 'phone' }
 *     ],
 *     selModel: 'cellmodel'
 * });
 * </pre>
 * @see ext.grid.GridPanel
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.CellModel.html Original Ext JS documentation of 'Ext.selection.CellModel'
 */
public class CellSelectionModel extends DataViewSelectionModel {
  /**
   * @param config @inheritDoc
   */
  public function CellSelectionModel(config:CellSelectionModel = null) {
    super();
  }

  [ExtConfig]
  /**
   * Set to <code>true</code> to deselect current selection when the container body is clicked.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.CellModel.html#cfg-deselectOnContainerClick Original Ext JS documentation of 'deselectOnContainerClick'
   */
  public native function get deselectOnContainerClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set deselectOnContainerClick(value:Boolean):void;

  [ExtConfig]
  /**
   * Turns on/off keyboard navigation within the grid.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.CellModel.html#cfg-enableKeyNav Original Ext JS documentation of 'enableKeyNav'
   */
  override public native function get enableKeyNav():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set enableKeyNav(value:Boolean):void;

  [ExtConfig]
  /**
   * Mode of selection. Valid values are:
   * <ul>
   * <li><b>"SINGLE"</b> - Only allows selecting one item at a time. This is the default.</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.CellModel.html#cfg-mode Original Ext JS documentation of 'mode'
   */
  override public native function get mode():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set mode(value:String):void;

  [ExtConfig]
  /**
   * Set this configuration to true to prevent wrapping around of selection as
   * a user navigates to the first or last column.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.CellModel.html#cfg-preventWrap Original Ext JS documentation of 'preventWrap'
   */
  public native function get preventWrap():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preventWrap(value:Boolean):void;

  [Deprecated(replacement="getPosition", since="5.0.1")]
  /**
   * Returns the current position in the format {row: row, column: column}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.CellModel.html#method-getCurrentPosition Original Ext JS documentation of 'getCurrentPosition'
   */
  public native function getCurrentPosition():Object;

  /**
   * Returns the current position in the format {row: row, column: column}
   * @return A CellContext object describing the current cell.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.CellModel.html#method-getPosition Original Ext JS documentation of 'getPosition'
   */
  public native function getPosition():CellContext;

  /**
   * Selects a cell by row / column.
   * <pre>
   * var grid = Ext.create('Ext.grid.Panel', {
   *     title: 'Simpsons',
   *     store: {
   *         fields: ['name', 'email', 'phone'],
   *         data: [{
   *             name: "Lisa",
   *             email: "lisa&#64;simpsons.com",
   *             phone: "555-111-1224"
   *         }]
   *     },
   *     columns: [{
   *         text: 'Name',
   *         dataIndex: 'name'
   *     }, {
   *         text: 'Email',
   *         dataIndex: 'email',
   *         hidden: true
   *     }, {
   *         text: 'Phone',
   *         dataIndex: 'phone',
   *         flex: 1
   *     }],
   *     height: 200,
   *     width: 400,
   *     renderTo: Ext.getBody(),
   *     selType: 'cellmodel',
   *     tbar: [{
   *         text: 'Select position Object',
   *         handler: function() {
   *             grid.getSelectionModel().select({
   *                 row: grid.getStore().getAt(0),
   *                 column: grid.down('gridcolumn[dataIndex=name]')
   *             });
   *         }
   *     }, {
   *         text: 'Select position by Number',
   *         handler: function() {
   *             grid.getSelectionModel().select({
   *                 row: 0,
   *                 column: 1
   *             });
   *         }
   *     }]
   * });
   * </pre>
   * @param records An array of records or an index
   * @param keepExisting True to retain existing selections
   * @default false
   * @param suppressEvent True to not fire a select event
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.CellModel.html#method-select Original Ext JS documentation of 'select'
   */
  override public native function select(records:*, keepExisting:Boolean = false, suppressEvent:Boolean = false):void;

  [Deprecated(replacement="setPosition", since="5.0.1")]
  /**
   * Sets the current position.
   * @param pos The position to set. May be an object of
   * the form <code>{row:1, column:2}</code>
   * @param suppressEvent True to suppress selection events
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.CellModel.html#method-setCurrentPosition Original Ext JS documentation of 'setCurrentPosition'
   */
  public native function setCurrentPosition(pos:*, suppressEvent:Boolean):void;

  /**
   * Sets the current position.
   * <p>Note that if passing a column index, it is the index within the <i>visible</i> column set.</p>
   * @param pos The position to set. May be an object of the form
   * <code>{ row: 1, column: 2 }</code>
   * @param suppressEvent True to suppress selection events
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.CellModel.html#method-setPosition Original Ext JS documentation of 'setPosition'
   */
  public native function setPosition(pos:*, suppressEvent:Boolean):void;
}
}