package ext.selection {

[Native("Ext.selection.DataViewModel", require)]
/**
 * @see ext.selection.events.DataViewSelectionModel_record_indexEvent.BEFORE_DESELECT
 * @eventType ext.selection.events.DataViewSelectionModel_record_indexEvent.BEFORE_DESELECT
 */
[Event(name='onBeforeDeselect', type='ext.selection.events.DataViewSelectionModel_record_indexEvent')]
/**
 * @see ext.selection.events.DataViewSelectionModel_record_indexEvent.BEFORE_SELECT
 * @eventType ext.selection.events.DataViewSelectionModel_record_indexEvent.BEFORE_SELECT
 */
[Event(name='onBeforeSelect', type='ext.selection.events.DataViewSelectionModel_record_indexEvent')]
/**
 * @see ext.selection.events.DataViewSelectionModel_recordEvent.DESELECT
 * @eventType ext.selection.events.DataViewSelectionModel_recordEvent.DESELECT
 */
[Event(name='onDeselect', type='ext.selection.events.DataViewSelectionModel_recordEvent')]
/**
 * @see ext.selection.events.DataViewSelectionModel_record_indexEvent.SELECT
 * @eventType ext.selection.events.DataViewSelectionModel_record_indexEvent.SELECT
 */
[Event(name='onSelect', type='ext.selection.events.DataViewSelectionModel_record_indexEvent')]
/**
 * The DataViewModel selection model implements item-based selection for Ext.view.View.
 * DataViewModel is the default dataview selection model and generally will not need to
 * be specified.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.DataViewModel.html Original Ext JS documentation of 'Ext.selection.DataViewModel'
 */
public class DataViewSelectionModel extends SelectionModel {
  /**
   * @param config @inheritDoc
   */
  public function DataViewSelectionModel(config:DataViewSelectionModel = null) {
    super();
  }

  [Deprecated(replacement="ext.view.NavigationModelView", since="5.1.0")]
  [ExtConfig]
  /**
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.DataViewModel.html#cfg-enableKeyNav Original Ext JS documentation of 'enableKeyNav'
   */
  public native function get enableKeyNav():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableKeyNav(value:Boolean):void;
}
}