package ext.selection {

[Native("Ext.selection.RowModel", require)]
/**
 * @see ext.selection.events.RowSelectionModel_record_indexEvent.BEFORE_DESELECT
 * @eventType ext.selection.events.RowSelectionModel_record_indexEvent.BEFORE_DESELECT
 */
[Event(name='onBeforeDeselect', type='ext.selection.events.RowSelectionModel_record_indexEvent')]
/**
 * @see ext.selection.events.RowSelectionModel_record_indexEvent.BEFORE_SELECT
 * @eventType ext.selection.events.RowSelectionModel_record_indexEvent.BEFORE_SELECT
 */
[Event(name='onBeforeSelect', type='ext.selection.events.RowSelectionModel_record_indexEvent')]
/**
 * @see ext.selection.events.RowSelectionModel_record_indexEvent.DESELECT
 * @eventType ext.selection.events.RowSelectionModel_record_indexEvent.DESELECT
 */
[Event(name='onDeselect', type='ext.selection.events.RowSelectionModel_record_indexEvent')]
/**
 * @see ext.selection.events.RowSelectionModel_record_indexEvent.SELECT
 * @eventType ext.selection.events.RowSelectionModel_record_indexEvent.SELECT
 */
[Event(name='onSelect', type='ext.selection.events.RowSelectionModel_record_indexEvent')]
/**
 * RowModel Selection Model implements row based navigation for
 * <i>grid panels</i> (→<code>ext.grid.GridPanel</code>) via user input. RowModel is the default grid selection
 * model and, generally, will not need to be specified.
 * <p>By utilizing the selModel config as an object, you may also set configurations for:</p>
 * <ul>
 * <li>→<code>mode</code> - Specifies whether user may select multiple rows or single rows</li>
 * <li>→<code>allowDeselect</code> - Specifies whether user may deselect records when in SINGLE mode</li>
 * <li>→<code>ignoreRightMouseSelection</code> - Specifies whether user may ignore right clicks
 * for selection purposes</li>
 * </ul>
 * <p>In the example below, we've enabled MULTI mode. This means that multiple rows can be selected.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var store = Ext.create('Ext.data.Store', {
 *     fields: ['name', 'email', 'phone'],
 *     data: [
 *         { name: 'Lisa', email: 'lisa&#64;simpsons.com', phone: '555-111-1224' },
 *         { name: 'Bart', email: 'bart&#64;simpsons.com', phone: '555-222-1234' },
 *         { name: 'Homer', email: 'homer&#64;simpsons.com', phone: '555-222-1244' },
 *         { name: 'Marge', email: 'marge&#64;simpsons.com', phone: '555-222-1254' }
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     title: 'Simpsons',
 *     store: store,
 *     width: 400,
 *     renderTo: Ext.getBody(),
 *     selModel: {
 *        selType: 'rowmodel', // rowmodel is the default selection model
 *        mode: 'MULTI' // Allows selection of multiple rows
 *     },
 *     columns: [
 *         { text: 'Name',  dataIndex: 'name'  },
 *         { text: 'Email', dataIndex: 'email', flex: 1 },
 *         { text: 'Phone', dataIndex: 'phone' }
 *     ]
 * });
 * </pre>
 * @see ext.grid.GridPanel
 * @see #mode
 * @see #allowDeselect
 * @see #ignoreRightMouseSelection
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.RowModel.html Original Ext JS documentation of 'Ext.selection.RowModel'
 */
public class RowSelectionModel extends DataViewSelectionModel {
  /**
   * @param config @inheritDoc
   */
  public function RowSelectionModel(config:RowSelectionModel = null) {
    super();
  }

  [ExtConfig]
  /**
   * Set to <code>true</code> to deselect current selection when the container body is clicked.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.RowModel.html#cfg-deselectOnContainerClick Original Ext JS documentation of 'deselectOnContainerClick'
   */
  public native function get deselectOnContainerClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set deselectOnContainerClick(value:Boolean):void;

  [ExtConfig]
  /**
   * Turns on/off keyboard navigation within the grid.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.RowModel.html#cfg-enableKeyNav Original Ext JS documentation of 'enableKeyNav'
   */
  override public native function get enableKeyNav():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set enableKeyNav(value:Boolean):void;

  [Deprecated(replacement="getNavigationModel", since="5.0.1")]
  /**
   * Returns position of the first selected cell in the selection in the format
   * {row: row, column: column}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.RowModel.html#method-getCurrentPosition Original Ext JS documentation of 'getCurrentPosition'
   */
  public native function getCurrentPosition():Object;

  /**
   * Selects the record immediately following the currently selected record.
   * @param keepExisting True to retain existing selections
   * @param suppressEvent Set to false to not fire a select event
   * @return <code>true</code> if there is a next record, else <code>false</code>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.RowModel.html#method-selectNext Original Ext JS documentation of 'selectNext'
   */
  public native function selectNext(keepExisting:Boolean = false, suppressEvent:Boolean = false):Boolean;

  /**
   * Selects the record that precedes the currently selected record.
   * @param keepExisting True to retain existing selections
   * @param suppressEvent Set to false to not fire a select event
   * @return <code>true</code> if there is a previous record, else <code>false</code>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.RowModel.html#method-selectPrevious Original Ext JS documentation of 'selectPrevious'
   */
  public native function selectPrevious(keepExisting:Boolean = false, suppressEvent:Boolean = false):Boolean;
}
}