package ext.selection {
import ext.data.AbstractStore;
import ext.data.Store;
import ext.mixin.IFactoryable;
import ext.mixin.Observable;
import ext.util.IStoreHolder;
import ext.view.DataView;

[Native("Ext.selection.Model", require)]
/**
 * @see ext.selection.events.SelectionModel_oldFocused_newFocusedEvent.FOCUS_CHANGE
 * @eventType ext.selection.events.SelectionModel_oldFocused_newFocusedEvent.FOCUS_CHANGE
 */
[Event(name='onFocusChange', type='ext.selection.events.SelectionModel_oldFocused_newFocusedEvent')]
/**
 * @see ext.selection.events.SelectionModel_selectedEvent.SELECTION_CHANGE
 * @eventType ext.selection.events.SelectionModel_selectedEvent.SELECTION_CHANGE
 */
[Event(name='onSelectionChange', type='ext.selection.events.SelectionModel_selectedEvent')]
/**
 * Tracks what records are currently selected in a data-bound component.
 * <p>This is an abstract class and is not meant to be directly used. Data-bound UI widgets such as
 * <i>Grid</i> (→<code>ext.grid.GridPanel</code>) and <i>Tree</i> (→<code>ext.tree.TreePanel</code>) should subclass Ext.selection.Model
 * and provide a way to binding to the component.</p>
 * <p>The abstract method <code>→onSelectChange()</code> should be implemented in these
 * subclasses to update the UI widget.</p>
 * @see ext.grid.GridPanel
 * @see ext.tree.TreePanel
 * @see #onSelectChange()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html Original Ext JS documentation of 'Ext.selection.Model'
 */
public class SelectionModel extends Observable implements IStoreHolder, IFactoryable {
  /**
   * @param config @inheritDoc
   */
  public function SelectionModel(config:SelectionModel = null) {
    super();
  }

  [ExtConfig]
  /**
   * Allow users to deselect a record in a DataView, List or Grid.
   * Only applicable when the →<code>mode</code> is 'SINGLE'.
   * @default undefined
   * @see #mode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#cfg-allowDeselect Original Ext JS documentation of 'allowDeselect'
   */
  public native function get allowDeselect():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowDeselect(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get autoDestroyBoundStore():Boolean;

  /**
   * @inheritDoc
   */
  public native function set autoDestroyBoundStore(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  [ExtConfig]
  /**
   * True to ignore selections that are made when using the right mouse button if there are
   * records that are already selected. If no records are selected, selection will continue
   * as normal
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#cfg-ignoreRightMouseSelection Original Ext JS documentation of 'ignoreRightMouseSelection'
   */
  public native function get ignoreRightMouseSelection():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ignoreRightMouseSelection(value:Boolean):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated
   * <i>selection model</i> (→<code>ext.selection.SelectionModel</code>), or subclass thereof.
   * @default true
   * @see ext.selection.SelectionModel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#property-isSelectionModel Original Ext JS documentation of 'isSelectionModel'
   */
  public native function get isSelectionModel():Boolean;

  /**
   * @private
   */
  public native function set isSelectionModel(value:Boolean):void;

  [ExtConfig]
  /**
   * Mode of selection. Valid values are:
   * <ul>
   * <li><b>"SINGLE"</b> - Only allows selecting one item at a time. Use →<code>allowDeselect</code>
   * to allow deselecting that item. Also see →<code>toggleOnClick</code>. This is the default.</li>
   * <li><b>"SIMPLE"</b> - Allows simple selection of multiple items one-by-one. Each click in grid
   * will either select or deselect an item.</li>
   * <li><b>"MULTI"</b> - Allows complex selection of multiple items using Ctrl and Shift keys.</li>
   * </ul>
   * @see #allowDeselect
   * @see #toggleOnClick
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#cfg-mode Original Ext JS documentation of 'mode'
   */
  public native function get mode():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set mode(value:String):void;

  [ExtConfig]
  /**
   * Remove records from the selection when they are removed from the store.
   * <p><b>Important:</b> When using <i>paging</i> (→<code>ext.toolbar.PagingToolbar</code>) or a
   * →<code>ext.data.BufferedStore</code>, records which are cached in the Store's
   * <i>data collection</i> (→<code>ext.data.Store.data</code>) may be removed from the Store
   * when pages change, or when rows are scrolled out of view. For this reason <code>→pruneRemoved</code>
   * should be set to <code>false</code> when using a buffered Store.</p>
   * <p>Also, when previously pruned pages are returned to the cache, the records objects in the page
   * will be <i>new instances</i>, and will not match the instances in the selection model's
   * collection. For this reason, you MUST ensure that the Model definition's
   * →<code>ext.data.Model.idProperty</code> references a unique key because
   * in this situation, records in the Store have their <b>IDs</b> compared to records
   * in the SelectionModel in order to re-select a record which is scrolled back into view.</p>
   * @default true
   * @see ext.toolbar.PagingToolbar
   * @see ext.data.BufferedStore
   * @see ext.data.Store#data
   * @see #pruneRemoved
   * @see ext.data.Model#idProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#cfg-pruneRemoved Original Ext JS documentation of 'pruneRemoved'
   */
  public native function get pruneRemoved():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pruneRemoved(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to toggle the selection state of an item when clicked.
   * Only applicable when the →<code>mode</code> is 'SINGLE'.
   * Only applicable when the →<code>allowDeselect</code> is 'true'.
   * @default true
   * @see #mode
   * @see #allowDeselect
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#cfg-toggleOnClick Original Ext JS documentation of 'toggleOnClick'
   */
  public native function get toggleOnClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set toggleOnClick(value:Boolean):void;

  /**
   * Allows multiple views to be controlled by one selection model.
   * Called by AbstractView's beforeRender method.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param view The View passes itself
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-beforeViewRender Original Ext JS documentation of 'beforeViewRender'
   */
  protected native function beforeViewRender(view:DataView):void;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-bindComponent Original Ext JS documentation of 'bindComponent'
   */
  public native function bindComponent():void;

  /**
   * @inheritDoc
   */
  public native function bindStore(store:Store = undefined, initial:Boolean = undefined, propertyName:* = undefined):void;

  /**
   * Binds listeners for this component to the store. By default it will add
   * anything bound by the getStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to bind to
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-bindStoreListeners Original Ext JS documentation of 'bindStoreListeners'
   */
  protected native function bindStoreListeners(store:AbstractStore):void;

  /**
   * Deselects a record instance by record instance or index.
   * @param records An array of records or an index
   * @param suppressEvent True to not fire a deselect event
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-deselect Original Ext JS documentation of 'deselect'
   */
  public native function deselect(records:*, suppressEvent:Boolean = false):void;

  /**
   * Deselects all records in the view.
   * @param suppressEvent True to suppress any deselect events
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-deselectAll Original Ext JS documentation of 'deselectAll'
   */
  public native function deselectAll(suppressEvent:Boolean = false):void;

  /**
   * Deselects a range of rows if the selection model <i>is not locked</i> (→<code>isLocked()</code>).
   * @param startRow The record or index of the first row in the range
   * @param endRow The record or index of the last row in the range
   * @see #isLocked()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-deselectRange Original Ext JS documentation of 'deselectRange'
   */
  public native function deselectRange(startRow:Number, endRow:Number):void;

  /**
   * Returns the count of selected records.
   * @return The number of selected records
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-getCount Original Ext JS documentation of 'getCount'
   */
  public native function getCount():Number;

  [ArrayElementType("ext.data.Model")]
  /**
   * Returns an array of the currently selected records.
   * @return The selected records
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-getSelection Original Ext JS documentation of 'getSelection'
   */
  public native function getSelection():Array;

  /**
   * Returns the current selectionMode.
   * @return The selectionMode: 'SINGLE', 'MULTI' or 'SIMPLE'.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-getSelectionMode Original Ext JS documentation of 'getSelectionMode'
   */
  public native function getSelectionMode():String;

  /**
   * @inheritDoc
   */
  public native function getStore():AbstractStore;

  /**
   * Gets the listeners to bind to a new store.
   * @param store The Store which is being bound to for which a listeners object
   * should be returned.
   * @return The listeners to be bound to the store in object literal form. The scope
   * may be omitted, it is assumed to be the current instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-getStoreListeners Original Ext JS documentation of 'getStoreListeners'
   */
  protected native function getStoreListeners(store:Store):Object;

  /**
   * Returns true if there are any a selected records.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-hasSelection Original Ext JS documentation of 'hasSelection'
   */
  public native function hasSelection():Boolean;

  /**
   * Returns true if the selections are locked.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-isLocked Original Ext JS documentation of 'isLocked'
   */
  public native function isLocked():Boolean;

  /**
   * Returns true if the specified row is selected.
   * @param startRow The start of the range to check.
   * @param endRow The end of the range to check.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-isRangeSelected Original Ext JS documentation of 'isRangeSelected'
   */
  public native function isRangeSelected(startRow:*, endRow:*):Boolean;

  /**
   * Returns true if the specified row is selected.
   * @param record The record or index of the record to check
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-isSelected Original Ext JS documentation of 'isSelected'
   */
  public native function isSelected(record:*):Boolean;

  /**
   * Template method, it is called when a new store is bound
   * to the current instance.
   * @param store The store being bound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onBindStore Original Ext JS documentation of 'onBindStore'
   */
  protected native function onBindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-onEditorKey Original Ext JS documentation of 'onEditorKey'
   */
  public native function onEditorKey():void;

  /**
   * Called by the owning grid's <i>header container</i> (→<code>ext.grid.header.HeaderContainer</code>)
   * when a column header is activated by the UI
   * (clicked, or receives a <code>SPACE</code> or <code>ENTER</code> key event).
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see ext.grid.header.HeaderContainer
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-onHeaderClick Original Ext JS documentation of 'onHeaderClick'
   */
  protected native function onHeaderClick():void;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-onSelectChange Original Ext JS documentation of 'onSelectChange'
   */
  public native function onSelectChange(record:*, isSelected:*, suppressEvent:*, commitFn:*):void;

  /**
   * Template method, it is called when an existing store is unbound
   * from the current instance.
   * @param store The store being unbound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onUnbindStore Original Ext JS documentation of 'onUnbindStore'
   */
  protected native function onUnbindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * Selects a record instance by record instance or index.
   * @param records An array of records or an index
   * @param keepExisting True to retain existing selections
   * @default false
   * @param suppressEvent True to not fire a select event
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-select Original Ext JS documentation of 'select'
   */
  public native function select(records:*, keepExisting:Boolean = false, suppressEvent:Boolean = false):void;

  /**
   * Selects all records in the view.
   * @param suppressEvent True to suppress any select events
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-selectAll Original Ext JS documentation of 'selectAll'
   */
  public native function selectAll(suppressEvent:Boolean):void;

  /**
   * Selects a range of rows if the selection model <i>is not locked</i> (→<code>isLocked()</code>).
   * All rows in between startRow and endRow are also selected.
   * @param startRow The record or index of the first row in the range
   * @param endRow The record or index of the last row in the range
   * @param keepExisting True to retain existing selections
   * @see #isLocked()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-selectRange Original Ext JS documentation of 'selectRange'
   */
  public native function selectRange(startRow:Number, endRow:Number, keepExisting:Boolean = false):void;

  /**
   * Locks the current selection and disables any changes from happening to the selection.
   * @param locked True to lock, false to unlock.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-setLocked Original Ext JS documentation of 'setLocked'
   */
  public native function setLocked(locked:Boolean):void;

  /**
   * Sets the current selectionMode.
   * @param selMode 'SINGLE', 'MULTI' or 'SIMPLE'.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.Model.html#method-setSelectionMode Original Ext JS documentation of 'setSelectionMode'
   */
  public native function setSelectionMode(selMode:String):void;

  /**
   * @inheritDoc
   */
  public native function setStore(store:Object):void;

  /**
   * Unbinds listeners from this component to the store. By default it will remove
   * anything bound by the bindStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to unbind from
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-unbindStoreListeners Original Ext JS documentation of 'unbindStoreListeners'
   */
  protected native function unbindStoreListeners(store:AbstractStore):void;
}
}