package ext.selection {

[Native("Ext.selection.TreeModel", require)]
/**
 * This selection model is created by default for →<code>ext.tree.TreePanel</code>.
 * <p>It implements a row selection model.</p>
 * @see ext.tree.TreePanel
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.TreeModel.html Original Ext JS documentation of 'Ext.selection.TreeModel'
 */
public class TreeSelectionModel extends RowSelectionModel {
  /**
   * @param config @inheritDoc
   */
  public function TreeSelectionModel(config:TreeSelectionModel = null) {
    super();
  }

  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.TreeModel.html#cfg-pruneRemoved Original Ext JS documentation of 'pruneRemoved'
   */
  override public native function get pruneRemoved():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set pruneRemoved(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to select the row when clicking on the icon to collapse or expand
   * a tree node.
   * @default false
   * @since 5.1.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.TreeModel.html#cfg-selectOnExpanderClick Original Ext JS documentation of 'selectOnExpanderClick'
   */
  public native function get selectOnExpanderClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set selectOnExpanderClick(value:Boolean):void;
}
}