package ext.selection.events {
import ext.data.Model;
import ext.selection.CellSelectionModel;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.selection.events.CellSelectionModel_record_row_columnEvent")]
public class CellSelectionModel_record_row_columnEvent extends FlExtEvent {
  /**
   * Fired after a cell is deselected
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.CellModel.html#event-deselect Original Ext JS documentation of 'deselect'
   * @see ext.selection.CellSelectionModel
   * @eventType onDeselect
   */
  public static const DESELECT:String = "onDeselect";
  /**
   * Fired after a cell is selected
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.selection.CellModel.html#event-select Original Ext JS documentation of 'select'
   * @see ext.selection.CellSelectionModel
   * @eventType onSelect
   */
  public static const SELECT:String = "onSelect";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "record", "row", "column", "eOpts"];

  public function CellSelectionModel_record_row_columnEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The column index deselected
   */
  public native function get column():Number;

  /**
   * The record of the deselected cell
   */
  public native function get record():Model;

  /**
   * The row index deselected
   */
  public native function get row():Number;

  public native function get source():CellSelectionModel;
}
}