package ext.slider {
import ext.Base;
import ext.XTemplate;
import ext.form.field.BaseField;
import ext.form.field.IField;

[Native("Ext.slider.Multi", require)]
/**
 * @see ext.slider.events.MultiSlider_newValue_oldValue_thumb_typeEvent.BEFORE_CHANGE
 * @eventType ext.slider.events.MultiSlider_newValue_oldValue_thumb_typeEvent.BEFORE_CHANGE
 */
[Event(name='onBeforeChange', type='ext.slider.events.MultiSlider_newValue_oldValue_thumb_typeEvent')]
/**
 * @see ext.slider.events.MultiSlider_newValue_thumb_typeEvent.CHANGE
 * @eventType ext.slider.events.MultiSlider_newValue_thumb_typeEvent.CHANGE
 */
[Event(name='onChange', type='ext.slider.events.MultiSlider_newValue_thumb_typeEvent')]
/**
 * @see ext.slider.events.MultiSlider_newValue_thumbEvent.CHANGE_COMPLETE
 * @eventType ext.slider.events.MultiSlider_newValue_thumbEvent.CHANGE_COMPLETE
 */
[Event(name='onChangeComplete', type='ext.slider.events.MultiSlider_newValue_thumbEvent')]
/**
 * @see ext.slider.events.MultiSlider_eEvent.DRAG
 * @eventType ext.slider.events.MultiSlider_eEvent.DRAG
 */
[Event(name='onDrag', type='ext.slider.events.MultiSlider_eEvent')]
/**
 * @see ext.slider.events.MultiSlider_eEvent.DRAG_END
 * @eventType ext.slider.events.MultiSlider_eEvent.DRAG_END
 */
[Event(name='onDragEnd', type='ext.slider.events.MultiSlider_eEvent')]
/**
 * @see ext.slider.events.MultiSlider_eEvent.DRAG_START
 * @eventType ext.slider.events.MultiSlider_eEvent.DRAG_START
 */
[Event(name='onDragStart', type='ext.slider.events.MultiSlider_eEvent')]
/**
 * Slider which supports vertical or horizontal orientation, keyboard adjustments,
 * configurable snapping, axis clicking and animation. Can be added as an item to any container.
 * <p>Sliders can be created with more than one thumb handle by passing an array of values
 * instead of a single one:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.slider.Multi', {
 *     width: 200,
 *     values: [25, 50, 75],
 *     increment: 5,
 *     minValue: 0,
 *     maxValue: 100,
 *
 *     // this defaults to true, setting to false allows the thumbs to pass each other
 *     constrainThumbs: false,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html Original Ext JS documentation of 'Ext.slider.Multi'
 */
public class MultiSlider extends BaseField {
  /**
   * @param config @inheritDoc
   */
  public function MultiSlider(config:MultiSlider = null) {
    super();
  }

  [ExtConfig]
  /**
   * Turn on or off animation. May be an animation configuration object:
   * <pre>
   * animate: {
   *     duration: 3000,
   *     easing: 'easeIn'
   * }
   * </pre>
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-animate Original Ext JS documentation of 'animate'
   */
  public native function get animated():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set animated(value:*):void;

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default 'slider'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  public native function set ariaRole(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>→itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>→id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>select</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>→renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>select</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>select</code> since it returns multiple
   * elements.</p>
   * @default [
   *     'endEl',
   *     'innerEl'
   * ]
   * @see #childEls
   * @see #itemId
   * @see #id
   * @see ext.view.DataView
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see #renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  override public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set childEls(value:*):void;

  [ExtConfig]
  /**
   * Determines whether or not clicking on the Slider axis will change the slider.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-clickToChange Original Ext JS documentation of 'clickToChange'
   */
  public native function get clickToChange():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set clickToChange(value:Boolean):void;

  [ExtConfig]
  /**
   * True to disallow thumbs from overlapping one another.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-constrainThumbs Original Ext JS documentation of 'constrainThumbs'
   */
  public native function get constrainThumbs():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set constrainThumbs(value:Boolean):void;

  [ExtConfig]
  /**
   * The number of decimal places to which to round the Slider's value.
   * <p>To disable rounding, configure as <b>false</b>.</p>
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-decimalPrecision Original Ext JS documentation of 'decimalPrecision'
   */
  public native function get decimalPrecision():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set decimalPrecision(value:*):void;

  /**
   * This property is used to determine the property of a <code>→bind</code> config that is just
   * the value. For example, if <code>defaultBindProperty="value"</code>, then this shorthand
   * <code>→bind</code> config:
   * <pre>
   *  bind: '{name}'
   * </pre>
   * <p>Is equivalent to this object form:</p>
   * <pre>
   *  bind: {
   *      value: '{name}'
   *  }
   * </pre>
   * <p>The <code>→defaultBindProperty</code> is set to "value" for form fields and to "store" for
   * grids and trees.</p>
   * @default 'value'
   * @see #bind
   * @see #defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#property-defaultBindProperty Original Ext JS documentation of 'defaultBindProperty'
   */
  override public native function get defaultBindProperty():String;

  /**
   * @private
   */
  override public native function set defaultBindProperty(value:String):void;

  /**
   * True while the thumb is in a drag operation
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#property-dragging Original Ext JS documentation of 'dragging'
   */
  public native function get dragging():Boolean;

  /**
   * @private
   */
  public native function set dragging(value:Boolean):void;

  [ExtConfig]
  /**
   * The content of the field body is defined by this config option.
   * @default [
   *     '<div id="{id}" data-ref="inputEl" {inputAttrTpl}',
   *     ' class="',
   *     Ext.baseCSSPrefix,
   *     'slider {fieldCls} {vertical}',
   *     '{childElCls}"',
   *     '<tpl if="tabIdx != null"> tabindex="{tabIdx}"</tpl>',
   *     '<tpl foreach="ariaElAttributes"> {$}="{.}"</tpl>',
   *     '<tpl foreach="inputElAriaAttributes"> {$}="{.}"</tpl>',
   *     '>',
   *     '<div id="{cmpId}-endEl" data-ref="endEl" class="' + Ext.baseCSSPrefix + 'slider-end" role="presentation">',
   *     '<div id="{cmpId}-innerEl" data-ref="innerEl" class="' + Ext.baseCSSPrefix + 'slider-inner" role="presentation">',
   *     '{%this.renderThumbs(out, values)%}',
   *     '</div>',
   *     '</div>',
   *     '</div>',
   *     {
   *         renderThumbs: function(out, values) {
   *             var me = values.$comp,
   *                 i = 0,
   *                 thumbs = me.thumbs,
   *                 len = thumbs.length,
   *                 thumb, thumbConfig;
   *             for (; i < len; i++) {
   *                 thumb = thumbs[i];
   *                 thumbConfig = thumb.getElConfig();
   *                 thumbConfig.id = me.id + '-thumb-' + i;
   *                 Ext.DomHelper.generateMarkup(thumbConfig, out);
   *             }
   *         },
   *         disableFormats: true
   *     }
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-fieldSubTpl Original Ext JS documentation of 'fieldSubTpl'
   */
  public native function get fieldSubTpl():XTemplate;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fieldSubTpl(value:XTemplate):void;

  [ExtConfig]
  /**
   * The CSS class to use when the field receives focus
   * @default 'slider-focus'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-focusCls Original Ext JS documentation of 'focusCls'
   */
  override public native function get focusCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set focusCls(value:String):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default true
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  override public native function get focusable():Boolean;

  /**
   * @private
   */
  override public native function set focusable(value:Boolean):void;

  [ExtConfig]
  /**
   * How many units to change the slider when adjusting by drag and drop. Use this option
   * to enable 'snapping'.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-increment Original Ext JS documentation of 'increment'
   */
  public native function get increment():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set increment(value:Number):void;

  [ExtConfig]
  /**
   * How many units to change the Slider when adjusting with keyboard navigation. If the increment
   * config is larger, it will be used instead.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-keyIncrement Original Ext JS documentation of 'keyIncrement'
   */
  public native function get keyIncrement():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set keyIncrement(value:Number):void;

  [ExtConfig]
  /**
   * The maximum value for the Slider.
   * @default 100
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-maxValue Original Ext JS documentation of 'maxValue'
   * @see #setMaxValue()
   */
  public native function get maxValue():Number;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set maxValue(value:Number):void;

  [ExtConfig]
  /**
   * The minimum value for the Slider.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-minValue Original Ext JS documentation of 'minValue'
   * @see #setMinValue()
   */
  public native function get minValue():Number;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set minValue(value:Number):void;

  [ExtConfig]
  /**
   * How many units to change the Slider when using PageUp and PageDown keys.
   * @default 10
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-pageSize Original Ext JS documentation of 'pageSize'
   */
  public native function get pageSize():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pageSize(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default [
   *     'value'
   * ]
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  override public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set publishes(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * Sets a DOM tabIndex for this field. tabIndex may be set to <code>-1</code> in order to remove
   * the field from the tab rotation.
   * <p><b>Note:</b> tabIndex only applies to fields that are rendered. It does not effect
   * fields built via applyTo</p>
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-tabIndex Original Ext JS documentation of 'tabIndex'
   * @see #getTabIndex()
   * @see #setTabIndex()
   */
  override public native function get tabIndex():Number;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set tabIndex(value:Number):void;

  [ExtConfig]
  /**
   * Configure as true to allow thumbs to be added and removed dynamically from the slider
   * when calling →<code>setValue()</code> with an an array of values differing from the
   * current number of thumbs.
   * <p>You will need to set →<code>values</code> explicitly when configuring the slider if</p>
   * <ol>
   * <li>thumbPerValue is false and 2) the slider has multiple thumbs (values).</li>
   * </ol>
   * @default false
   * @since 6.5.0
   * @see #setValue()
   * @see #values
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-thumbPerValue Original Ext JS documentation of 'thumbPerValue'
   */
  public native function get thumbPerValue():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set thumbPerValue(value:Boolean):void;

  /**
   * Array containing references to each thumb
   * @default []
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#property-thumbs Original Ext JS documentation of 'thumbs'
   */
  public native function get thumbs():Array;

  /**
   * @private
   */
  public native function set thumbs(value:Array):void;

  [ExtConfig]
  /**
   * A function used to display custom text for the slider tip or the name of the
   * method on the corresponding <code>controller (→ext.app.ViewController)</code>.
   * <p>Defaults to null, which will use the default on the plugin.</p>
   * @default null
   * <ul>
   * <li><code>thumb:ext.Base</code> (optional) —
   * The Thumb that the Tip is attached to
   * </li>
   * <li><code>return:String</code> (optional) —
   * The text to display in the tip
   * </li>
   * </ul>
   * @see ext.app.ViewController
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-tipText Original Ext JS documentation of 'tipText'
   */
  public native function get tipText():Function;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tipText(value:Function):void;

  [ExtConfig]
  /**
   * True to use an →<code>ext.slider.SliderTip</code> to display tips for the value. This option may also
   * provide a configuration object for an →<code>ext.slider.SliderTip</code>.
   * @default true
   * @see ext.slider.SliderTip
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-useTips Original Ext JS documentation of 'useTips'
   */
  public native function get useTips():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set useTips(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * A value with which to initialize the slider. Setting this will only result in the creation
   * of a single slider thumb; if you want multiple thumbs then use the →<code>values</code>
   * config instead.
   * <p>Defaults to #minValue.</p>
   * @see #values
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  override public native function get value():Object;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set value(value:Object):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * Array of Number values with which to initalize the slider. A separate slider thumb
   * will be created for each value in this array. This will take precedence over the single
   * →<code>value</code> config.
   * @see #value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-values Original Ext JS documentation of 'values'
   * @see #getValues()
   */
  public native function get values():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set values(value:Array):void;

  [ExtConfig]
  /**
   * Orient the Slider vertically rather than horizontally.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-vertical Original Ext JS documentation of 'vertical'
   */
  public native function get vertical():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set vertical(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to <code>true</code> to calculate snap points based on →<code>increment</code>s from zero as opposed to
   * from this Slider's →<code>minValue</code>.
   * <p>By Default, valid snap points are calculated starting →<code>increment</code>s from the
   * →<code>minValue</code></p>
   * @default false
   * @see #increment
   * @see #minValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#cfg-zeroBasedSnapping Original Ext JS documentation of 'zeroBasedSnapping'
   */
  public native function get zeroBasedSnapping():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set zeroBasedSnapping(value:Boolean):void;

  /**
   * Creates a new thumb and adds it to the slider
   * @param value The initial value to set on the thumb.
   * @default 0
   * @return The thumb
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#method-addThumb Original Ext JS documentation of 'addThumb'
   */
  public native function addThumb(value:Number = 0):Base;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  override public native function getChildEls():*;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  override public native function getPublishes():*;

  /**
   * Returns the current value of the slider
   * @return The current value of the slider at the given index,
   * or an array of all thumb values if no index is given.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#method-getValue Original Ext JS documentation of 'getValue'
   */
  override public native function getValue():*;

  [ArrayElementType("Number")]
  /**
   * Returns an array of values - one for the location of each thumb
   * @return The set of thumb values
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#method-getValues Original Ext JS documentation of 'getValues'
   */
  public native function getValues():Array;

  /**
   * Removes a thumb from the slider
   * @param thumb The index of the thumb within the slider to remove,
   * or the thumb itself
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#method-removeThumb Original Ext JS documentation of 'removeThumb'
   */
  public native function removeThumb(thumb:*):void;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  override public native function setChildEls(childEls:*):void;

  /**
   * Sets the maximum value for the slider instance. If the current value is more than
   * the maximum value, the current value will be changed.
   * @param val The new maximum value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#method-setMaxValue Original Ext JS documentation of 'setMaxValue'
   */
  public native function setMaxValue(val:Number):SliderField;

  /**
   * Sets the minimum value for the slider instance. If the current value is less than
   * the minimum value, the current value will be changed.
   * @param val The new minimum value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#method-setMinValue Original Ext JS documentation of 'setMinValue'
   */
  public native function setMinValue(val:Number):SliderField;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  override public native function setPublishes(publishes:*):void;

  /**
   * Programmatically sets the value of the Slider. Ensures that the value is constrained within
   * the minValue and maxValue.
   * <p>Setting the second slider's value without animation:</p>
   * <pre>
   * mySlider.setValue(1, 50, false);
   * </pre>
   * <p>Setting multiple values with animation:</p>
   * <pre>
   * mySlider.setValue([20, 40, 60], true);
   * </pre>
   * @param value The value to set
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  [Return("this")]
  override public native function setValue(value:*):IField;

  /**
   * Synchronizes thumbs position to the proper proportion of the total component width
   * based on the current slider →<code>value</code>. This will be called automatically
   * when the Slider is resized by a layout, but if it is rendered auto width,
   * this method can be called from another resize handler to sync the Slider if necessary.
   * @see #value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#method-syncThumbs Original Ext JS documentation of 'syncThumbs'
   */
  public native function syncThumbs():void;
}
}