package ext.slider {
import ext.form.field.IField;

[Native("Ext.slider.Single", require)]
/**
 * Slider which supports vertical or horizontal orientation, keyboard adjustments,
 * configurable snapping, axis clicking and animation. Can be added as an item to any container.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.slider.Single', {
 *     width: 200,
 *     value: 50,
 *     increment: 10,
 *     minValue: 0,
 *     maxValue: 100,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p>The class Ext.slider.Single is aliased to Ext.Slider for backwards compatibility.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Single.html Original Ext JS documentation of 'Ext.slider.Single'
 */
public class SliderField extends MultiSlider {
  /**
   * @param config @inheritDoc
   */
  public function SliderField(config:SliderField = null) {
    super();
  }

  [ExtConfig]
  /**
   * This controls when the value of the slider is published to the <code>ViewModel</code>. By
   * default this is done only when the thumb is released (the change is complete). To
   * cause this to happen on every change of the thumb position, specify <code>false</code>. This
   * setting is <code>true</code> by default for improved performance on slower devices (such as
   * older browsers or tablets).
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Single.html#cfg-publishOnComplete Original Ext JS documentation of 'publishOnComplete'
   */
  public native function get publishOnComplete():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set publishOnComplete(value:Boolean):void;

  /**
   * Returns the current value of the slider
   * @return The current value of the slider
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Single.html#method-getValue Original Ext JS documentation of 'getValue'
   */
  override public native function getValue():*;

  /**
   * Programmatically sets the value of the Slider. Ensures that the value is constrained within
   * the minValue and maxValue.
   * @param value The value to set
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Single.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  [Return("this")]
  override public native function setValue(value:*):IField;
}
}