package ext.slider {
import ext.Base;
import ext.Component;
import ext.Plugin;
import ext.tip.Tip;

[Native("Ext.slider.Tip", require)]
/**
 * Simple plugin for using an Ext.tip.Tip with a slider to show the slider value.
 * In general this class is not created directly, instead pass the →<code>ext.slider.MultiSlider.useTips</code>
 * and →<code>ext.slider.MultiSlider.tipText</code> configuration options to the slider directly.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.slider.Single', {
 *     width: 214,
 *     minValue: 0,
 *     maxValue: 100,
 *     useTips: true,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p>Optionally provide your own tip text by passing tipText:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.slider.Single', {
 *     width: 214,
 *     minValue: 0,
 *     maxValue: 100,
 *     useTips: true,
 *     tipText: function(thumb){
 *         return Ext.String.format('&#42;&#42;{0}% complete&#42;&#42;', thumb.value);
 *     },
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see ext.slider.MultiSlider#useTips
 * @see ext.slider.MultiSlider#tipText
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Tip.html Original Ext JS documentation of 'Ext.slider.Tip'
 */
public class SliderTip extends Tip implements Plugin {
  /**
   * @param config @inheritDoc
   */
  public function SliderTip(config:SliderTip = null) {
    super();
  }

  [ExtConfig]
  /**
   * Alignment configuration for the tip to the slider. See →<code>ext.util.Positionable.alignTo()</code>.
   * Default values for alignment are provided by specifying the →<code>position</code> config.
   * @see ext.util.Positionable#alignTo()
   * @see #position
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Tip.html#cfg-align Original Ext JS documentation of 'align'
   */
  public native function get align():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set align(value:String):void;

  [ExtConfig]
  /**
   * Offsets for aligning the tip to the slider. See →<code>ext.util.Positionable.alignTo()</code>.
   * Default values for offsets are provided by specifying the →<code>position</code> config.
   * @see ext.util.Positionable#alignTo()
   * @see #position
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Tip.html#cfg-offsets Original Ext JS documentation of 'offsets'
   */
  public native function get offsets():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set offsets(value:Array):void;

  [ExtConfig]
  /**
   * Sets the position for where the tip will be displayed related to the thumb. This sets
   * defaults for →<code>align</code> and →<code>offsets</code> configurations. If →<code>align</code> or
   * →<code>offsets</code> configurations are specified, they will override the defaults defined
   * by position.
   * @default For horizontal sliders, "top", for vertical sliders, "left"
   * @see #align
   * @see #offsets
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Tip.html#cfg-position Original Ext JS documentation of 'position'
   */
  public native function get position():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set position(value:String):void;

  /**
   * Used to create the text that appears in the Tip's body. By default this just returns
   * the value of the Slider Thumb that the Tip is attached to. Override to customize.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param thumb The Thumb that the Tip is attached to
   * @return The text to display in the tip
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Tip.html#method-getText Original Ext JS documentation of 'getText'
   */
  protected native function getText(thumb:Base):String;

  public native function init(client:Component):void;
}
}