package ext.slider {
import ext.Widget;

[Native("Ext.slider.Widget", require)]
/**
 * A Widget-based implementation of a slider.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Widget.html Original Ext JS documentation of 'Ext.slider.Widget'
 */
public class SliderWidget extends Widget {
  /**
   * @param config @inheritDoc
   */
  public function SliderWidget(config:SliderWidget = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Determines whether or not clicking on the Slider axis will change the slider.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Widget.html#cfg-clickToChange Original Ext JS documentation of 'clickToChange'
   * @see #getClickToChange()
   * @see #setClickToChange()
   */
  public native function get clickToChange():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set clickToChange(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum value for any slider thumb.
   * @default 100
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Widget.html#cfg-maxValue Original Ext JS documentation of 'maxValue'
   * @see #getMaxValue()
   * @see #setMaxValue()
   */
  public native function get maxValue():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set maxValue(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value for any slider thumb.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Widget.html#cfg-minValue Original Ext JS documentation of 'minValue'
   * @see #getMinValue()
   * @see #setMinValue()
   */
  public native function get minValue():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set minValue(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * This controls when the value of the slider is published to the <code>ViewModel</code>. By
   * default this is done only when the thumb is released (the change is complete). To
   * cause this to happen on every change of the thumb position, specify <code>false</code>. This
   * setting is <code>true</code> by default for improved performance on slower devices (such as
   * older browsers or tablets).
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Widget.html#cfg-publishOnComplete Original Ext JS documentation of 'publishOnComplete'
   * @see #getPublishOnComplete()
   * @see #setPublishOnComplete()
   */
  public native function get publishOnComplete():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set publishOnComplete(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * This object is a map of config property names holding a <code>true</code> if changes to
   * that config should written back to its binding. Most commonly this is used to
   * indicate that the <code>→value</code> config should be monitored and changes written back
   * to the bound value.
   * @default {
   *     value: 1
   * }
   * @see #value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Widget.html#cfg-twoWayBindable Original Ext JS documentation of 'twoWayBindable'
   * @see #getTwoWayBindable()
   * @see #setTwoWayBindable()
   */
  override public native function get twoWayBindable():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set twoWayBindable(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * One more values for the position of the slider's thumb(s).
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Widget.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  public native function get value():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set value(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Orients the slider vertically rather than horizontally.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Widget.html#cfg-vertical Original Ext JS documentation of 'vertical'
   * @see #getVertical()
   * @see #setVertical()
   */
  public native function get vertical():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set vertical(value:Boolean):void;

  /**
   * Returns the value of <code>clickToChange</code>.
   * @see #clickToChange
   */
  public native function getClickToChange():Boolean;

  /**
   * Returns the value of <code>maxValue</code>.
   * @see #maxValue
   */
  public native function getMaxValue():Number;

  /**
   * Returns the value of <code>minValue</code>.
   * @see #minValue
   */
  public native function getMinValue():Number;

  /**
   * Returns the value of <code>publishOnComplete</code>.
   * @see #publishOnComplete
   */
  public native function getPublishOnComplete():Boolean;

  /**
   * Returns the value of <code>twoWayBindable</code>.
   * @see #twoWayBindable
   */
  override public native function getTwoWayBindable():*;

  /**
   * Returns the value of <code>value</code>.
   * @see #value
   */
  public native function getValue():*;

  [ArrayElementType("Number")]
  /**
   * Returns an array of values - one for the location of each thumb
   * @return The set of thumb values
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Widget.html#method-getValues Original Ext JS documentation of 'getValues'
   */
  public native function getValues():Array;

  /**
   * Returns the value of <code>vertical</code>.
   * @see #vertical
   */
  public native function getVertical():Boolean;

  /**
   * Sets the value of <code>clickToChange</code>.
   * @param clickToChange The new value.
   * @see #clickToChange
   */
  public native function setClickToChange(clickToChange:Boolean):void;

  /**
   * Sets the value of <code>maxValue</code>.
   * @param maxValue The new value.
   * @see #maxValue
   */
  public native function setMaxValue(maxValue:Number):void;

  /**
   * Sets the value of <code>minValue</code>.
   * @param minValue The new value.
   * @see #minValue
   */
  public native function setMinValue(minValue:Number):void;

  /**
   * Sets the value of <code>publishOnComplete</code>.
   * @param publishOnComplete The new value.
   * @see #publishOnComplete
   */
  public native function setPublishOnComplete(publishOnComplete:Boolean):void;

  /**
   * Programmatically sets the value of the Slider. Ensures that the value is constrained within
   * the minValue and maxValue.
   * <p>Setting a single value:
   * // Set the second slider value, don't animate
   * mySlider.setThumbValue(1, 50, false);</p>
   * <p>Setting multiple values at once
   * // Set 3 thumb values, animate
   * mySlider.setThumbValue([20, 40, 60], true);</p>
   * @param index Index of the thumb to move. Alternatively, it can be an array
   * of values to set for each thumb in the slider.
   * @param value The value to set the slider to. (This will be constrained within
   * minValue and maxValue)
   * @param animate Turn on or off animation
   * @default true
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Widget.html#method-setThumbValue Original Ext JS documentation of 'setThumbValue'
   */
  public native function setThumbValue(index:*, value:Number, animate:Boolean = true, changeComplete:Boolean = false):MultiSlider;

  /**
   * Sets the value of <code>twoWayBindable</code>.
   * @param twoWayBindable The new value.
   * @see #twoWayBindable
   */
  override public native function setTwoWayBindable(twoWayBindable:*):void;

  /**
   * Sets the value of <code>value</code>.
   * @param value The new value.
   * @see #value
   */
  public native function setValue(value:*):void;

  /**
   * Sets the value of <code>vertical</code>.
   * @param vertical The new value.
   * @see #vertical
   */
  public native function setVertical(vertical:Boolean):void;
}
}