package ext.slider.events {
import ext.slider.MultiSlider;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.slider.events.MultiSlider_newValue_oldValue_thumb_typeEvent")]
public class MultiSlider_newValue_oldValue_thumb_typeEvent extends FlExtEvent {
  /**
   * Fires before the slider value is changed. By returning false from an event handler,
   * you can cancel the event and prevent the slider from changing.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#event-beforechange Original Ext JS documentation of 'beforechange'
   * @see ext.slider.MultiSlider
   * @eventType onBeforeChange
   */
  public static const BEFORE_CHANGE:String = "onBeforeChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["slider", "newValue", "oldValue", "thumb", "typeOfChange", "eOpts"];

  public function MultiSlider_newValue_oldValue_thumb_typeEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The new value which the slider is being changed to,
   * null if the change is a removal of a thumb.
   */
  public native function get newValue():*;

  /**
   * The old value which the slider was previously,
   * null if the change is an addition of a thumb.
   */
  public native function get oldValue():*;

  /**
   * The slider
   */
  public native function get slider():MultiSlider;

  /**
   * The thumb that was will be changed, null if the change
   * is an addition of a thumb.
   */
  public native function get thumb():*;

  /**
   * The type of change that is going to occur (add/update/remove)
   */
  public native function get typeOfChange():String;
}
}