package ext.slider.events {
import ext.Base;
import ext.slider.MultiSlider;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.slider.events.MultiSlider_newValue_thumbEvent")]
public class MultiSlider_newValue_thumbEvent extends FlExtEvent {
  /**
   * Fires when the slider value is changed by the user and any drag operations have completed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#event-changecomplete Original Ext JS documentation of 'changecomplete'
   * @see ext.slider.MultiSlider
   * @eventType onChangeComplete
   */
  public static const CHANGE_COMPLETE:String = "onChangeComplete";
  public static const __PARAMETER_SEQUENCE__:Array = ["slider", "newValue", "thumb", "eOpts"];

  public function MultiSlider_newValue_thumbEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The new value which the slider has been changed to.
   */
  public native function get newValue():Number;

  /**
   * The slider
   */
  public native function get slider():MultiSlider;

  /**
   * The thumb that was changed
   */
  public native function get thumb():Base;
}
}