package ext.slider.events {
import ext.slider.MultiSlider;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.slider.events.MultiSlider_newValue_thumb_typeEvent")]
public class MultiSlider_newValue_thumb_typeEvent extends FlExtEvent {
  /**
   * Fires when the slider value is changed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.slider.Multi.html#event-change Original Ext JS documentation of 'change'
   * @see ext.slider.MultiSlider
   * @eventType onChange
   */
  public static const CHANGE:String = "onChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["slider", "newValue", "thumb", "typeOfChange", "eOpts"];

  public function MultiSlider_newValue_thumb_typeEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The new value which the slider has been changed to,
   * null if the change is the removal of a thumb.
   */
  public native function get newValue():*;

  /**
   * The slider
   */
  public native function get slider():MultiSlider;

  /**
   * The thumb that was changed, null if the change
   * is the removal of a thumb.
   */
  public native function get thumb():*;

  /**
   * The type of change that occurred (add/update/remove)
   */
  public native function get typeOfChange():String;
}
}