package ext.sparkline {

[Native("Ext.sparkline.Bar", require)]
/**
 * Plots a bar chart of the values in the passed →<code>values</code> array.
 * <p>See <i>the base class</i> (→<code>ext.sparkline.SparklineBase</code>) for a simple example.</p>
 * @see #values
 * @see ext.sparkline.SparklineBase
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html Original Ext JS documentation of 'Ext.sparkline.Bar'
 */
public class SparklineBar extends SparklineBarBase {
  /**
   * @param config @inheritDoc
   */
  public function SparklineBar(config:SparklineBar = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The bar color for positive values.
   * @default '#3366cc'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html#cfg-barColor Original Ext JS documentation of 'barColor'
   * @see #getBarColor()
   * @see #setBarColor()
   */
  public native function get barColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set barColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The pixel spacing between bars.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html#cfg-barSpacing Original Ext JS documentation of 'barSpacing'
   * @see #getBarSpacing()
   * @see #setBarSpacing()
   */
  public native function get barSpacing():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set barSpacing(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The pixel width of bars.
   * @default 4
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html#cfg-barWidth Original Ext JS documentation of 'barWidth'
   * @see #getBarWidth()
   * @see #setBarWidth()
   */
  public native function get barWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set barWidth(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * If true then the y values supplied to plot will be clipped to fall between
   * →<code>chartRangeMin</code> and →<code>chartRangeMax</code> - By default
   * chartRangeMin/Max just ensure that the chart spans at least that range of
   * values, but does not constrain it.
   * @default false
   * @see #chartRangeMin
   * @see #chartRangeMax
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html#cfg-chartRangeClip Original Ext JS documentation of 'chartRangeClip'
   * @see #getChartRangeClip()
   * @see #setChartRangeClip()
   */
  public native function get chartRangeClip():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chartRangeClip(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum value to use for the range of Y values
   * of the chart - Defaults to the minimum value supplied.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html#cfg-chartRangeMax Original Ext JS documentation of 'chartRangeMax'
   * @see #getChartRangeMax()
   * @see #setChartRangeMax()
   */
  public native function get chartRangeMax():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chartRangeMax(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value to use for the range of Y values of the chart - Defaults to
   * the minimum value supplied.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html#cfg-chartRangeMin Original Ext JS documentation of 'chartRangeMin'
   * @see #getChartRangeMin()
   * @see #setChartRangeMin()
   */
  public native function get chartRangeMin():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chartRangeMin(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * An object that uses range specifiers as keys to
   * indicate bar color values for a range of values. A range specifier is
   * specified in the form <code>[number]:[number]</code>, which indicates start and end range.
   * Omitting either means an open ended range.
   * <p>For example, to render green bars on all values less than -1 and red on values
   * higher than 1, you would use:</p>
   * <pre>
   * colorMap: {
   *     // Open ended range, with max value -1
   *     ":-1": "green",
   *
   *     // Open ended range, with min value 1
   *     "1:": "red"
   * }
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html#cfg-colorMap Original Ext JS documentation of 'colorMap'
   * @see #getColorMap()
   * @see #setColorMap()
   */
  public native function get colorMap():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set colorMap(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The bar color for negative values.
   * @default '#f44'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html#cfg-negBarColor Original Ext JS documentation of 'negBarColor'
   * @see #getNegBarColor()
   * @see #setNegBarColor()
   */
  public native function get negBarColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set negBarColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The bar color for null values. Usually null values are omitted and not
   * plotted. Setting this config causes a very thin bar to be plotted with the
   * special color in the case that null is a meaningful value in the series.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html#cfg-nullColor Original Ext JS documentation of 'nullColor'
   * @see #getNullColor()
   * @see #setNullColor()
   */
  public native function get nullColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set nullColor(value:String):void;

  [ArrayElementType("String")]
  [ExtConfig]
  [Bindable]
  /**
   * An array of colours to use for stacked bar charts. The first series will use
   * the first value in the array, the second series will use the second, etc.
   * @default [
   *     '#3366cc',
   *     '#dc3912',
   *     '#ff9900',
   *     '#109618',
   *     '#66aa00',
   *     '#dd4477',
   *     '#0099c6',
   *     '#990099'
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html#cfg-stackedBarColor Original Ext JS documentation of 'stackedBarColor'
   * @see #getStackedBarColor()
   * @see #setStackedBarColor()
   */
  public native function get stackedBarColor():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set stackedBarColor(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * An XTemplate used to display the value or values in a tooltip when hovering
   * over a Sparkline.
   * <p>The implemented subclases all define their own <code>→tipTpl</code>, but it can be overridden.</p>
   * @default '&#9679; {prefix}{value}{suffix}'
   * @see #tipTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html#cfg-tipTpl Original Ext JS documentation of 'tipTpl'
   * @see #getTipTpl()
   * @see #setTipTpl()
   */
  override public native function get tipTpl():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set tipTpl(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Centers the Y axis at zero by default.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html#cfg-zeroAxis Original Ext JS documentation of 'zeroAxis'
   * @see #getZeroAxis()
   * @see #setZeroAxis()
   */
  public native function get zeroAxis():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set zeroAxis(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The bar color for zero values.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bar.html#cfg-zeroColor Original Ext JS documentation of 'zeroColor'
   * @see #getZeroColor()
   * @see #setZeroColor()
   */
  public native function get zeroColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set zeroColor(value:String):void;

  /**
   * Returns the value of <code>barColor</code>.
   * @see #barColor
   */
  public native function getBarColor():String;

  /**
   * Returns the value of <code>barSpacing</code>.
   * @see #barSpacing
   */
  public native function getBarSpacing():Number;

  /**
   * Returns the value of <code>barWidth</code>.
   * @see #barWidth
   */
  public native function getBarWidth():Number;

  /**
   * Returns the value of <code>chartRangeClip</code>.
   * @see #chartRangeClip
   */
  public native function getChartRangeClip():Boolean;

  /**
   * Returns the value of <code>chartRangeMax</code>.
   * @see #chartRangeMax
   */
  public native function getChartRangeMax():Number;

  /**
   * Returns the value of <code>chartRangeMin</code>.
   * @see #chartRangeMin
   */
  public native function getChartRangeMin():Number;

  /**
   * Returns the value of <code>colorMap</code>.
   * @see #colorMap
   */
  public native function getColorMap():Object;

  /**
   * Returns the value of <code>negBarColor</code>.
   * @see #negBarColor
   */
  public native function getNegBarColor():String;

  /**
   * Returns the value of <code>nullColor</code>.
   * @see #nullColor
   */
  public native function getNullColor():String;

  [ArrayElementType("String")]
  /**
   * Returns the value of <code>stackedBarColor</code>.
   * @see #stackedBarColor
   */
  public native function getStackedBarColor():Array;

  /**
   * Returns the value of <code>tipTpl</code>.
   * @see #tipTpl
   */
  override public native function getTipTpl():*;

  /**
   * Returns the value of <code>zeroAxis</code>.
   * @see #zeroAxis
   */
  public native function getZeroAxis():Boolean;

  /**
   * Returns the value of <code>zeroColor</code>.
   * @see #zeroColor
   */
  public native function getZeroColor():String;

  /**
   * Sets the value of <code>barColor</code>.
   * @param barColor The new value.
   * @see #barColor
   */
  public native function setBarColor(barColor:String):void;

  /**
   * Sets the value of <code>barSpacing</code>.
   * @param barSpacing The new value.
   * @see #barSpacing
   */
  public native function setBarSpacing(barSpacing:Number):void;

  /**
   * Sets the value of <code>barWidth</code>.
   * @param barWidth The new value.
   * @see #barWidth
   */
  public native function setBarWidth(barWidth:Number):void;

  /**
   * Sets the value of <code>chartRangeClip</code>.
   * @param chartRangeClip The new value.
   * @see #chartRangeClip
   */
  public native function setChartRangeClip(chartRangeClip:Boolean):void;

  /**
   * Sets the value of <code>chartRangeMax</code>.
   * @param chartRangeMax The new value.
   * @see #chartRangeMax
   */
  public native function setChartRangeMax(chartRangeMax:Number):void;

  /**
   * Sets the value of <code>chartRangeMin</code>.
   * @param chartRangeMin The new value.
   * @see #chartRangeMin
   */
  public native function setChartRangeMin(chartRangeMin:Number):void;

  /**
   * Sets the value of <code>colorMap</code>.
   * @param colorMap The new value.
   * @see #colorMap
   */
  public native function setColorMap(colorMap:Object):void;

  /**
   * Sets the value of <code>negBarColor</code>.
   * @param negBarColor The new value.
   * @see #negBarColor
   */
  public native function setNegBarColor(negBarColor:String):void;

  /**
   * Sets the value of <code>nullColor</code>.
   * @param nullColor The new value.
   * @see #nullColor
   */
  public native function setNullColor(nullColor:String):void;

  [ArrayElementType("String")]
  /**
   * Sets the value of <code>stackedBarColor</code>.
   * @param stackedBarColor The new value.
   * @see #stackedBarColor
   */
  public native function setStackedBarColor(stackedBarColor:Array):void;

  /**
   * Sets the value of <code>tipTpl</code>.
   * @param tipTpl The new value.
   * @see #tipTpl
   */
  override public native function setTipTpl(tipTpl:*):void;

  /**
   * Sets the value of <code>zeroAxis</code>.
   * @param zeroAxis The new value.
   * @see #zeroAxis
   */
  public native function setZeroAxis(zeroAxis:Boolean):void;

  /**
   * Sets the value of <code>zeroColor</code>.
   * @param zeroColor The new value.
   * @see #zeroColor
   */
  public native function setZeroColor(zeroColor:String):void;
}
}