package ext.sparkline {
import ext.Widget;

[Native("Ext.sparkline.Base", require)]
/**
 * The base class for ExtJS SparkLines. SparkLines are small, inline graphs used to visually
 * display small amounts of data. For large datasets, use the
 * <i>chart package</i> (→<code>ext.chart.AbstractChart</code>).
 * <p>The SparkLine subclasses accept an <i>array of values</i> (→<code>values</code>), and present the data
 * in different visualizations.</p>
 * <p><b>Example:</b></p>
 * <pre>
 *  new Ext.Panel({
 *      height: 300,
 *      width: 600,
 *      frame: true,
 *      title: 'Test Sparklines',
 *      renderTo:document.body,
 *      bodyPadding: 10,
 *
 *      // Named listeners will resolve to methods in this Panel
 *      defaultListenerScope: true,
 *
 *      // Named references will be collected, and can be access from this Panel
 *      referenceHolder: true,
 *
 *      items: [{
 *          reference: 'values',
 *          xtype: 'textfield',
 *          fieldLabel: 'Values',
 *          validator: function(v) {
 *              var result = [];
 *
 *              v = v.replace(/\s/g, '');
 *              v = v.replace(/,$/, '');
 *              v = v.split(',');
 *              for (var i = 0; i &lt; v.length; i++) {
 *                  if (!Ext.isNumeric(v[i])) {
 *                      return 'Value must be a comma separated array of numbers';
 *                  }
 *                  result.push(parseInt(v[i], 10));
 *              }
 *              this.values = result;
 *              return true;
 *          },
 *          listeners: {
 *              change: 'onTypeChange',
 *              buffer: 500,
 *              afterrender: {
 *                  fn: 'afterTypeRender',
 *                  single: true
 *              }
 *          }
 *      }, {
 *          reference: 'type',
 *          xtype: 'combobox',
 *          fieldLabel: 'Type',
 *          store: [
 *              ['sparklineline',     'Line'],
 *              ['sparklinebox',      'Box'],
 *              ['sparklinebullet',   'Bullet'],
 *              ['sparklinediscrete', 'Discrete'],
 *              ['sparklinepie',      'Pie'],
 *              ['sparklinetristate', 'TriState']
 *          ],
 *          value: 'sparklineline',
 *          listeners: {
 *              change: 'onTypeChange',
 *              buffer: 500
 *          }
 *      }],
 *
 *      // Start with a line plot.
 *      afterTypeRender: function(typeField) {
 *          typeField.setValue('6,10,4,-3,7,2');
 *      },
 *
 *      onTypeChange: function() {
 *          var me = this,
 *              refs = me.getReferences(),
 *              config;
 *
 *          if (me.sparkLine) {
 *              me.remove(me.sparkLine, true);
 *          }
 *          config = {
 *              xtype: refs.type.getValue(),
 *              values: refs.values.values,
 *              height: 25,
 *              width: 100
 *          };
 *            me.sparkLine = Ext.create(config);
 *          me.add(me.sparkLine);
 *
 *          // Put under fields
 *          me.sparkLine.el.dom.style.marginLeft = refs.type.labelEl.getWidth() + 'px';
 *      }
 *  });
 * </pre>
 * @see ext.chart.AbstractChart
 * @see #values
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Base.html Original Ext JS documentation of 'Ext.sparkline.Base'
 */
public class SparklineBase extends Widget {
  /**
   * @param config @inheritDoc
   */
  public function SparklineBase(config:SparklineBase = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Set to <code>true</code> to disable mouseover tooltips.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Base.html#cfg-disableTooltips Original Ext JS documentation of 'disableTooltips'
   * @see #getDisableTooltips()
   * @see #setDisableTooltips()
   */
  public native function get disableTooltips():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set disableTooltips(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The hex value for the highlight color to use when mouseing over a graph segment.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Base.html#cfg-highlightColor Original Ext JS documentation of 'highlightColor'
   * @see #getHighlightColor()
   * @see #setHighlightColor()
   */
  public native function get highlightColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set highlightColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * How much to lighten the highlight color by when mouseing over a graph segment.
   * @default 0.1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Base.html#cfg-highlightLighten Original Ext JS documentation of 'highlightLighten'
   * @see #getHighlightLighten()
   * @see #setHighlightLighten()
   */
  public native function get highlightLighten():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set highlightLighten(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The hex value for line colors in graphs which
   * display lines (→<code>ext.sparkline.SparklineBox</code>,
   * →<code>ext.sparkline.SparklineDiscrete</code> and →<code>ext.sparkline.SparklineLine</code>).
   * @default '#157fcc'
   * @see ext.sparkline.SparklineBox
   * @see ext.sparkline.SparklineDiscrete
   * @see ext.sparkline.SparklineLine
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Base.html#cfg-lineColor Original Ext JS documentation of 'lineColor'
   * @see #getLineColor()
   * @see #setLineColor()
   */
  public native function get lineColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set lineColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * An XTemplate used to display the value or values in a tooltip when hovering
   * over a Sparkline.
   * <p>The implemented subclases all define their own <code>→tipTpl</code>, but it can be overridden.</p>
   * @default null
   * @see #tipTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Base.html#cfg-tipTpl Original Ext JS documentation of 'tipTpl'
   * @see #getTipTpl()
   * @see #setTipTpl()
   */
  public native function get tipTpl():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tipTpl(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * A string to prepend to each field displayed in a tooltip.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Base.html#cfg-tooltipPrefix Original Ext JS documentation of 'tooltipPrefix'
   * @see #getTooltipPrefix()
   * @see #setTooltipPrefix()
   */
  public native function get tooltipPrefix():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tooltipPrefix(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Null values will not have a tooltip displayed.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Base.html#cfg-tooltipSkipNull Original Ext JS documentation of 'tooltipSkipNull'
   * @see #getTooltipSkipNull()
   * @see #setTooltipSkipNull()
   */
  public native function get tooltipSkipNull():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tooltipSkipNull(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * A string to append to each field displayed in a tooltip.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Base.html#cfg-tooltipSuffix Original Ext JS documentation of 'tooltipSuffix'
   * @see #getTooltipSuffix()
   * @see #setTooltipSuffix()
   */
  public native function get tooltipSuffix():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tooltipSuffix(value:String):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  [Bindable]
  /**
   * An array of numbers which define the chart.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Base.html#cfg-values Original Ext JS documentation of 'values'
   * @see #getValues()
   * @see #setValues()
   */
  public native function get values():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set values(value:Array):void;

  /**
   * Returns the value of <code>disableTooltips</code>.
   * @see #disableTooltips
   */
  public native function getDisableTooltips():Boolean;

  /**
   * Returns the value of <code>highlightColor</code>.
   * @see #highlightColor
   */
  public native function getHighlightColor():String;

  /**
   * Returns the value of <code>highlightLighten</code>.
   * @see #highlightLighten
   */
  public native function getHighlightLighten():Number;

  /**
   * Returns the value of <code>lineColor</code>.
   * @see #lineColor
   */
  public native function getLineColor():String;

  /**
   * Return a region id for a given x/y co-ordinate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Base.html#method-getRegion Original Ext JS documentation of 'getRegion'
   */
  public native function getRegion():void;

  /**
   * Fetch the HTML to display as a tooltip
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Base.html#method-getRegionTooltip Original Ext JS documentation of 'getRegionTooltip'
   */
  public native function getRegionTooltip(region:*):String;

  /**
   * Returns the value of <code>tipTpl</code>.
   * @see #tipTpl
   */
  public native function getTipTpl():*;

  /**
   * Returns the value of <code>tooltipPrefix</code>.
   * @see #tooltipPrefix
   */
  public native function getTooltipPrefix():String;

  /**
   * Returns the value of <code>tooltipSkipNull</code>.
   * @see #tooltipSkipNull
   */
  public native function getTooltipSkipNull():Boolean;

  /**
   * Returns the value of <code>tooltipSuffix</code>.
   * @see #tooltipSuffix
   */
  public native function getTooltipSuffix():String;

  [ArrayElementType("Number")]
  /**
   * Returns the value of <code>values</code>.
   * @see #values
   */
  public native function getValues():Array;

  /**
   * Sets the value of <code>disableTooltips</code>.
   * @param disableTooltips The new value.
   * @see #disableTooltips
   */
  public native function setDisableTooltips(disableTooltips:Boolean):void;

  /**
   * Sets the value of <code>highlightColor</code>.
   * @param highlightColor The new value.
   * @see #highlightColor
   */
  public native function setHighlightColor(highlightColor:String):void;

  /**
   * Sets the value of <code>highlightLighten</code>.
   * @param highlightLighten The new value.
   * @see #highlightLighten
   */
  public native function setHighlightLighten(highlightLighten:Number):void;

  /**
   * Sets the value of <code>lineColor</code>.
   * @param lineColor The new value.
   * @see #lineColor
   */
  public native function setLineColor(lineColor:String):void;

  /**
   * Sets the value of <code>tipTpl</code>.
   * @param tipTpl The new value.
   * @see #tipTpl
   */
  public native function setTipTpl(tipTpl:*):void;

  /**
   * Sets the value of <code>tooltipPrefix</code>.
   * @param tooltipPrefix The new value.
   * @see #tooltipPrefix
   */
  public native function setTooltipPrefix(tooltipPrefix:String):void;

  /**
   * Sets the value of <code>tooltipSkipNull</code>.
   * @param tooltipSkipNull The new value.
   * @see #tooltipSkipNull
   */
  public native function setTooltipSkipNull(tooltipSkipNull:Boolean):void;

  /**
   * Sets the value of <code>tooltipSuffix</code>.
   * @param tooltipSuffix The new value.
   * @see #tooltipSuffix
   */
  public native function setTooltipSuffix(tooltipSuffix:String):void;

  [ArrayElementType("Number")]
  /**
   * Sets the value of <code>values</code>.
   * @param values The new value.
   * @see #values
   */
  public native function setValues(values:Array):void;
}
}