package ext.sparkline {

[Native("Ext.sparkline.Box", require)]
/**
 * Generates a box plot graph from the provided →<code>values</code> array.
 * <p>See <a href="http://en.wikipedia.org/wiki/Box_plot">Wikipedia Box Plots</a></p>
 * <p>See <i>the base class</i> (→<code>ext.sparkline.SparklineBase</code>) for a simple example.</p>
 * @see #values
 * @see ext.sparkline.SparklineBase
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html Original Ext JS documentation of 'Ext.sparkline.Box'
 */
public class SparklineBox extends SparklineBase {
  /**
   * @param config @inheritDoc
   */
  public function SparklineBox(config:SparklineBox = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The color of the box fill.
   * @default #cdf
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-boxFillColor Original Ext JS documentation of 'boxFillColor'
   * @see #getBoxFillColor()
   * @see #setBoxFillColor()
   */
  public native function get boxFillColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set boxFillColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The color of the box outline.
   * @default #000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-boxLineColor Original Ext JS documentation of 'boxLineColor'
   * @see #getBoxLineColor()
   * @see #setBoxLineColor()
   */
  public native function get boxLineColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set boxLineColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum value to use for the range of Y values
   * of the chart - Defaults to the minimum value supplied.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-chartRangeMax Original Ext JS documentation of 'chartRangeMax'
   * @see #getChartRangeMax()
   * @see #setChartRangeMax()
   */
  public native function get chartRangeMax():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chartRangeMax(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value to use for the range of Y values
   * of the chart - Defaults to the minimum value supplied.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-chartRangeMin Original Ext JS documentation of 'chartRangeMin'
   * @see #getChartRangeMin()
   * @see #setChartRangeMin()
   */
  public native function get chartRangeMin():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chartRangeMin(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The color of the median line.
   * @default #f00
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-medianColor Original Ext JS documentation of 'medianColor'
   * @see #getMedianColor()
   * @see #setMedianColor()
   */
  public native function get medianColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set medianColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The fill color of the outlier circles.
   * @default #fff
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-outlierFillColor Original Ext JS documentation of 'outlierFillColor'
   * @see #getOutlierFillColor()
   * @see #setOutlierFillColor()
   */
  public native function get outlierFillColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set outlierFillColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The inter-quartile range multiplier used to calculate
   * values that qualify as an outlier.
   * @default 1.5
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-outlierIQR Original Ext JS documentation of 'outlierIQR'
   * @see #getOutlierIQR()
   * @see #setOutlierIQR()
   */
  public native function get outlierIQR():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set outlierIQR(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The color of the outlier circles' outline.
   * @default #333
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-outlierLineColor Original Ext JS documentation of 'outlierLineColor'
   * @see #getOutlierLineColor()
   * @see #setOutlierLineColor()
   */
  public native function get outlierLineColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set outlierLineColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * By default the points are calculated from the
   * input values array. Set this to true to pass the pre-calculated points
   * in the values config.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-raw Original Ext JS documentation of 'raw'
   * @see #getRaw()
   * @see #setRaw()
   */
  public native function get raw():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set raw(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Configure as <code>false</code> to not show outlier circles.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-showOutliers Original Ext JS documentation of 'showOutliers'
   * @see #getShowOutliers()
   * @see #setShowOutliers()
   */
  public native function get showOutliers():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set showOutliers(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The radius of the outlier circles.
   * @default 1.5
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-spotRadius Original Ext JS documentation of 'spotRadius'
   * @see #getSpotRadius()
   * @see #setSpotRadius()
   */
  public native function get spotRadius():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set spotRadius(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * If set, a crosshair will be drawn at the specified value point.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-target Original Ext JS documentation of 'target'
   * @see #getTarget()
   * @see #setTarget()
   */
  public native function get target():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set target(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The color of the crosshair drawn at the point
   * specified by →<code>target</code>.
   * @default #4a2
   * @see #target
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-targetColor Original Ext JS documentation of 'targetColor'
   * @see #getTargetColor()
   * @see #setTargetColor()
   */
  public native function get targetColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set targetColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The color of the whiskers.
   * @default #000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Box.html#cfg-whiskerColor Original Ext JS documentation of 'whiskerColor'
   * @see #getWhiskerColor()
   * @see #setWhiskerColor()
   */
  public native function get whiskerColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set whiskerColor(value:String):void;

  /**
   * Returns the value of <code>boxFillColor</code>.
   * @see #boxFillColor
   */
  public native function getBoxFillColor():String;

  /**
   * Returns the value of <code>boxLineColor</code>.
   * @see #boxLineColor
   */
  public native function getBoxLineColor():String;

  /**
   * Returns the value of <code>chartRangeMax</code>.
   * @see #chartRangeMax
   */
  public native function getChartRangeMax():Number;

  /**
   * Returns the value of <code>chartRangeMin</code>.
   * @see #chartRangeMin
   */
  public native function getChartRangeMin():Number;

  /**
   * Returns the value of <code>medianColor</code>.
   * @see #medianColor
   */
  public native function getMedianColor():String;

  /**
   * Returns the value of <code>outlierFillColor</code>.
   * @see #outlierFillColor
   */
  public native function getOutlierFillColor():String;

  /**
   * Returns the value of <code>outlierIQR</code>.
   * @see #outlierIQR
   */
  public native function getOutlierIQR():Number;

  /**
   * Returns the value of <code>outlierLineColor</code>.
   * @see #outlierLineColor
   */
  public native function getOutlierLineColor():String;

  /**
   * Returns the value of <code>raw</code>.
   * @see #raw
   */
  public native function getRaw():Boolean;

  /**
   * Returns the value of <code>showOutliers</code>.
   * @see #showOutliers
   */
  public native function getShowOutliers():Boolean;

  /**
   * Returns the value of <code>spotRadius</code>.
   * @see #spotRadius
   */
  public native function getSpotRadius():Number;

  /**
   * Returns the value of <code>target</code>.
   * @see #target
   */
  public native function getTarget():Number;

  /**
   * Returns the value of <code>targetColor</code>.
   * @see #targetColor
   */
  public native function getTargetColor():String;

  /**
   * Returns the value of <code>whiskerColor</code>.
   * @see #whiskerColor
   */
  public native function getWhiskerColor():String;

  /**
   * Sets the value of <code>boxFillColor</code>.
   * @param boxFillColor The new value.
   * @see #boxFillColor
   */
  public native function setBoxFillColor(boxFillColor:String):void;

  /**
   * Sets the value of <code>boxLineColor</code>.
   * @param boxLineColor The new value.
   * @see #boxLineColor
   */
  public native function setBoxLineColor(boxLineColor:String):void;

  /**
   * Sets the value of <code>chartRangeMax</code>.
   * @param chartRangeMax The new value.
   * @see #chartRangeMax
   */
  public native function setChartRangeMax(chartRangeMax:Number):void;

  /**
   * Sets the value of <code>chartRangeMin</code>.
   * @param chartRangeMin The new value.
   * @see #chartRangeMin
   */
  public native function setChartRangeMin(chartRangeMin:Number):void;

  /**
   * Sets the value of <code>medianColor</code>.
   * @param medianColor The new value.
   * @see #medianColor
   */
  public native function setMedianColor(medianColor:String):void;

  /**
   * Sets the value of <code>outlierFillColor</code>.
   * @param outlierFillColor The new value.
   * @see #outlierFillColor
   */
  public native function setOutlierFillColor(outlierFillColor:String):void;

  /**
   * Sets the value of <code>outlierIQR</code>.
   * @param outlierIQR The new value.
   * @see #outlierIQR
   */
  public native function setOutlierIQR(outlierIQR:Number):void;

  /**
   * Sets the value of <code>outlierLineColor</code>.
   * @param outlierLineColor The new value.
   * @see #outlierLineColor
   */
  public native function setOutlierLineColor(outlierLineColor:String):void;

  /**
   * Sets the value of <code>raw</code>.
   * @param raw The new value.
   * @see #raw
   */
  public native function setRaw(raw:Boolean):void;

  /**
   * Sets the value of <code>showOutliers</code>.
   * @param showOutliers The new value.
   * @see #showOutliers
   */
  public native function setShowOutliers(showOutliers:Boolean):void;

  /**
   * Sets the value of <code>spotRadius</code>.
   * @param spotRadius The new value.
   * @see #spotRadius
   */
  public native function setSpotRadius(spotRadius:Number):void;

  /**
   * Sets the value of <code>target</code>.
   * @param target The new value.
   * @see #target
   */
  public native function setTarget(target:Number):void;

  /**
   * Sets the value of <code>targetColor</code>.
   * @param targetColor The new value.
   * @see #targetColor
   */
  public native function setTargetColor(targetColor:String):void;

  /**
   * Sets the value of <code>whiskerColor</code>.
   * @param whiskerColor The new value.
   * @see #whiskerColor
   */
  public native function setWhiskerColor(whiskerColor:String):void;
}
}