package ext.sparkline {

[Native("Ext.sparkline.Bullet", require)]
/**
 * Plots a bullet graph based upon the input →<code>values</code> array.
 * <p>See <a href="http://en.wikipedia.org/wiki/Bullet_graph">Bullet graphs Wikipedia Page</a>
 * for more information.</p>
 * <p>The first value should be the target value. If there is no target value, it should be <code>null</code>.
 * The second value should be the performance value. If there is no performance value, it should be
 * specified as <code>null</code>.</p>
 * <p>An example value:</p>
 * <pre>
 * // Target 10
 * // Performance 12
 * // Ranges 12,9,7
 * [10, 12, 12, 9, 7]
 * </pre>
 * <p>See <i>the base class</i> (→<code>ext.sparkline.SparklineBase</code>) for a simple example.</p>
 * @see #values
 * @see ext.sparkline.SparklineBase
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bullet.html Original Ext JS documentation of 'Ext.sparkline.Bullet'
 */
public class SparklineBullet extends SparklineBase {
  /**
   * @param config @inheritDoc
   */
  public function SparklineBullet(config:SparklineBullet = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Set this to a number to change the base start number.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bullet.html#cfg-base Original Ext JS documentation of 'base'
   * @see #getBase()
   * @see #setBase()
   */
  public native function get base():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set base(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The color of the performance measure
   * horizontal bar.
   * @default #33f
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bullet.html#cfg-performanceColor Original Ext JS documentation of 'performanceColor'
   * @see #getPerformanceColor()
   * @see #setPerformanceColor()
   */
  public native function get performanceColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set performanceColor(value:String):void;

  [ArrayElementType("String")]
  [ExtConfig]
  [Bindable]
  /**
   * An array of colors to use for each qualitative range
   * background color.
   * @default [
   *     '#d3dafe',
   *     '#a8b6ff',
   *     '#7f94ff'
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bullet.html#cfg-rangeColors Original Ext JS documentation of 'rangeColors'
   * @see #getRangeColors()
   * @see #setRangeColors()
   */
  public native function get rangeColors():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set rangeColors(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The colour of the vertical target marker.
   * @default #f33
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bullet.html#cfg-targetColor Original Ext JS documentation of 'targetColor'
   * @see #getTargetColor()
   * @see #setTargetColor()
   */
  public native function get targetColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set targetColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Width of the target bar in pixels.
   * @default 3
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Bullet.html#cfg-targetWidth Original Ext JS documentation of 'targetWidth'
   * @see #getTargetWidth()
   * @see #setTargetWidth()
   */
  public native function get targetWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set targetWidth(value:Number):void;

  /**
   * Returns the value of <code>base</code>.
   * @see #base
   */
  public native function getBase():Number;

  /**
   * Returns the value of <code>performanceColor</code>.
   * @see #performanceColor
   */
  public native function getPerformanceColor():String;

  [ArrayElementType("String")]
  /**
   * Returns the value of <code>rangeColors</code>.
   * @see #rangeColors
   */
  public native function getRangeColors():Array;

  /**
   * Returns the value of <code>targetColor</code>.
   * @see #targetColor
   */
  public native function getTargetColor():String;

  /**
   * Returns the value of <code>targetWidth</code>.
   * @see #targetWidth
   */
  public native function getTargetWidth():Number;

  /**
   * Sets the value of <code>base</code>.
   * @param base The new value.
   * @see #base
   */
  public native function setBase(base:Number):void;

  /**
   * Sets the value of <code>performanceColor</code>.
   * @param performanceColor The new value.
   * @see #performanceColor
   */
  public native function setPerformanceColor(performanceColor:String):void;

  [ArrayElementType("String")]
  /**
   * Sets the value of <code>rangeColors</code>.
   * @param rangeColors The new value.
   * @see #rangeColors
   */
  public native function setRangeColors(rangeColors:Array):void;

  /**
   * Sets the value of <code>targetColor</code>.
   * @param targetColor The new value.
   * @see #targetColor
   */
  public native function setTargetColor(targetColor:String):void;

  /**
   * Sets the value of <code>targetWidth</code>.
   * @param targetWidth The new value.
   * @see #targetWidth
   */
  public native function setTargetWidth(targetWidth:Number):void;
}
}