package ext.sparkline {

[Native("Ext.sparkline.Discrete", require)]
/**
 * Plots a series of thin vertical lines based upon the input →<code>values</code> array.
 * <p>See <i>the base class</i> (→<code>ext.sparkline.SparklineBase</code>) for a simple example.</p>
 * @see #values
 * @see ext.sparkline.SparklineBase
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Discrete.html Original Ext JS documentation of 'Ext.sparkline.Discrete'
 */
public class SparklineDiscrete extends SparklineBarBase {
  /**
   * @param config @inheritDoc
   */
  public function SparklineDiscrete(config:SparklineDiscrete = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * If true then the y values supplied to plot will be clipped
   * to fall between →<code>chartRangeMin</code> and →<code>chartRangeMax</code> - By default
   * chartRangeMin/Max just ensure that the chart spans at least that range of values,
   * but does not constrain it.
   * @default false
   * @see #chartRangeMin
   * @see #chartRangeMax
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Discrete.html#cfg-chartRangeClip Original Ext JS documentation of 'chartRangeClip'
   * @see #getChartRangeClip()
   * @see #setChartRangeClip()
   */
  public native function get chartRangeClip():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chartRangeClip(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum value to use for the range of Y values
   * of the chart - Defaults to the maximum value supplied.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Discrete.html#cfg-chartRangeMax Original Ext JS documentation of 'chartRangeMax'
   * @see #getChartRangeMax()
   * @see #setChartRangeMax()
   */
  public native function get chartRangeMax():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chartRangeMax(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value to use for the range of Y values
   * of the chart - Defaults to the minimum value supplied.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Discrete.html#cfg-chartRangeMin Original Ext JS documentation of 'chartRangeMin'
   * @see #getChartRangeMin()
   * @see #setChartRangeMin()
   */
  public native function get chartRangeMin():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chartRangeMin(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Height of each line in pixels - Defaults to 30% of the
   * graph height.
   * @default 'auto'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Discrete.html#cfg-lineHeight Original Ext JS documentation of 'lineHeight'
   * @see #getLineHeight()
   * @see #setLineHeight()
   */
  public native function get lineHeight():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set lineHeight(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Colour to use in combination with →<code>thresholdValue</code>
   * @see #thresholdValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Discrete.html#cfg-thresholdColor Original Ext JS documentation of 'thresholdColor'
   * @see #getThresholdColor()
   * @see #setThresholdColor()
   */
  public native function get thresholdColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set thresholdColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Values less than this value will be drawn using
   * →<code>thresholdColor</code> instead of lineColor
   * @default 0
   * @see #thresholdColor
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Discrete.html#cfg-thresholdValue Original Ext JS documentation of 'thresholdValue'
   * @see #getThresholdValue()
   * @see #setThresholdValue()
   */
  public native function get thresholdValue():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set thresholdValue(value:Number):void;

  /**
   * Returns the value of <code>chartRangeClip</code>.
   * @see #chartRangeClip
   */
  public native function getChartRangeClip():Boolean;

  /**
   * Returns the value of <code>chartRangeMax</code>.
   * @see #chartRangeMax
   */
  public native function getChartRangeMax():Number;

  /**
   * Returns the value of <code>chartRangeMin</code>.
   * @see #chartRangeMin
   */
  public native function getChartRangeMin():Number;

  /**
   * Returns the value of <code>lineHeight</code>.
   * @see #lineHeight
   */
  public native function getLineHeight():Number;

  /**
   * Returns the value of <code>thresholdColor</code>.
   * @see #thresholdColor
   */
  public native function getThresholdColor():String;

  /**
   * Returns the value of <code>thresholdValue</code>.
   * @see #thresholdValue
   */
  public native function getThresholdValue():Number;

  /**
   * Sets the value of <code>chartRangeClip</code>.
   * @param chartRangeClip The new value.
   * @see #chartRangeClip
   */
  public native function setChartRangeClip(chartRangeClip:Boolean):void;

  /**
   * Sets the value of <code>chartRangeMax</code>.
   * @param chartRangeMax The new value.
   * @see #chartRangeMax
   */
  public native function setChartRangeMax(chartRangeMax:Number):void;

  /**
   * Sets the value of <code>chartRangeMin</code>.
   * @param chartRangeMin The new value.
   * @see #chartRangeMin
   */
  public native function setChartRangeMin(chartRangeMin:Number):void;

  /**
   * Sets the value of <code>lineHeight</code>.
   * @param lineHeight The new value.
   * @see #lineHeight
   */
  public native function setLineHeight(lineHeight:Number):void;

  /**
   * Sets the value of <code>thresholdColor</code>.
   * @param thresholdColor The new value.
   * @see #thresholdColor
   */
  public native function setThresholdColor(thresholdColor:String):void;

  /**
   * Sets the value of <code>thresholdValue</code>.
   * @param thresholdValue The new value.
   * @see #thresholdValue
   */
  public native function setThresholdValue(thresholdValue:Number):void;
}
}