package ext.sparkline {

[Native("Ext.sparkline.Line", require)]
/**
 * Plots a line graph based upon the input →<code>values</code> array.
 * <p>See <i>the base class</i> (→<code>ext.sparkline.SparklineBase</code>) for a simple example.</p>
 * @see #values
 * @see ext.sparkline.SparklineBase
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html Original Ext JS documentation of 'Ext.sparkline.Line'
 */
public class SparklineLine extends SparklineBase {
  /**
   * @param config @inheritDoc
   */
  public function SparklineLine(config:SparklineLine = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The maximum value to use for the range of Y values
   * of the chart - Defaults to the minimum value supplied.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-chartRangeMax Original Ext JS documentation of 'chartRangeMax'
   * @see #getChartRangeMax()
   * @see #setChartRangeMax()
   */
  public native function get chartRangeMax():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chartRangeMax(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum value to use for the X value of the chart.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-chartRangeMaxX Original Ext JS documentation of 'chartRangeMaxX'
   * @see #getChartRangeMaxX()
   * @see #setChartRangeMaxX()
   */
  public native function get chartRangeMaxX():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chartRangeMaxX(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value to use for the range of Y values
   * of the chart - Defaults to the minimum value supplied.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-chartRangeMin Original Ext JS documentation of 'chartRangeMin'
   * @see #getChartRangeMin()
   * @see #setChartRangeMin()
   */
  public native function get chartRangeMin():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chartRangeMin(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value to use for the X value of the chart.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-chartRangeMinX Original Ext JS documentation of 'chartRangeMinX'
   * @see #getChartRangeMinX()
   * @see #setChartRangeMinX()
   */
  public native function get chartRangeMinX():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set chartRangeMinX(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Configure as <code>true</code> to draw the normal range
   * overlaying the chart.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-drawNormalOnTop Original Ext JS documentation of 'drawNormalOnTop'
   * @see #getDrawNormalOnTop()
   * @see #setDrawNormalOnTop()
   */
  public native function get drawNormalOnTop():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set drawNormalOnTop(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The hex value for fill color.
   * @default #def
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-fillColor Original Ext JS documentation of 'fillColor'
   * @see #getFillColor()
   * @see #setFillColor()
   */
  public native function get fillColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set fillColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The colour of value line shown when the graph
   * is mouseovered.
   * @default #f22
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-highlightLineColor Original Ext JS documentation of 'highlightLineColor'
   * @see #getHighlightLineColor()
   * @see #setHighlightLineColor()
   */
  public native function get highlightLineColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set highlightLineColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The colour of value marker spots
   * when mouseovered.
   * @default #5f5
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-highlightSpotColor Original Ext JS documentation of 'highlightSpotColor'
   * @see #getHighlightSpotColor()
   * @see #setHighlightSpotColor()
   */
  public native function get highlightSpotColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set highlightSpotColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The pixel width of the line plotted.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-lineWidth Original Ext JS documentation of 'lineWidth'
   * @see #getLineWidth()
   * @see #setLineWidth()
   */
  public native function get lineWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set lineWidth(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The colour of the maximum value marker. Set to false
   * or an empty string to hide it.
   * @default #f80
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-maxSpotColor Original Ext JS documentation of 'maxSpotColor'
   * @see #getMaxSpotColor()
   * @see #setMaxSpotColor()
   */
  public native function get maxSpotColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set maxSpotColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The colour of the mimimum value marker. Set to false
   * or an empty string to hide it.
   * @default #f80
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-minSpotColor Original Ext JS documentation of 'minSpotColor'
   * @see #getMinSpotColor()
   * @see #setMinSpotColor()
   */
  public native function get minSpotColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set minSpotColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * See →<code>normalRangeMin</code> and
   * →<code>normalRangeMax</code> The color of the undererlayed "normal range bar".
   * @default #ccc
   * @see #normalRangeMin
   * @see #normalRangeMax
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-normalRangeColor Original Ext JS documentation of 'normalRangeColor'
   * @see #getNormalRangeColor()
   * @see #setNormalRangeColor()
   */
  public native function get normalRangeColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set normalRangeColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * See →<code>normalRangeMin</code> The maximum value to overlay
   * a "normal range bar" over the graph using the →<code>normalRangeColor</code>.
   * @default null
   * @see #normalRangeMin
   * @see #normalRangeColor
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-normalRangeMax Original Ext JS documentation of 'normalRangeMax'
   * @see #getNormalRangeMax()
   * @see #setNormalRangeMax()
   */
  public native function get normalRangeMax():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set normalRangeMax(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * See →<code>normalRangeMax</code> The minimum value to overlay
   * a "normal range bar" over the graph using the →<code>normalRangeColor</code>.
   * @default null
   * @see #normalRangeMax
   * @see #normalRangeColor
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-normalRangeMin Original Ext JS documentation of 'normalRangeMin'
   * @see #getNormalRangeMin()
   * @see #setNormalRangeMin()
   */
  public native function get normalRangeMin():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set normalRangeMin(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The colour of the final value marker. Set to false
   * or an empty string to hide it.
   * @default #f80
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-spotColor Original Ext JS documentation of 'spotColor'
   * @see #getSpotColor()
   * @see #setSpotColor()
   */
  public native function get spotColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set spotColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The pixel radius of min, max and final value dots.
   * @default 1.5
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-spotRadius Original Ext JS documentation of 'spotRadius'
   * @see #getSpotRadius()
   * @see #setSpotRadius()
   */
  public native function get spotRadius():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set spotRadius(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * An object which uses range specifiers as keys to indicate
   * spot color values for range of values. A range specifier is of the form
   * <code>[number]:[number]</code> indicating start and end range. Omitting aither means an open ended
   * range. For example to render green spots on all values less than 50 and red on values
   * higher than 50 use:
   * <pre>
   * {
   *     // Open ended range, with max value 49
   *     ":49": "green",
   *
   *     // Open ended range, with min value 50
   *     "50:": "red"
   * }
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Line.html#cfg-valueSpots Original Ext JS documentation of 'valueSpots'
   * @see #getValueSpots()
   * @see #setValueSpots()
   */
  public native function get valueSpots():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set valueSpots(value:Object):void;

  /**
   * Returns the value of <code>chartRangeMax</code>.
   * @see #chartRangeMax
   */
  public native function getChartRangeMax():Number;

  /**
   * Returns the value of <code>chartRangeMaxX</code>.
   * @see #chartRangeMaxX
   */
  public native function getChartRangeMaxX():Number;

  /**
   * Returns the value of <code>chartRangeMin</code>.
   * @see #chartRangeMin
   */
  public native function getChartRangeMin():Number;

  /**
   * Returns the value of <code>chartRangeMinX</code>.
   * @see #chartRangeMinX
   */
  public native function getChartRangeMinX():Number;

  /**
   * Returns the value of <code>drawNormalOnTop</code>.
   * @see #drawNormalOnTop
   */
  public native function getDrawNormalOnTop():Boolean;

  /**
   * Returns the value of <code>fillColor</code>.
   * @see #fillColor
   */
  public native function getFillColor():String;

  /**
   * Returns the value of <code>highlightLineColor</code>.
   * @see #highlightLineColor
   */
  public native function getHighlightLineColor():String;

  /**
   * Returns the value of <code>highlightSpotColor</code>.
   * @see #highlightSpotColor
   */
  public native function getHighlightSpotColor():String;

  /**
   * Returns the value of <code>lineWidth</code>.
   * @see #lineWidth
   */
  public native function getLineWidth():Number;

  /**
   * Returns the value of <code>maxSpotColor</code>.
   * @see #maxSpotColor
   */
  public native function getMaxSpotColor():String;

  /**
   * Returns the value of <code>minSpotColor</code>.
   * @see #minSpotColor
   */
  public native function getMinSpotColor():String;

  /**
   * Returns the value of <code>normalRangeColor</code>.
   * @see #normalRangeColor
   */
  public native function getNormalRangeColor():String;

  /**
   * Returns the value of <code>normalRangeMax</code>.
   * @see #normalRangeMax
   */
  public native function getNormalRangeMax():Number;

  /**
   * Returns the value of <code>normalRangeMin</code>.
   * @see #normalRangeMin
   */
  public native function getNormalRangeMin():Number;

  /**
   * Returns the value of <code>spotColor</code>.
   * @see #spotColor
   */
  public native function getSpotColor():String;

  /**
   * Returns the value of <code>spotRadius</code>.
   * @see #spotRadius
   */
  public native function getSpotRadius():Number;

  /**
   * Returns the value of <code>valueSpots</code>.
   * @see #valueSpots
   */
  public native function getValueSpots():Object;

  /**
   * Sets the value of <code>chartRangeMax</code>.
   * @param chartRangeMax The new value.
   * @see #chartRangeMax
   */
  public native function setChartRangeMax(chartRangeMax:Number):void;

  /**
   * Sets the value of <code>chartRangeMaxX</code>.
   * @param chartRangeMaxX The new value.
   * @see #chartRangeMaxX
   */
  public native function setChartRangeMaxX(chartRangeMaxX:Number):void;

  /**
   * Sets the value of <code>chartRangeMin</code>.
   * @param chartRangeMin The new value.
   * @see #chartRangeMin
   */
  public native function setChartRangeMin(chartRangeMin:Number):void;

  /**
   * Sets the value of <code>chartRangeMinX</code>.
   * @param chartRangeMinX The new value.
   * @see #chartRangeMinX
   */
  public native function setChartRangeMinX(chartRangeMinX:Number):void;

  /**
   * Sets the value of <code>drawNormalOnTop</code>.
   * @param drawNormalOnTop The new value.
   * @see #drawNormalOnTop
   */
  public native function setDrawNormalOnTop(drawNormalOnTop:Boolean):void;

  /**
   * Sets the value of <code>fillColor</code>.
   * @param fillColor The new value.
   * @see #fillColor
   */
  public native function setFillColor(fillColor:String):void;

  /**
   * Sets the value of <code>highlightLineColor</code>.
   * @param highlightLineColor The new value.
   * @see #highlightLineColor
   */
  public native function setHighlightLineColor(highlightLineColor:String):void;

  /**
   * Sets the value of <code>highlightSpotColor</code>.
   * @param highlightSpotColor The new value.
   * @see #highlightSpotColor
   */
  public native function setHighlightSpotColor(highlightSpotColor:String):void;

  /**
   * Sets the value of <code>lineWidth</code>.
   * @param lineWidth The new value.
   * @see #lineWidth
   */
  public native function setLineWidth(lineWidth:Number):void;

  /**
   * Sets the value of <code>maxSpotColor</code>.
   * @param maxSpotColor The new value.
   * @see #maxSpotColor
   */
  public native function setMaxSpotColor(maxSpotColor:String):void;

  /**
   * Sets the value of <code>minSpotColor</code>.
   * @param minSpotColor The new value.
   * @see #minSpotColor
   */
  public native function setMinSpotColor(minSpotColor:String):void;

  /**
   * Sets the value of <code>normalRangeColor</code>.
   * @param normalRangeColor The new value.
   * @see #normalRangeColor
   */
  public native function setNormalRangeColor(normalRangeColor:String):void;

  /**
   * Sets the value of <code>normalRangeMax</code>.
   * @param normalRangeMax The new value.
   * @see #normalRangeMax
   */
  public native function setNormalRangeMax(normalRangeMax:Number):void;

  /**
   * Sets the value of <code>normalRangeMin</code>.
   * @param normalRangeMin The new value.
   * @see #normalRangeMin
   */
  public native function setNormalRangeMin(normalRangeMin:Number):void;

  /**
   * Sets the value of <code>spotColor</code>.
   * @param spotColor The new value.
   * @see #spotColor
   */
  public native function setSpotColor(spotColor:String):void;

  /**
   * Sets the value of <code>spotRadius</code>.
   * @param spotRadius The new value.
   * @see #spotRadius
   */
  public native function setSpotRadius(spotRadius:Number):void;

  /**
   * Sets the value of <code>valueSpots</code>.
   * @param valueSpots The new value.
   * @see #valueSpots
   */
  public native function setValueSpots(valueSpots:Object):void;
}
}