package ext.sparkline {

[Native("Ext.sparkline.Pie", require)]
/**
 * Plots a pie chart based upon the input {#values} array.
 * <p>See <i>the base class</i> (→<code>ext.sparkline.SparklineBase</code>) for a simple example.</p>
 * @see ext.sparkline.SparklineBase
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Pie.html Original Ext JS documentation of 'Ext.sparkline.Pie'
 */
public class SparklinePie extends SparklineBase {
  /**
   * @param config @inheritDoc
   */
  public function SparklinePie(config:SparklinePie = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Border color of line round slices.
   * @default #000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Pie.html#cfg-borderColor Original Ext JS documentation of 'borderColor'
   * @see #getBorderColor()
   * @see #setBorderColor()
   */
  public native function get borderColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set borderColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Border width in pixels of line round slices.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Pie.html#cfg-borderWidth Original Ext JS documentation of 'borderWidth'
   * @see #getBorderWidth()
   * @see #setBorderWidth()
   */
  public native function get borderWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set borderWidth(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Angle in degrees to offset the first slice.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Pie.html#cfg-offset Original Ext JS documentation of 'offset'
   * @see #getOffset()
   * @see #setOffset()
   */
  public native function get offset():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set offset(value:Number):void;

  [ArrayElementType("String")]
  [ExtConfig]
  [Bindable]
  /**
   * An array of CSS colro values to apply to the chart slices.
   * @default [
   *     '#3366cc',
   *     '#dc3912',
   *     '#ff9900',
   *     '#109618',
   *     '#66aa00',
   *     '#dd4477',
   *     '#0099c6',
   *     '#990099'
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.Pie.html#cfg-sliceColors Original Ext JS documentation of 'sliceColors'
   * @see #getSliceColors()
   * @see #setSliceColors()
   */
  public native function get sliceColors():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set sliceColors(value:Array):void;

  /**
   * Returns the value of <code>borderColor</code>.
   * @see #borderColor
   */
  public native function getBorderColor():String;

  /**
   * Returns the value of <code>borderWidth</code>.
   * @see #borderWidth
   */
  public native function getBorderWidth():Number;

  /**
   * Returns the value of <code>offset</code>.
   * @see #offset
   */
  public native function getOffset():Number;

  [ArrayElementType("String")]
  /**
   * Returns the value of <code>sliceColors</code>.
   * @see #sliceColors
   */
  public native function getSliceColors():Array;

  /**
   * Sets the value of <code>borderColor</code>.
   * @param borderColor The new value.
   * @see #borderColor
   */
  public native function setBorderColor(borderColor:String):void;

  /**
   * Sets the value of <code>borderWidth</code>.
   * @param borderWidth The new value.
   * @see #borderWidth
   */
  public native function setBorderWidth(borderWidth:Number):void;

  /**
   * Sets the value of <code>offset</code>.
   * @param offset The new value.
   * @see #offset
   */
  public native function setOffset(offset:Number):void;

  [ArrayElementType("String")]
  /**
   * Sets the value of <code>sliceColors</code>.
   * @param sliceColors The new value.
   * @see #sliceColors
   */
  public native function setSliceColors(sliceColors:Array):void;
}
}