package ext.sparkline {

[Native("Ext.sparkline.TriState", require)]
/**
 * Plots bars based upon "win"/"draw" or "lose" status of the input →<code>values</code> array.
 * Positive values mean a win, zero a draw, and negative a lose.
 * <p>See <i>the base class</i> (→<code>ext.sparkline.SparklineBase</code>) for a simple example.</p>
 * @see #values
 * @see ext.sparkline.SparklineBase
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.TriState.html Original Ext JS documentation of 'Ext.sparkline.TriState'
 */
public class SparklineTriState extends SparklineBarBase {
  /**
   * @param config @inheritDoc
   */
  public function SparklineTriState(config:SparklineTriState = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The pixel spacing between each bar.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.TriState.html#cfg-barSpacing Original Ext JS documentation of 'barSpacing'
   * @see #getBarSpacing()
   * @see #setBarSpacing()
   */
  public native function get barSpacing():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set barSpacing(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The pixel width of each bar.
   * @default 4
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.TriState.html#cfg-barWidth Original Ext JS documentation of 'barWidth'
   * @see #getBarWidth()
   * @see #setBarWidth()
   */
  public native function get barWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set barWidth(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * An object that uses range specifiers as keys to
   * indicate bar color values for a range of values. A range specifier is
   * specified in the form <code>[number]:[number]</code>, which indicates start and end range.
   * Omitting either means an open ended range.
   * <p>For example, to render green bars on all values less than -1 and red on values
   * higher than 1, you would use:</p>
   * <pre>
   * colorMap: {
   *     // Open ended range, with max value -1
   *     ":-1": "green",
   *
   *     // Open ended range, with min value 1
   *     "1:": "red"
   * }
   * </pre>
   * @default {}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.TriState.html#cfg-colorMap Original Ext JS documentation of 'colorMap'
   * @see #getColorMap()
   * @see #setColorMap()
   */
  public native function get colorMap():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set colorMap(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The color for negative value bars.
   * @default '#f44'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.TriState.html#cfg-negBarColor Original Ext JS documentation of 'negBarColor'
   * @see #getNegBarColor()
   * @see #setNegBarColor()
   */
  public native function get negBarColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set negBarColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The color for positive value bars.
   * @default '#6f6'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.TriState.html#cfg-posBarColor Original Ext JS documentation of 'posBarColor'
   * @see #getPosBarColor()
   * @see #setPosBarColor()
   */
  public native function get posBarColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set posBarColor(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The color for zero value bars.
   * @default '#999'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.sparkline.TriState.html#cfg-zeroBarColor Original Ext JS documentation of 'zeroBarColor'
   * @see #getZeroBarColor()
   * @see #setZeroBarColor()
   */
  public native function get zeroBarColor():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set zeroBarColor(value:String):void;

  /**
   * Returns the value of <code>barSpacing</code>.
   * @see #barSpacing
   */
  public native function getBarSpacing():Number;

  /**
   * Returns the value of <code>barWidth</code>.
   * @see #barWidth
   */
  public native function getBarWidth():Number;

  /**
   * Returns the value of <code>colorMap</code>.
   * @see #colorMap
   */
  public native function getColorMap():Object;

  /**
   * Returns the value of <code>negBarColor</code>.
   * @see #negBarColor
   */
  public native function getNegBarColor():String;

  /**
   * Returns the value of <code>posBarColor</code>.
   * @see #posBarColor
   */
  public native function getPosBarColor():String;

  /**
   * Returns the value of <code>zeroBarColor</code>.
   * @see #zeroBarColor
   */
  public native function getZeroBarColor():String;

  /**
   * Sets the value of <code>barSpacing</code>.
   * @param barSpacing The new value.
   * @see #barSpacing
   */
  public native function setBarSpacing(barSpacing:Number):void;

  /**
   * Sets the value of <code>barWidth</code>.
   * @param barWidth The new value.
   * @see #barWidth
   */
  public native function setBarWidth(barWidth:Number):void;

  /**
   * Sets the value of <code>colorMap</code>.
   * @param colorMap The new value.
   * @see #colorMap
   */
  public native function setColorMap(colorMap:Object):void;

  /**
   * Sets the value of <code>negBarColor</code>.
   * @param negBarColor The new value.
   * @see #negBarColor
   */
  public native function setNegBarColor(negBarColor:String):void;

  /**
   * Sets the value of <code>posBarColor</code>.
   * @param posBarColor The new value.
   * @see #posBarColor
   */
  public native function setPosBarColor(posBarColor:String):void;

  /**
   * Sets the value of <code>zeroBarColor</code>.
   * @param zeroBarColor The new value.
   * @see #zeroBarColor
   */
  public native function setZeroBarColor(zeroBarColor:String):void;
}
}