package ext.state {

[Native("Ext.state.CookieProvider", require)]
/**
 * A Provider implementation which saves and retrieves state via cookies. The CookieProvider
 * supports the usual cookie options, such as:
 * <ul>
 * <li>→<code>path</code></li>
 * <li>→<code>expires</code></li>
 * <li>→<code>domain</code></li>
 * <li>→<code>secure</code></li>
 * </ul>
 * <p>Example:</p>
 * <pre>
 * var cp = Ext.create('Ext.state.CookieProvider', {
 *     path: "/cgi-bin/",
 *     expires: new Date(new Date().getTime()+(1000&#42;60&#42;60&#42;24&#42;30)), //30 days
 *     domain: "sencha.com"
 * });
 *
 * Ext.state.Manager.setProvider(cp);
 * </pre>
 * @see #path
 * @see #expires
 * @see #domain
 * @see #secure
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.CookieProvider.html Original Ext JS documentation of 'Ext.state.CookieProvider'
 */
public class CookieProvider extends Provider {
  /**
   * Creates a new CookieProvider.
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.CookieProvider.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function CookieProvider(config:CookieProvider = null) {
    super();
  }

  [ExtConfig]
  /**
   * The domain to save the cookie for. Note that you cannot specify a different domain
   * than your page is on, but you can specify a sub-domain, or simply the domain itself
   * like 'sencha.com' to include all sub-domains if you need to access cookies across different
   * sub-domains. Defaults to null which uses the same domain the page is running on including
   * the 'www' like 'www.sencha.com'.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.CookieProvider.html#cfg-domain Original Ext JS documentation of 'domain'
   */
  public native function get domain():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set domain(value:String):void;

  [ExtConfig]
  /**
   * The cookie expiration date. Defaults to 7 days from now.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.CookieProvider.html#cfg-expires Original Ext JS documentation of 'expires'
   */
  public native function get expires():Date;

  [ExtConfig]
  /**
   * @private
   */
  public native function set expires(value:Date):void;

  [ExtConfig]
  /**
   * The path for which the cookie is active. Defaults to root '/' which makes it active
   * for all pages in the site.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.CookieProvider.html#cfg-path Original Ext JS documentation of 'path'
   */
  public native function get path():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set path(value:String):void;

  [ExtConfig]
  /**
   * True if the site is using SSL
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.CookieProvider.html#cfg-secure Original Ext JS documentation of 'secure'
   */
  public native function get secure():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set secure(value:Boolean):void;
}
}