package ext.state {
import ext.mixin.Observable;

[Native("Ext.state.Provider", require)]
/**
 * @see ext.state.events.Provider_key_valueEvent.STATE_CHANGE
 * @eventType ext.state.events.Provider_key_valueEvent.STATE_CHANGE
 */
[Event(name='onStateChange', type='ext.state.events.Provider_key_valueEvent')]
/**
 * Abstract base class for state provider implementations. The provider is responsible
 * for setting values  and extracting values to/from the underlying storage source. The
 * storage source can vary and the details should be implemented in a subclass. For example
 * a provider could use a server side database or the browser localstorage where supported.
 * <p>This class provides methods for encoding and decoding <b>typed</b> variables including
 * dates and defines the Provider interface. By default these methods put the value and the
 * type information into a delimited string that can be stored. These should be overridden in
 * a subclass if you want to change the format of the encoded value and subsequent decoding.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Provider.html Original Ext JS documentation of 'Ext.state.Provider'
 */
public class Provider extends Observable {
  /**
   * @param config @inheritDoc
   */
  public function Provider(config:Provider = null) {
    super();
  }

  [ExtConfig]
  /**
   * A string to prefix to items stored in the underlying state store.
   * Defaults to <tt>'ext-'</tt>
   * @default 'ext-'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Provider.html#cfg-prefix Original Ext JS documentation of 'prefix'
   */
  public native function get prefix():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set prefix(value:String):void;

  /**
   * Clears a value from the state
   * @param name The key name
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Provider.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear(name:String):void;

  /**
   * Decodes a string previously encoded with →<code>encodeValue()</code>.
   * @param value The value to decode
   * @return The decoded value
   * @see #encodeValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Provider.html#method-decodeValue Original Ext JS documentation of 'decodeValue'
   */
  public native function decodeValue(value:String):*;

  /**
   * Encodes a value including type information. Decode with →<code>decodeValue()</code>.
   * @param value The value to encode
   * @return The encoded value
   * @see #decodeValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Provider.html#method-encodeValue Original Ext JS documentation of 'encodeValue'
   */
  public native function encodeValue(value:*):String;

  /**
   * Returns the current value for a key
   * @param name The key name
   * @param defaultValue A default value to return if the key's value is not found
   * @return The state data
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Provider.html#method-get Original Ext JS documentation of 'get'
   */
  public native function get(name:String, defaultValue:*):*;

  /**
   * Sets the value for a key
   * @param name The key name
   * @param value The value to set
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Provider.html#method-set Original Ext JS documentation of 'set'
   */
  public native function set(name:String, value:*):void;
}
}