package ext.state {
import ext.Base;

[Native]
/**
 * This is the global state manager. By default all components that are "state aware"
 * check this class for state information if you don't pass them a custom state provider.
 * In order for this class to be useful, it must be initialized with a provider
 * when your application initializes. Example usage:
 * <pre>
 *  // in your initialization function
 *  init: function() {
 *      Ext.state.Manager.setProvider(new Ext.state.CookieProvider());
 *  }
 * </pre>
 * <p>This class passes on calls from components to the underlying →<code>ext.state.Provider</code> so that
 * there is a common interface that can be used without needing to refer to a specific provider
 * instance in every component.</p>
 * <p>Type of singleton StateManager.</p>
 * @see ext.state.Provider
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Manager.html Original Ext JS documentation of 'Ext.state.Manager'
 * @see ext.state.#StateManager ext.state.StateManager
 */
public class SStateManager extends Base {
  /**
   * Clears a value from the state
   * @param key The key name
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Manager.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear(key:String):void;

  /**
   * Returns the current value for a key
   * @param key The key name
   * @param defaultValue The default value to return if the key lookup does not match
   * @return The state data
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Manager.html#method-get Original Ext JS documentation of 'get'
   */
  public native function get(key:String, defaultValue:Object):Object;

  /**
   * Gets the currently configured state provider
   * @return The state provider
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Manager.html#method-getProvider Original Ext JS documentation of 'getProvider'
   */
  public native function getProvider():Provider;

  /**
   * Sets the value for a key
   * @param key The key name
   * @param value The state data
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Manager.html#method-set Original Ext JS documentation of 'set'
   */
  public native function set(key:String, value:Object):void;

  /**
   * Configures the default state provider for your application
   * @param stateProvider The state provider to set
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Manager.html#method-setProvider Original Ext JS documentation of 'setProvider'
   */
  public native function setProvider(stateProvider:Provider):void;
}
}