package ext.state {

[Native("Ext.state.Manager", require)]
/**
 * This is the global state manager. By default all components that are "state aware"
 * check this class for state information if you don't pass them a custom state provider.
 * In order for this class to be useful, it must be initialized with a provider
 * when your application initializes. Example usage:
 * <pre>
 *  // in your initialization function
 *  init: function() {
 *      Ext.state.Manager.setProvider(new Ext.state.CookieProvider());
 *  }
 * </pre>
 * <p>This class passes on calls from components to the underlying →<code>ext.state.Provider</code> so that
 * there is a common interface that can be used without needing to refer to a specific provider
 * instance in every component.</p>
 * @see ext.state.Provider
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Manager.html Original Ext JS documentation of 'Ext.state.Manager'
 */
public const StateManager:SStateManager = new SStateManager;
}