package ext.system {
[Rename("Ext.system.PlaceholderReplacer")]
internal class PlaceholderReplacer {

  private static function getPlaceholderValue(manifest:Object, prefix:String, placeholder:String):String {
    if (placeholder === "build.environment") {
      return "development"; // Jangaroo builds are always "development"
    }
    if (placeholder.indexOf(prefix) === 0) {
      return manifest[placeholder.substr(prefix.length)];
    }
    trace("[WARN]", "Unknown placeholder '" + placeholder + "'.");
  }

  private static const PLACEHOLDER_PATTERN:RegExp = /\${([a-z][a-z0-9_$.-]*)}/ig;

  internal static function substitutePlaceholders(manifest:Object, prefix:String = ""):Function {
    return function (input:String):String {
      var output:String = input;

      while (true) {
        PLACEHOLDER_PATTERN.lastIndex = 0; // reset match state before reusing the global RegExp!
        var match:Array = PLACEHOLDER_PATTERN.exec(output);
        if (!match) {
          break;
        }
        var length:int = match[0].length;
        var startIndex:int = PLACEHOLDER_PATTERN.lastIndex - length;
        var placeholder:String = match[1];
        var value:String = getPlaceholderValue(manifest, prefix, placeholder);
        output = output.substr(0, startIndex) + value + output.substr(startIndex + length);
      }
      return output;
    }
  }

}
}
