package ext.tab {
import ext.Component;
import ext.button.Button;

[Native("Ext.tab.Tab", require)]
/**
 * @see ext.tab.events.TabEvent.ACTIVATE
 * @eventType ext.tab.events.TabEvent.ACTIVATE
 */
[Event(name='onActivate', type='ext.tab.events.TabEvent')]
/**
 * @see ext.tab.events.TabEvent.BEFORE_CLOSE
 * @eventType ext.tab.events.TabEvent.BEFORE_CLOSE
 */
[Event(name='onBeforeClose', type='ext.tab.events.TabEvent')]
/**
 * @see ext.tab.events.TabEvent.CLOSE
 * @eventType ext.tab.events.TabEvent.CLOSE
 */
[Event(name='onClose', type='ext.tab.events.TabEvent')]
/**
 * @see ext.tab.events.TabEvent.DEACTIVATE
 * @eventType ext.tab.events.TabEvent.DEACTIVATE
 */
[Event(name='onDeactivate', type='ext.tab.events.TabEvent')]
/**
 * Represents a single Tab in a →<code>ext.tab.TabPanel</code>. A Tab is simply a slightly
 * customized →<code>ext.button.Button</code>, styled to look like a tab. Tabs are optionally
 * closable, and can also be disabled. 99% of the time you will not need to create Tabs manually
 * as the framework does so automatically when you use a →<code>ext.tab.TabPanel</code>
 * @see ext.tab.TabPanel
 * @see ext.button.Button
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Tab.html Original Ext JS documentation of 'Ext.tab.Tab'
 */
public class Tab extends Button {
  /**
   * @param config @inheritDoc
   */
  public function Tab(config:Tab = null) {
    super();
  }

  /**
   * Indicates that this tab is currently active. This is NOT a public configuration.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Tab.html#property-active Original Ext JS documentation of 'active'
   */
  public native function get active():Boolean;

  [ExtConfig]
  /**
   * True if the tab is currently closable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Tab.html#property-closable Original Ext JS documentation of 'closable'
   * @see #setClosable()
   */
  public native function get closable():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set closable(value:Boolean):void;

  [ExtConfig]
  /**
   * The accessible text label for the close button link to be announced by screen readers
   * when the tab is focused. This text does not appear visually and is only used when
   * →<code>closable</code> is <code>true</code>.
   * @default "removable"
   * @see #closable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Tab.html#cfg-closeText Original Ext JS documentation of 'closeText'
   */
  public native function get closeText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set closeText(value:String):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Tab, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Tab.html#property-isTab Original Ext JS documentation of 'isTab'
   */
  public native function get isTab():Boolean;

  /**
   * @private
   */
  public native function set isTab(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The rotation of the tab. Can be one of the following values:
   * <ul>
   * <li><code>null</code> - use the default rotation, depending on the dock position of the tabbar</li>
   * <li><code>0</code> - no rotation</li>
   * <li><code>1</code> - rotate 90deg clockwise</li>
   * <li><code>2</code> - rotate 90deg counter-clockwise</li>
   * </ul>
   * <p>The default behavior of this config depends on the dock position of the tabbar:</p>
   * <ul>
   * <li><code>'top'</code> or <code>'bottom'</code> - <code>0</code></li>
   * <li><code>'right'</code> - <code>1</code></li>
   * <li><code>'left'</code> - <code>2</code></li>
   * </ul>
   * @default 'default'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Tab.html#cfg-rotation Original Ext JS documentation of 'rotation'
   * @see #getRotation()
   * @see #setRotation()
   */
  public native function get rotation():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set rotation(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The tab's position. Users should not typically need to set this, as it is
   * configured automatically by the tab bar
   * @default 'top'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Tab.html#cfg-tabPosition Original Ext JS documentation of 'tabPosition'
   * @see #getTabPosition()
   * @see #setTabPosition()
   */
  public native function get tabPosition():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tabPosition(value:String):void;

  /**
   * Returns the value of <code>rotation</code>.
   * @see #rotation
   */
  public native function getRotation():*;

  /**
   * Returns the value of <code>tabPosition</code>.
   * @see #tabPosition
   */
  public native function getTabPosition():String;

  /**
   * Sets this tab's attached card. Usually this is handled automatically by the
   * →<code>ext.tab.TabPanel</code> that this Tab belongs to and would not need to be done by the developer
   * @param card The card to set
   * @see ext.tab.TabPanel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Tab.html#method-setCard Original Ext JS documentation of 'setCard'
   */
  public native function setCard(card:Component):void;

  /**
   * Sets the tab as either closable or not.
   * @param closable Pass false to make the tab not closable. Otherwise the tab
   * will be made closable (eg a close button will appear on the tab)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Tab.html#method-setClosable Original Ext JS documentation of 'setClosable'
   */
  public native function setClosable(closable:Boolean):void;

  /**
   * Sets the value of <code>rotation</code>.
   * @param rotation The new value.
   * @see #rotation
   */
  public native function setRotation(rotation:*):void;

  /**
   * Sets the value of <code>tabPosition</code>.
   * @param tabPosition The new value.
   * @see #tabPosition
   */
  public native function setTabPosition(tabPosition:String):void;
}
}