package ext.tab {
import ext.panel.PanelBar;

[Native("Ext.tab.Bar", require)]
/**
 * @see ext.tab.events.TabBar_tab_cardEvent.CHANGE
 * @eventType ext.tab.events.TabBar_tab_cardEvent.CHANGE
 */
[Event(name='onChange', type='ext.tab.events.TabBar_tab_cardEvent')]
/**
 * TabBar is used internally by a →<code>ext.tab.TabPanel</code> and typically should not
 * need to be created manually.
 * @see ext.tab.TabPanel
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Bar.html Original Ext JS documentation of 'Ext.tab.Bar'
 */
public class TabBar extends PanelBar {
  /**
   * @param config @inheritDoc
   */
  public function TabBar(config:TabBar = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to follow WAI-ARIA requirement and activate tab when it is navigated to
   * with arrow keys, or <code>false</code> to disable that behavior. When activation on focus
   * is disabled, users will have to use arrow keys to focus a tab, and then press
   * Space key to activate it.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Bar.html#cfg-activateOnFocus Original Ext JS documentation of 'activateOnFocus'
   * @see #getActivateOnFocus()
   * @see #setActivateOnFocus()
   */
  public native function get activateOnFocus():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set activateOnFocus(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to ensure the active tab is scrolled into view when the tab changes, the text, the
   * icon or the glyph. This is only applicable if using an overflow scroller.
   * @default true
   * @since 5.1.1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Bar.html#cfg-ensureActiveVisibleOnChange Original Ext JS documentation of 'ensureActiveVisibleOnChange'
   */
  public native function get ensureActiveVisibleOnChange():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ensureActiveVisibleOnChange(value:Boolean):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Tab Bar, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Bar.html#property-isTabBar Original Ext JS documentation of 'isTabBar'
   */
  public native function get isTabBar():Boolean;

  /**
   * @private
   */
  public native function set isTabBar(value:Boolean):void;

  [Deprecated(replacement="maxTabWidth", since="6.5.0")]
  [ExtConfig]
  /**
   * The maximum width for a tab in this tab Bar. Defaults to the tab Panel's
   * →<code>ext.tab.TabPanel.maxTabWidth</code> value.
   * @see ext.tab.TabPanel#maxTabWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Bar.html#cfg-maxTabWidth Original Ext JS documentation of 'maxTabWidth'
   */
  public native function get maxTabWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maxTabWidth(value:Number):void;

  [Deprecated(replacement="minTabWidth", since="6.5.0")]
  [ExtConfig]
  /**
   * The minimum width for a tab in this tab Bar. Defaults to the tab Panel's
   * →<code>ext.tab.TabPanel.minTabWidth</code> value.
   * @see ext.tab.TabPanel#minTabWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Bar.html#cfg-minTabWidth Original Ext JS documentation of 'minTabWidth'
   */
  public native function get minTabWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minTabWidth(value:Number):void;

  [ExtConfig]
  /**
   * True to not show the full background on the tabbar
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Bar.html#cfg-plain Original Ext JS documentation of 'plain'
   */
  public native function get plain():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set plain(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The rotation of the tabs. Can be one of the following values:
   * <ul>
   * <li><code>default</code> - use the default rotation, depending on the dock position (see below)</li>
   * <li><code>0</code> - no rotation</li>
   * <li><code>1</code> - rotate 90deg clockwise</li>
   * <li><code>2</code> - rotate 90deg counter-clockwise</li>
   * </ul>
   * <p>The default behavior of this config depends on the dock position:</p>
   * <ul>
   * <li><code>'top'</code> or <code>'bottom'</code> - <code>0</code></li>
   * <li><code>'right'</code> - <code>1</code></li>
   * <li><code>'left'</code> - <code>2</code></li>
   * </ul>
   * @default 'default'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Bar.html#cfg-tabRotation Original Ext JS documentation of 'tabRotation'
   * @see #getTabRotation()
   * @see #setTabRotation()
   */
  public native function get tabRotation():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tabRotation(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to stretch all tabs to the height of the tallest tab when the tabBar
   * is docked horizontally, or the width of the widest tab when the tabBar is
   * docked vertically.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Bar.html#cfg-tabStretchMax Original Ext JS documentation of 'tabStretchMax'
   * @see #getTabStretchMax()
   * @see #setTabStretchMax()
   */
  public native function get tabStretchMax():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tabStretchMax(value:Boolean):void;

  /**
   * Ensure the passed tab is visible if using overflow scrolling
   * @param tab The tab, item in the owning
   * →<code>ext.tab.TabPanel</code> or the index of the item to scroll to. Defaults to the active tab.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Bar.html#method-ensureTabVisible Original Ext JS documentation of 'ensureTabVisible'
   * @see ext.tab.TabPanel
   */
  public native function ensureTabVisible(tab:* = undefined):void;

  /**
   * Returns the value of <code>activateOnFocus</code>.
   * @see #activateOnFocus
   */
  public native function getActivateOnFocus():Boolean;

  /**
   * Returns the value of <code>tabRotation</code>.
   * @see #tabRotation
   */
  public native function getTabRotation():*;

  /**
   * Returns the value of <code>tabStretchMax</code>.
   * @see #tabStretchMax
   */
  public native function getTabStretchMax():Boolean;

  /**
   * Sets the value of <code>activateOnFocus</code>.
   * @param activateOnFocus The new value.
   * @see #activateOnFocus
   */
  public native function setActivateOnFocus(activateOnFocus:Boolean):void;

  /**
   * Sets the value of <code>tabRotation</code>.
   * @param tabRotation The new value.
   * @see #tabRotation
   */
  public native function setTabRotation(tabRotation:*):void;

  /**
   * Sets the value of <code>tabStretchMax</code>.
   * @param tabStretchMax The new value.
   * @see #tabStretchMax
   */
  public native function setTabStretchMax(tabStretchMax:Boolean):void;
}
}