package ext.tab {
import ext.Component;
import ext.panel.Panel;

[Native("Ext.tab.Panel", require)]
/**
 * @see ext.tab.events.TabPanel_newCard_oldCardEvent.BEFORE_TAB_CHANGE
 * @eventType ext.tab.events.TabPanel_newCard_oldCardEvent.BEFORE_TAB_CHANGE
 */
[Event(name='onBeforeTabChange', type='ext.tab.events.TabPanel_newCard_oldCardEvent')]
/**
 * @see ext.tab.events.TabPanel_newCard_oldCardEvent.TAB_CHANGE
 * @eventType ext.tab.events.TabPanel_newCard_oldCardEvent.TAB_CHANGE
 */
[Event(name='onTabChange', type='ext.tab.events.TabPanel_newCard_oldCardEvent')]
/**
 * A basic tab container. TabPanels can be used exactly like a standard →<code>ext.panel.Panel</code> for
 * layout purposes, but also have special support for containing child Components
 * (<code>→ext.container.Container.items</code>) that are managed using a
 * <i>CardLayout layout manager</i> (→<code>ext.layout.container.CardLayout</code>), and displayed as separate tabs.
 * <p><b>Note:</b> By default, a tab's close tool <i>destroys</i> the child tab Component and all its
 * descendants. This makes the child tab Component, and all its descendants <b>unusable</b>.
 * To enable re-use of a tab, configure the TabPanel with <code>autoDestroy: false (→autoDestroy)</code>.</p>
 * <p><b><i>TabPanel's layout</i></b></p>
 * <p>TabPanels use a Dock layout to position the →<code>ext.tab.TabBar</code> at the top of the widget.
 * Panels added to the TabPanel will have their header hidden by default because the Tab will
 * automatically take the Panel's configured title and icon.</p>
 * <p>TabPanels use their <i>header</i> (→<code>ext.panel.PanelHeader</code>) or <i>footer</i> (→<code>ext.panel.Panel.fbar</code>)
 * element (depending on the →<code>tabPosition</code> configuration) to accommodate the tab selector
 * buttons. This means that a TabPanel will not display any configured title, and will not display
 * any configured header →<code>ext.panel.Panel.tools</code>.</p>
 * <p>To display a header, embed the TabPanel in a →<code>ext.panel.Panel</code> which uses
 * <code>layout: 'fit' (→ext.container.Container.layout)</code>.</p>
 * <p><b><i>Controlling tabs</i></b></p>
 * <p>Configuration options for the →<code>ext.tab.Tab</code> that represents the component can be passed in
 * by specifying the tabConfig option:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.tip.QuickTipManager.init();
 * Ext.create('Ext.tab.Panel', {
 *     width: 400,
 *     height: 400,
 *     renderTo: document.body,
 *     items: [{
 *         title: 'Foo'
 *     }, {
 *         title: 'Bar',
 *         tabConfig: {
 *             title: 'Custom Title',
 *             tooltip: 'A button tooltip'
 *         }
 *     }]
 * });
 * </pre>
 * <p><b><i>Vetoing Changes</i></b></p>
 * <p>User interaction when changing the tabs can be vetoed by listening to the
 * →<code>event:onBeforeTabChange</code> event. By returning <code>false</code>, the tab change will not occur.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.tab.Panel', {
 *     renderTo: Ext.getBody(),
 *     width: 200,
 *     height: 200,
 *     listeners: {
 *         beforetabchange: function(tabs, newTab, oldTab) {
 *             return newTab.title != 'P2';
 *         }
 *     },
 *     items: [{
 *         title: 'P1'
 *     }, {
 *         title: 'P2'
 *     }, {
 *         title: 'P3'
 *     }]
 * });
 * </pre>
 * <p><b>Examples</b></p>
 * <p>Here is a basic TabPanel rendered to the body. This also shows the useful configuration
 * →<code>activeTab</code>, which allows you to set the active tab on render.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.tab.Panel', {
 *     width: 300,
 *     height: 200,
 *     activeTab: 0,
 *     items: [
 *         {
 *             title: 'Tab 1',
 *             bodyPadding: 10,
 *             html : 'A simple tab'
 *         },
 *         {
 *             title: 'Tab 2',
 *             html : 'Another one'
 *         }
 *     ],
 *     renderTo : Ext.getBody()
 * });
 * </pre>
 * <p>It is easy to control the visibility of items in the tab bar. Specify hidden: true to have the
 * tab button hidden initially. Items can be subsequently hidden and show by accessing the
 * tab property on the child item.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var tabs = Ext.create('Ext.tab.Panel', {
 *     width: 400,
 *     height: 400,
 *     renderTo: document.body,
 *     items: [{
 *         title: 'Home',
 *         html: 'Home',
 *         itemId: 'home'
 *     }, {
 *         title: 'Users',
 *         html: 'Users',
 *         itemId: 'users',
 *         hidden: true
 *     }, {
 *         title: 'Tickets',
 *         html: 'Tickets',
 *         itemId: 'tickets'
 *     }]
 * });
 *
 * Ext.defer(function(){
 *     tabs.child('#home').tab.hide();
 *     var users = tabs.child('#users');
 *     users.tab.show();
 *     tabs.setActiveTab(users);
 * }, 1000);
 * </pre>
 * <p>You can remove the background of the TabBar by setting the →<code>plain</code> property to <code>true</code>.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.tab.Panel', {
 *     width: 300,
 *     height: 200,
 *     activeTab: 0,
 *     plain: true,
 *     items: [
 *         {
 *             title: 'Tab 1',
 *             bodyPadding: 10,
 *             html : 'A simple tab'
 *         },
 *         {
 *             title: 'Tab 2',
 *             html : 'Another one'
 *         }
 *     ],
 *     renderTo : Ext.getBody()
 * });
 * </pre>
 * <p>Another useful configuration of TabPanel is →<code>tabPosition</code>. This allows you to change the
 * position where the tabs are displayed. The available options for this are <code>'top'</code> (default) and
 * <code>'bottom'</code>.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.tab.Panel', {
 *     width: 300,
 *     height: 200,
 *     activeTab: 0,
 *     bodyPadding: 10,
 *     tabPosition: 'bottom',
 *     items: [
 *         {
 *             title: 'Tab 1',
 *             html : 'A simple tab'
 *         },
 *         {
 *             title: 'Tab 2',
 *             html : 'Another one'
 *         }
 *     ],
 *     renderTo : Ext.getBody()
 * });
 * </pre>
 * <p>The →<code>setActiveTab()</code> is a very useful method in TabPanel which will allow you to change the
 * current active tab. You can either give it an index or an instance of a tab. For example:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var tabs = Ext.create('Ext.tab.Panel', {
 *     items: [
 *         {
 *             id   : 'my-tab',
 *             title: 'Tab 1',
 *             html : 'A simple tab'
 *         },
 *         {
 *             title: 'Tab 2',
 *             html : 'Another one'
 *         }
 *     ],
 *     renderTo : Ext.getBody()
 * });
 *
 * var tab = Ext.getCmp('my-tab');
 *
 * Ext.create('Ext.button.Button', {
 *     renderTo: Ext.getBody(),
 *     text    : 'Select the first tab',
 *     scope   : this,
 *     handler : function() {
 *         tabs.setActiveTab(tab);
 *     }
 * });
 *
 * Ext.create('Ext.button.Button', {
 *     text    : 'Select the second tab',
 *     scope   : this,
 *     handler : function() {
 *         tabs.setActiveTab(1);
 *     },
 *     renderTo : Ext.getBody()
 * });
 * </pre>
 * <p>The →<code>getActiveTab()</code> is a another useful method in TabPanel which will return the current
 * active tab.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var tabs = Ext.create('Ext.tab.Panel', {
 *     items: [
 *         {
 *             title: 'Tab 1',
 *             html : 'A simple tab'
 *         },
 *         {
 *             title: 'Tab 2',
 *             html : 'Another one'
 *         }
 *     ],
 *     renderTo : Ext.getBody()
 * });
 *
 * Ext.create('Ext.button.Button', {
 *     text    : 'Get active tab',
 *     scope   : this,
 *     handler : function() {
 *         var tab = tabs.getActiveTab();
 *         alert('Current tab: ' + tab.title);
 *     },
 *     renderTo : Ext.getBody()
 * });
 * </pre>
 * <p>Adding a new tab is very simple with a TabPanel. You simple call the →<code>add()</code> method
 * with an config object for a panel.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var tabs = Ext.create('Ext.tab.Panel', {
 *     items: [
 *         {
 *             title: 'Tab 1',
 *             html : 'A simple tab'
 *         },
 *         {
 *             title: 'Tab 2',
 *             html : 'Another one'
 *         }
 *     ],
 *     renderTo : Ext.getBody()
 * });
 *
 * Ext.create('Ext.button.Button', {
 *     text    : 'New tab',
 *     scope   : this,
 *     handler : function() {
 *         var tab = tabs.add({
 *             // we use the tabs.items property to get the length of current items/tabs
 *             title: 'Tab ' + (tabs.items.length + 1),
 *             html : 'Another one'
 *         });
 *
 *         tabs.setActiveTab(tab);
 *     },
 *     renderTo : Ext.getBody()
 * });
 * </pre>
 * <p>Additionally, removing a tab is very also simple with a TabPanel. You simple call the
 * →<code>remove()</code> method with an config object for a panel.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var tabs = Ext.create('Ext.tab.Panel', {
 *     items: [
 *         {
 *             title: 'Tab 1',
 *             html : 'A simple tab'
 *         },
 *         {
 *             id   : 'remove-this-tab',
 *             title: 'Tab 2',
 *             html : 'Another one'
 *         }
 *     ],
 *     renderTo : Ext.getBody()
 * });
 *
 * Ext.create('Ext.button.Button', {
 *     text    : 'Remove tab',
 *     scope   : this,
 *     handler : function() {
 *         var tab = Ext.getCmp('remove-this-tab');
 *         tabs.remove(tab);
 *     },
 *     renderTo : Ext.getBody()
 * });
 * </pre>
 * @see ext.panel.Panel
 * @see ext.container.Container#items
 * @see ext.layout.container.CardLayout
 * @see #autoDestroy
 * @see ext.tab.TabBar
 * @see ext.panel.PanelHeader
 * @see ext.panel.Panel#fbar
 * @see #tabPosition
 * @see ext.panel.Panel#tools
 * @see ext.container.Container#layout
 * @see ext.tab.Tab
 * @see #event:onBeforeTabChange
 * @see #activeTab
 * @see #plain
 * @see #setActiveTab()
 * @see #getActiveTab()
 * @see #add()
 * @see #remove()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html Original Ext JS documentation of 'Ext.tab.Panel'
 */
public class TabPanel extends Panel {
  /**
   * @param config @inheritDoc
   */
  public function TabPanel(config:TabPanel = null) {
    super();
  }

  [ExtConfig]
  /**
   * Doesn't apply for →<code>ext.tab.TabPanel</code>, use →<code>activeTab</code> instead.
   * @see ext.tab.TabPanel
   * @see #activeTab
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-activeItem Original Ext JS documentation of 'activeItem'
   * @see #setActiveItem()
   */
  override public native function get activeItem():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set activeItem(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The tab to activate initially. Either an ID, index or the tab component itself.
   * If null, no tab will be set as active.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-activeTab Original Ext JS documentation of 'activeTab'
   * @see #getActiveTab()
   * @see #setActiveTab()
   */
  public native function get activeTab():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set activeTab(value:*):void;

  [ExtConfig]
  /**
   * True by default to defer the rendering of child
   * →<code>ext.container.Container.items</code> to the browsers DOM until a tab is activated.
   * False will render all contained →<code>ext.container.Container.items</code> as soon as
   * the <i>layout</i> (→<code>ext.layout.container.CardLayout</code>) is rendered. If there is a significant amount
   * of content or a lot of heavy controls being rendered into panels that are not displayed
   * by default, setting this to true might improve performance.
   * <p>The deferredRender property is internally passed to the layout manager for TabPanels
   * (→<code>ext.layout.container.CardLayout</code>) as its →<code>ext.layout.container.CardLayout.deferredRender</code>
   * configuration value.</p>
   * <p><b>Note</b>: leaving deferredRender as true means that the content within an unactivated tab
   * will not be available</p>
   * @default true
   * @see ext.container.Container#items
   * @see ext.layout.container.CardLayout
   * @see ext.layout.container.CardLayout#deferredRender
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-deferredRender Original Ext JS documentation of 'deferredRender'
   */
  public native function get deferredRender():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set deferredRender(value:Boolean):void;

  [ExtConfig]
  /**
   * The class added to each child item of this TabPanel.
   * @default 'x-tabpanel-child'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-itemCls Original Ext JS documentation of 'itemCls'
   */
  public native function get itemCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set itemCls(value:String):void;

  [ExtConfig]
  /**
   * Optional configuration object for the internal <i>card layout</i> (→<code>ext.layout.container.CardLayout</code>).
   * If present, this is passed straight through to the layout's constructor
   * @see ext.layout.container.CardLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-layout Original Ext JS documentation of 'layout'
   * @see #setLayout()
   */
  override public native function get layout():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set layout(value:*):void;

  [ExtConfig]
  /**
   * The maximum width for each tab.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-maxTabWidth Original Ext JS documentation of 'maxTabWidth'
   */
  public native function get maxTabWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maxTabWidth(value:Number):void;

  [ExtConfig]
  /**
   * The minimum width for a tab in the →<code>tabBar</code>.
   * @default undefined
   * @see #tabBar
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-minTabWidth Original Ext JS documentation of 'minTabWidth'
   */
  public native function get minTabWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minTabWidth(value:Number):void;

  [ExtConfig]
  /**
   * True to not show the full background on the TabBar.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-plain Original Ext JS documentation of 'plain'
   */
  public native function get plain():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set plain(value:Boolean):void;

  [ExtConfig]
  /**
   * True to instruct each Panel added to the TabContainer to not render its header element.
   * This is to ensure that the title of the panel does not appear twice.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-removePanelHeader Original Ext JS documentation of 'removePanelHeader'
   */
  public native function get removePanelHeader():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set removePanelHeader(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Optional configuration object for the internal →<code>ext.tab.TabBar</code>.
   * If present, this is passed straight through to the TabBar's constructor
   * @default undefined
   * @see ext.tab.TabBar
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-tabBar Original Ext JS documentation of 'tabBar'
   * @see #getTabBar()
   * @see #setTabBar()
   */
  public native function get tabBar():TabBar;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tabBar(value:TabBar):void;

  [ExtConfig]
  /**
   * If specified, the →<code>tabBar</code> will be rendered as an item of the TabPanel's
   * Header and the specified <code>→tabBarHeaderPosition</code> will be used as the Panel header's
   * →<code>ext.panel.PanelHeader.itemPosition</code>. If not specified, the →<code>tabBar</code>
   * will be rendered as a docked item at →<code>tabPosition</code>.
   * @see #tabBar
   * @see #tabBarHeaderPosition
   * @see ext.panel.PanelHeader#itemPosition
   * @see #tabPosition
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-tabBarHeaderPosition Original Ext JS documentation of 'tabBarHeaderPosition'
   */
  public native function get tabBarHeaderPosition():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tabBarHeaderPosition(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The position where the tab strip should be rendered. Possible values are:
   * <ul>
   * <li>top</li>
   * <li>bottom</li>
   * <li>left</li>
   * <li>right</li>
   * </ul>
   * @default 'top'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-tabPosition Original Ext JS documentation of 'tabPosition'
   * @see #getTabPosition()
   * @see #setTabPosition()
   */
  public native function get tabPosition():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tabPosition(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The rotation of the tabs. Can be one of the following values:
   * <ul>
   * <li><code>'default'</code> use the default rotation, depending on →<code>tabPosition</code> (see below)</li>
   * <li><code>0</code> - no rotation</li>
   * <li><code>1</code> - rotate 90deg clockwise</li>
   * <li><code>2</code> - rotate 90deg counter-clockwise</li>
   * </ul>
   * <p>The default behavior of this config depends on the →<code>tabPosition</code>:</p>
   * <ul>
   * <li><code>'top'</code> or <code>'bottom'</code> - <code>0</code></li>
   * <li><code>'right'</code> - <code>1</code></li>
   * <li><code>'left'</code> - <code>2</code></li>
   * </ul>
   * @default 'default'
   * @see #tabPosition
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-tabRotation Original Ext JS documentation of 'tabRotation'
   * @see #getTabRotation()
   * @see #setTabRotation()
   */
  public native function get tabRotation():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tabRotation(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to stretch all tabs to the height of the tallest tab when the tabBar
   * is docked horizontally, or the width of the widest tab when the tabBar is
   * docked vertically.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#cfg-tabStretchMax Original Ext JS documentation of 'tabStretchMax'
   * @see #getTabStretchMax()
   * @see #setTabStretchMax()
   */
  public native function get tabStretchMax():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tabStretchMax(value:Boolean):void;

  /**
   * Returns the item that is currently active inside this TabPanel.
   * @return The currently active item.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#method-getActiveTab Original Ext JS documentation of 'getActiveTab'
   */
  public native function getActiveTab():Component;

  /**
   * Returns the value of <code>tabBar</code>.
   * @see #tabBar
   */
  public native function getTabBar():TabBar;

  /**
   * Returns the value of <code>tabPosition</code>.
   * @see #tabPosition
   */
  public native function getTabPosition():String;

  /**
   * Returns the value of <code>tabRotation</code>.
   * @see #tabRotation
   */
  public native function getTabRotation():*;

  /**
   * Returns the value of <code>tabStretchMax</code>.
   * @see #tabStretchMax
   */
  public native function getTabStretchMax():Boolean;

  /**
   * Makes sure we have a Tab for each item added to the TabPanel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#method-onAdd Original Ext JS documentation of 'onAdd'
   */
  override protected native function onAdd(component:Component, position:Number):void;

  /**
   * Makes the given card active. Makes it the visible card in the TabPanel's CardLayout
   * and highlights the Tab.
   * @param card The card to make active. Either an ID,
   * index or the component itself.
   * @return The resulting active child Component. The call may have been vetoed,
   * or otherwise modified by an event listener.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Panel.html#method-setActiveTab Original Ext JS documentation of 'setActiveTab'
   */
  public native function setActiveTab(card:*):Component;

  /**
   * Sets the value of <code>tabBar</code>.
   * @param tabBar The new value.
   * @see #tabBar
   */
  public native function setTabBar(tabBar:TabBar):void;

  /**
   * Sets the value of <code>tabPosition</code>.
   * @param tabPosition The new value.
   * @see #tabPosition
   */
  public native function setTabPosition(tabPosition:String):void;

  /**
   * Sets the value of <code>tabRotation</code>.
   * @param tabRotation The new value.
   * @see #tabRotation
   */
  public native function setTabRotation(tabRotation:*):void;

  /**
   * Sets the value of <code>tabStretchMax</code>.
   * @param tabStretchMax The new value.
   * @see #tabStretchMax
   */
  public native function setTabStretchMax(tabStretchMax:Boolean):void;
}
}