package ext.tab.events {
import ext.Component;
import ext.tab.Tab;
import ext.tab.TabBar;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.tab.events.TabBar_tab_cardEvent")]
public class TabBar_tab_cardEvent extends FlExtEvent {
  /**
   * Fired when the currently-active tab has changed
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tab.Bar.html#event-change Original Ext JS documentation of 'change'
   * @see ext.tab.TabBar
   * @eventType onChange
   */
  public static const CHANGE:String = "onChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["tabBar", "tab", "card", "eOpts"];

  public function TabBar_tab_cardEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The card that was just shown in the TabPanel
   */
  public native function get card():Component;

  /**
   * The new Tab
   */
  public native function get tab():Tab;

  /**
   * The TabBar
   */
  public native function get tabBar():TabBar;
}
}