package ext.tip {

[Native("Ext.tip.QuickTip", require)]
/**
 * A specialized tooltip class for tooltips that can be specified in markup and automatically
 * managed by the global →<code>ext.tip.QuickTipManager</code> instance. See the QuickTipManager
 * documentation for additional usage details and examples.
 * <p><b>Example:</b></p>
 * <pre>
 *  Ext.tip.QuickTipManager.init(); // Instantiate the QuickTipManager
 *
 *  Ext.create('Ext.Button', {
 *
 *      renderTo: Ext.getBody(),
 *      text: 'My Button',
 *      listeners: {
 *
 *          afterrender: function(me) {
 *
 *              // Register the new tip with an element's ID
 *              Ext.tip.QuickTipManager.register({
 *                  target: me.getId(), // Target button's ID
 *                  title : 'My Tooltip',  // QuickTip Header
 *                  text  : 'My Button has a QuickTip' // Tip content
 *              });
 *
 *          },
 *          destroy: function(me) {
 *              Ext.tip.QuickTipManager.unregister(me.getId());
 *          }
 *      }
 *  });
 * </pre>
 * @see ext.tip.#QuickTipManager ext.tip.QuickTipManager
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.QuickTip.html Original Ext JS documentation of 'Ext.tip.QuickTip'
 */
public class QuickTip extends ToolTip {
  /**
   * @param config @inheritDoc
   */
  public function QuickTip(config:QuickTip = null) {
    super();
  }

  [ExtConfig]
  /**
   * <code>true</code> to check for nested delegates when using the <code>→delegate</code> option.
   * Having this be <code>false</code> may allow for a small performance improvement.
   * @default true
   * @see #delegate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.QuickTip.html#cfg-checkNestedDelegates Original Ext JS documentation of 'checkNestedDelegates'
   */
  override public native function get checkNestedDelegates():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set checkNestedDelegates(value:Boolean):void;

  [ExtConfig]
  /**
   * -- hidden for Ext.tip.QuickTip - see #cfg-text
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.QuickTip.html#cfg-html Original Ext JS documentation of 'html'
   * @see #setHtml()
   */
  override public native function get html():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set html(value:*):void;

  [ExtConfig]
  /**
   * <code>true</code> to automatically use the element's DOM title value if available.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.QuickTip.html#cfg-interceptTitles Original Ext JS documentation of 'interceptTitles'
   */
  public native function get interceptTitles():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set interceptTitles(value:Boolean):void;

  [ExtConfig]
  /**
   * Allows for this panel to include the →<code>dockedItems</code> when trying to determine
   * the overall size of the panel. This option is only applicable when this panel is
   * also shrink wrapping in the same dimensions. See →<code>ext.panel.Panel.shrinkWrap</code> for
   * an explanation of the configuration options.
   * @default true
   * @see #dockedItems
   * @see ext.panel.Panel#shrinkWrap
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.QuickTip.html#cfg-shrinkWrapDock Original Ext JS documentation of 'shrinkWrapDock'
   */
  override public native function get shrinkWrapDock():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set shrinkWrapDock(value:*):void;

  [ExtConfig]
  /**
   * The target HTMLElement, →<code>ext.dom.Element</code> or id to associate with this Quicktip.
   * <p>Defaults to the document.</p>
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.QuickTip.html#cfg-target Original Ext JS documentation of 'target'
   * @see #setTarget()
   */
  override public native function get target():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set target(value:*):void;

  [ExtConfig]
  /**
   * An HTML fragment, or a →<code>ext.dom.DomHelper</code> specification to use as the layout
   * element content. The HTML content is added after the component is rendered, so the document
   * will not contain this HTML at the time the →<code>event:onRender</code> event is fired. This content
   * is inserted into the body <i>before</i> any configured →<code>contentEl</code> is appended.
   * @default null
   * @see ext.dom.#DomHelper ext.dom.DomHelper
   * @see #event:onRender
   * @see #contentEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.QuickTip.html#cfg-text Original Ext JS documentation of 'text'
   */
  public native function get text():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set text(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The title text to be used to display in the Tip header. May be a string
   * (including HTML tags) or an →<code>ext.panel.PanelTitle</code> config object.
   * @default '&amp;160;'
   * @see ext.panel.PanelTitle
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.QuickTip.html#cfg-title Original Ext JS documentation of 'title'
   * @see #getTitle()
   * @see #setTitle()
   */
  override public native function get title():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set title(value:*):void;

  /**
   * Hides a visible tip or cancels an impending show for a particular element.
   * @param el The element that is the target of
   * the tip or ID of the element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.QuickTip.html#method-cancelShow Original Ext JS documentation of 'cancelShow'
   */
  public native function cancelShow(el:*):void;

  /**
   * Configures a new quick tip instance and assigns it to a target element.
   * <p>For example usage, see the →<code>ext.tip.QuickTipManager</code> class header.</p>
   * @param config The config object with the following properties:
   * <ul>
   * <li><code>target</code> —
   * The target HTMLElement, →<code>ext.dom.Element</code> or
   * id to associate with this Quicktip. See →<code>ext.tip.QuickTip.target</code>.
   * </li>
   * <li><code>text</code> (optional) —
   * Tip body content. See →<code>ext.tip.QuickTip.text</code>.
   * </li>
   * <li><code>title</code> (optional) —
   * Tip header. See →<code>ext.tip.QuickTip.title</code>.
   * </li>
   * <li><code>autoHide</code> (optional) —
   * False to prevent the tip from automatically hiding on
   * mouseleave. See →<code>ext.tip.QuickTip.autoHide</code>.
   * </li>
   * <li><code>cls</code> (optional) —
   * An optional extra CSS class that will be added to the tip. See
   * →<code>ext.tip.QuickTip.cls</code>.
   * </li>
   * <li><code>dismissDelay</code> (optional) —
   * Delay in milliseconds before the tooltip automatically
   * hides (overrides singleton value). See →<code>ext.tip.QuickTip.dismissDelay</code>.
   * </li>
   * <li><code>width</code> (optional) —
   * Tip width in pixels. See →<code>ext.tip.QuickTip.width</code>.
   * </li>
   * </ul>
   * @see ext.tip.#QuickTipManager ext.tip.QuickTipManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.QuickTip.html#method-register Original Ext JS documentation of 'register'
   * @see ext.dom.Element
   * @see ext.tip.QuickTip#target
   * @see ext.tip.QuickTip#text
   * @see ext.tip.QuickTip#title
   * @see ext.tip.QuickTip#autoHide
   * @see ext.tip.QuickTip#cls
   * @see ext.tip.QuickTip#dismissDelay
   * @see ext.tip.QuickTip#width
   */
  public native function register(config:Object):void;

  /**
   * Removes this quick tip from its element and destroys it.
   * @param el The element from which the quick tip
   * is to be removed or ID of the element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.QuickTip.html#method-unregister Original Ext JS documentation of 'unregister'
   */
  public native function unregister(el:*):void;
}
}