package ext.tip {

[Native("Ext.tip.QuickTipManager", require)]
/**
 * Provides attractive and customizable tooltips for any element. The QuickTips
 * singleton is used to configure and manage tooltips globally for multiple elements
 * in a generic manner. To create individual tooltips with maximum customizability,
 * you should consider either →<code>ext.tip.Tip</code> or →<code>ext.tip.ToolTip</code>.
 * <p>Quicktips can be configured via tag attributes directly in markup, or by
 * registering quick tips programmatically via the →<code>register()</code> method.</p>
 * <p>The singleton's instance of →<code>ext.tip.QuickTip</code> is available via
 * →<code>getQuickTip()</code>, and supports all the methods and configuration properties
 * of Ext.tip.QuickTip. These settings will apply to all tooltips shown by the
 * singleton.</p>
 * <p>Below is the summary of the configuration properties which can be used.
 * For detailed descriptions see the config options for the
 * →<code>ext.tip.QuickTip</code> class</p>
 * <p><b><i>QuickTips singleton configs (all are optional)</i></b></p>
 * <ul>
 * <li><code>dismissDelay</code></li>
 * <li><code>hideDelay</code></li>
 * <li><code>maxWidth</code></li>
 * <li><code>minWidth</code></li>
 * <li><code>showDelay</code></li>
 * <li><code>trackMouse</code></li>
 * </ul>
 * <p><b><i>Target element configs (optional unless otherwise noted)</i></b></p>
 * <ul>
 * <li><code>autoHide</code></li>
 * <li><code>cls</code></li>
 * <li><code>dismissDelay</code> (overrides singleton value)</li>
 * <li><code>target</code> (required)</li>
 * <li><code>text</code> (required)</li>
 * <li><code>title</code></li>
 * <li><code>width</code></li>
 * </ul>
 * <p>Here is an example showing how some of these config options could be used:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * // Init the singleton.  Any tag-based quick tips will start working.
 * Ext.tip.QuickTipManager.init();
 *
 * // Apply a set of config properties to the singleton
 * Ext.apply(Ext.tip.QuickTipManager.getQuickTip(), {
 *     maxWidth: 200,
 *     minWidth: 100,
 *     showDelay: 50      // Show 50ms after entering target
 * });
 *
 * // Create a small panel to add a quick tip to
 * Ext.create('Ext.container.Container', {
 *     id: 'quickTipContainer',
 *     width: 200,
 *     height: 150,
 *     style: {
 *         backgroundColor:'#000000'
 *     },
 *     renderTo: Ext.getBody()
 * });
 *
 *
 * // Manually register a quick tip for a specific element
 * Ext.tip.QuickTipManager.register({
 *     target: 'quickTipContainer',
 *     title: 'My Tooltip',
 *     text: 'This tooltip was added in code',
 *     width: 100,
 *     dismissDelay: 10000 // Hide after 10 seconds hover
 * });
 * </pre>
 * <p>To register a quick tip in markup, you simply add one or more of the valid QuickTip
 * attributes prefixed with the <b>data-</b> namespace. The HTML element itself is
 * automatically set as the quick tip target. Here is the summary of supported attributes
 * (optional unless otherwise noted):</p>
 * <ul>
 * <li><code>hide</code>: Specifying "user" is equivalent to setting autoHide = false.
 * Any other value will be the same as autoHide = true.</li>
 * <li><code>qclass</code>: A CSS class to be applied to the quick tip
 * (equivalent to the 'cls' target element config).</li>
 * <li><code>qtip (required)</code>: The quick tip text (equivalent to the 'text' target element config).</li>
 * <li><code>qtitle</code>: The quick tip title (equivalent to the 'title' target element config).</li>
 * <li><code>qwidth</code>: The quick tip width (equivalent to the 'width' target element config).</li>
 * </ul>
 * <p>Here is an example of configuring an HTML element to display a tooltip from markup:</p>
 * <pre>
 * // Add a quick tip to an HTML button
 * &lt;input type="button" value="OK" data-qtitle="OK Button" data-qwidth="100"
 *      data-qtip="This is a quick tip from markup!"&gt;&lt;/input&gt;
 * </pre>
 * @see ext.tip.Tip
 * @see ext.tip.ToolTip
 * @see SQuickTipManager#register()
 * @see ext.tip.QuickTip
 * @see SQuickTipManager#getQuickTip()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.QuickTipManager.html Original Ext JS documentation of 'Ext.tip.QuickTipManager'
 */
public const QuickTipManager:SQuickTipManager = new SQuickTipManager;
}