package ext.tip {
import ext.panel.Panel;

[Native("Ext.tip.Tip", require)]
/**
 * This is the base class for →<code>ext.tip.QuickTip</code> and →<code>ext.tip.ToolTip</code> that provides
 * the basic layout and positioning that all tip-based classes require. This class can be used
 * directly for simple, statically-positioned tips that are displayed programmatically,
 * or it can be extended to provide custom tip implementations.
 * @see ext.tip.QuickTip
 * @see ext.tip.ToolTip
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.Tip.html Original Ext JS documentation of 'Ext.tip.Tip'
 */
public class Tip extends Panel {
  /**
   * @param config @inheritDoc
   */
  public function Tip(config:Tip = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * True to render a close tool button into the tooltip header.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.Tip.html#cfg-closable Original Ext JS documentation of 'closable'
   * @see #getClosable()
   * @see #setClosable()
   */
  override public native function get closable():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set closable(value:Boolean):void;

  [ExtConfig]
  /**
   * The action to take when the close header tool is clicked...
   * <ul>
   * <li>
   * <p><b>→<code>destroy()</code></b> : →<code>remove()</code> the window from the DOM and
   * →<code>ext.Component.destroy()</code> it and all descendant Components. The
   * window will <b>not</b> be available to be redisplayed via the →<code>show()</code> method.</p>
   * </li>
   * <li>
   * <p><b>→<code>hide()</code></b> : <b>Default.</b> →<code>hide()</code> the window by setting
   * isibility to hidden and applying negative offsets. The window will be available to be
   * redisplayed via the →<code>show()</code> method.</p>
   * </li>
   * </ul>
   * <p><b>Note:</b> This behavior has changed! setting <i>does</i> affect the →<code>close()</code> method
   * which will invoke the approriate closeAction.</p>
   * @default 'hide'
   * @see #destroy()
   * @see #remove()
   * @see ext.Component#destroy()
   * @see #show()
   * @see #hide()
   * @see #close()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.Tip.html#cfg-closeAction Original Ext JS documentation of 'closeAction'
   */
  override public native function get closeAction():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set closeAction(value:String):void;

  [ExtConfig]
  /**
   * If <code>true</code>, then the tooltip will be automatically constrained to stay within
   * the browser viewport.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.Tip.html#cfg-constrainPosition Original Ext JS documentation of 'constrainPosition'
   */
  public native function get constrainPosition():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set constrainPosition(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum width of the tip in pixels.
   * @default 500
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.Tip.html#cfg-maxWidth Original Ext JS documentation of 'maxWidth'
   * @see #getMaxWidth()
   * @see #setMaxWidth()
   */
  override public native function get maxWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set maxWidth(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum width of the tip in pixels.
   * @default 40
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.Tip.html#cfg-minWidth Original Ext JS documentation of 'minWidth'
   * @see #getMinWidth()
   * @see #setMinWidth()
   */
  override public native function get minWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set minWidth(value:Number):void;

  [ExtConfig]
  /**
   * <code>true</code> or "sides" for the default effect, "frame" for 4-way shadow, and "drop"
   * for bottom-right shadow.
   * @default "sides"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.Tip.html#cfg-shadow Original Ext JS documentation of 'shadow'
   */
  override public native function get shadow():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set shadow(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * Width in pixels of the tip. Width will be ignored if it
   * exceeds the bounds of →<code>minWidth</code> or →<code>maxWidth</code>.
   * @default 'auto'
   * @see #minWidth
   * @see #maxWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.Tip.html#cfg-width Original Ext JS documentation of 'width'
   * @see #getWidth()
   * @see #setWidth()
   */
  override public native function get width():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set width(value:*):void;

  /**
   * Returns the value of <code>closable</code>.
   * @see #closable
   */
  override public native function getClosable():Boolean;

  /**
   * Returns the value of <code>maxWidth</code>.
   * @see #maxWidth
   */
  override public native function getMaxWidth():Number;

  /**
   * Returns the value of <code>minWidth</code>.
   * @see #minWidth
   */
  override public native function getMinWidth():Number;

  /**
   * Sets the value of <code>closable</code>.
   * @param closable The new value.
   * @see #closable
   */
  override public native function setClosable(closable:Boolean):void;

  /**
   * Sets the value of <code>maxWidth</code>.
   * @param maxWidth The new value.
   * @see #maxWidth
   */
  override public native function setMaxWidth(maxWidth:Number):void;

  /**
   * Sets the value of <code>minWidth</code>.
   * @param minWidth The new value.
   * @see #minWidth
   */
  override public native function setMinWidth(minWidth:Number):void;

  /**
   * Shows this tip at the specified XY position. Example usage:
   * <pre>
   * // Show the tip at x:50 and y:100
   * tip.showAt([50,100]);
   * </pre>
   * @param x The new x position or array of <code>[x,y]</code>.
   * @param y The new y position
   * @param animate True to animate the Component into its new position.
   * You may also pass an animation configuration.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.Tip.html#method-showAt Original Ext JS documentation of 'showAt'
   */
  override public native function showAt(x:Array, y:Number = NaN, animate:* = undefined):void;
}
}