package ext.tip {
import js.HTMLElement;

[Native("Ext.tip.ToolTip", require)]
/**
 * ToolTip is a →<code>ext.tip.Tip</code> implementation that handles the common case of displaying a
 * tooltip when hovering over a certain element or elements on the page. It allows fine-grained
 * control over the tooltip's alignment relative to the target element or mouse, and the timing
 * of when it is automatically shown and hidden.
 * <p>This implementation does <b>not</b> have a built-in method of automatically populating the tooltip's
 * text based on the target element; you must either configure a fixed →<code>html</code> value for each
 * ToolTip instance, or implement custom logic (e.g. in a →<code>event:onBeforeShow</code> event listener) to
 * generate the appropriate tooltip content on the fly. See →<code>ext.tip.QuickTip</code> for a more
 * convenient way of automatically populating and configuring a tooltip based on specific DOM
 * attributes of each target element.</p>
 * <p><b>Basic Example</b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.getBody().appendChild({
 *     id: 'clearButton',
 *     html: 'Clear Button',
 *     style: 'display:inline-block;background:#A2C841;padding:7px;cursor:pointer;'
 * });
 *
 * var tip = Ext.create('Ext.tip.ToolTip', {
 *     target: 'clearButton',
 *     html: 'Press this button to clear the form'
 * });
 * </pre>
 * <p><b>Delegation</b></p>
 * <p>In addition to attaching a ToolTip to a single element, you can also use delegation to attach
 * one ToolTip to many elements under a common parent. This is more efficient than creating many
 * ToolTip instances. To do this, point the →<code>target</code> config to a common ancestor of all the
 * elements, and then set the →<code>delegate</code> config to a CSS selector that will select all the
 * appropriate sub-elements.</p>
 * <p>When using delegation, it is likely that you will want to programmatically change the content
 * of the ToolTip based on each delegate element; you can do this by implementing a custom
 * listener for the →<code>event:onBeforeShow</code> event. Example:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var store = Ext.create('Ext.data.ArrayStore', {
 *     fields: ['company', 'price', 'change'],
 *     data: [
 *         ['3m Co',                               71.72, 0.02],
 *         ['Alcoa Inc',                           29.01, 0.42],
 *         ['Altria Group Inc',                    83.81, 0.28],
 *         ['American Express Company',            52.55, 0.01],
 *         ['American International Group, Inc.',  64.13, 0.31],
 *         ['AT&amp;T Inc.',                           31.61, -0.48]
 *     ]
 * });
 *
 * var grid = Ext.create('Ext.grid.Panel', {
 *     title: 'Array Grid',
 *     store: store,
 *     columns: [
 *         {text: 'Company', flex: 1, dataIndex: 'company'},
 *         {text: 'Price', width: 75, dataIndex: 'price'},
 *         {text: 'Change', width: 75, dataIndex: 'change'}
 *     ],
 *     height: 200,
 *     width: 400,
 *     renderTo: Ext.getBody()
 * });
 *
 * var view = grid.getView();
 * var tip = Ext.create('Ext.tip.ToolTip', {
 *     // The overall target element.
 *     target: view.el,
 *     // Each grid row causes its own separate show and hide.
 *     delegate: view.itemSelector,
 *     // Moving within the row should not hide the tip.
 *     trackMouse: true,
 *     // Render immediately so that tip.body can be referenced prior to the first show.
 *     renderTo: Ext.getBody(),
 *     listeners: {
 *         // Change content dynamically depending on which element triggered the show.
 *         beforeshow: function updateTipBody(tip) {
 *             tip.update('Over company "' + view.getRecord(tip.triggerElement).get('company') +
 *                        '"');
 *         }
 *     }
 * });
 * </pre>
 * <p><b>Alignment</b></p>
 * <p>The following configuration properties allow control over how the ToolTip is aligned relative to
 * the target element and/or mouse pointer:</p>
 * <ul>
 * <li>→<code>anchor</code></li>
 * <li>→<code>anchorToTarget</code></li>
 * <li>→<code>trackMouse</code></li>
 * <li>→<code>mouseOffset</code></li>
 * </ul>
 * <p><b>Showing/Hiding</b></p>
 * <p>The following configuration properties allow control over how and when the ToolTip
 * is automatically shown and hidden:</p>
 * <ul>
 * <li>→<code>autoHide</code></li>
 * <li>→<code>showDelay</code></li>
 * <li>→<code>hideDelay</code></li>
 * <li>→<code>dismissDelay</code></li>
 * </ul>
 * @see ext.tip.Tip
 * @see #html
 * @see #event:onBeforeShow
 * @see ext.tip.QuickTip
 * @see #target
 * @see #delegate
 * @see #anchor
 * @see #anchorToTarget
 * @see #trackMouse
 * @see #mouseOffset
 * @see #autoHide
 * @see #showDelay
 * @see #hideDelay
 * @see #dismissDelay
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html Original Ext JS documentation of 'Ext.tip.ToolTip'
 */
public class ToolTip extends Tip {
  /**
   * @param config @inheritDoc
   */
  public function ToolTip(config:ToolTip = null) {
    super();
  }

  [ExtConfig]
  /**
   * If specified, indicates that the tip should be anchored to a
   * particular side of the target element or mouse pointer ("top", "right", "bottom",
   * or "left"), with an arrow pointing back at the target or mouse pointer. If
   * →<code>constrainPosition</code> is enabled, this will be used as a preferred value
   * only and may be flipped as needed.
   * @see #constrainPosition
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-anchor Original Ext JS documentation of 'anchor'
   */
  override public native function get anchor():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set anchor(value:String):void;

  [ExtConfig]
  /**
   * True to anchor the tooltip to the target element, false to anchor it relative to the mouse
   * coordinates. When <code>→anchorToTarget</code> is true, use <code>→defaultAlign</code> to control tooltip
   * alignment to the target element. When <code>→anchorToTarget</code> is false, use <code>→anchor</code>
   * instead to control alignment.
   * @default true
   * @see #anchorToTarget
   * @see #defaultAlign
   * @see #anchor
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-anchorToTarget Original Ext JS documentation of 'anchorToTarget'
   */
  public native function get anchorToTarget():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set anchorToTarget(value:Boolean):void;

  [ExtConfig]
  /**
   * True to automatically hide the tooltip after the
   * mouse exits the target element or after the <code>→dismissDelay</code>
   * has expired if set. If <code>→closable = true</code>
   * a close tool button will be rendered into the tooltip header.
   * @default true
   * @see #dismissDelay
   * @see #closable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-autoHide Original Ext JS documentation of 'autoHide'
   */
  public native function get autoHide():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoHide(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to check for nested delegates when using the <code>→delegate</code> option.
   * Having this be <code>false</code> may allow for a small performance improvement.
   * @default false
   * @see #delegate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-checkNestedDelegates Original Ext JS documentation of 'checkNestedDelegates'
   */
  public native function get checkNestedDelegates():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checkNestedDelegates(value:Boolean):void;

  [ExtConfig]
  /**
   * A string which specifies how this ToolTip is to align with regard to its
   * →<code>currentTarget</code> by means of identifying the point of the tooltip to
   * join to the point of the target.
   * <p>By default, the tooltip shows at →<code>mouseOffset</code> pixels from the
   * triggering pointer event. Using this config anchors the ToolTip to its target
   * instead.</p>
   * <p>This may take the following forms:</p>
   * <ul>
   * <li><b>Blank</b>: Defaults to aligning the element's top-left corner to the target's
   * bottom-left corner ("tl-bl").</li>
   * <li><b>Two anchors</b>: If two values from the table below are passed separated by a dash,
   * the first value is used as the element's anchor point, and the second value is
   * used as the target's anchor point.</li>
   * <li><b>Two edge/offset descriptors:</b> An edge/offset descriptor is an edge initial
   * (<code>t</code>/<code>r</code>/<code>b</code>/<code>l</code>) followed by a percentage along that side. This describes a
   * point to align with a similar point in the target. So <code>'t0-b0'</code> would be
   * the same as <code>'tl-bl'</code>, <code>'l0-r50'</code> would place the top left corner of this item
   * halfway down the right edge of the target item. This allows more flexibility
   * and also describes which two edges are considered adjacent when positioning a tip pointer.</li>
   * </ul>
   * <p>Following are all of the supported predefined anchor positions:</p>
   * <pre>
   *  Value  Description
   *  -----  -----------------------------
   *  tl     The top left corner
   *  t      The center of the top edge
   *  tr     The top right corner
   *  l      The center of the left edge
   *  c      The center
   *  r      The center of the right edge
   *  bl     The bottom left corner
   *  b      The center of the bottom edge
   *  br     The bottom right corner
   * </pre>
   * <p>You can put a '?' at the end of the alignment string to constrain the positioned element
   * to the →<code>ext.container.Viewport</code>. The element will attempt to align as specified,
   * but the position will be adjusted to constrain to the viewport if necessary. Note that
   * the element being aligned might be swapped to align to a different position than that
   * specified in order to enforce the viewport constraints.</p>
   * <p>Example Usage:</p>
   * <pre>
   * // align the top left corner of the tooltip with the top right corner of its target.
   * defaultAlign: 'tl-tr'
   *
   * // align the bottom right corner of the tooltip with the center left edge of its target.
   * defaultAlign: 'br-l'
   *
   * // align the top center of the tooltip with the bottom left corner of its target.
   * defaultAlign: 't-bl'
   *
   * // align the 25% point on the bottom edge of this tooltip
   * // with the 75% point on the top edge of its target.
   * defaultAlign: 'b25-t75'
   * </pre>
   * @default 'bl-tl'
   * @see #currentTarget
   * @see #mouseOffset
   * @see ext.container.Viewport
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-defaultAlign Original Ext JS documentation of 'defaultAlign'
   */
  override public native function get defaultAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set defaultAlign(value:String):void;

  [ExtConfig]
  /**
   * A →<code>ext.dom.DomQuery</code> simple selector which allows selection of individual elements
   * within the <code>→target</code> element to trigger showing and hiding the ToolTip as the mouse
   * moves within the target. See →<code>ext.dom.DomQuery</code> for information about simple selectors.
   * <p>When specified, the child element of the target which caused a show event is placed into the
   * <code>→triggerElement</code> property before the ToolTip is shown.</p>
   * <p>This may be useful when a Component has regular, repeating elements in it, each of which need
   * a ToolTip which contains information specific to that element.</p>
   * <p>See the delegate example in class documentation of →<code>ext.tip.ToolTip</code>.</p>
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   * @see #target
   * @see #triggerElement
   * @see ext.tip.ToolTip
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-delegate Original Ext JS documentation of 'delegate'
   */
  public native function get delegate():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set delegate(value:String):void;

  [ExtConfig]
  /**
   * Delay in milliseconds before the tooltip automatically hides. To disable automatic hiding,
   * set dismissDelay = 0.
   * @default 5000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-dismissDelay Original Ext JS documentation of 'dismissDelay'
   */
  public native function get dismissDelay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dismissDelay(value:Number):void;

  [ExtConfig]
  /**
   * The number of milliseconds for the <code>fadeOut</code> animation. Only valid if <code>→hideAction</code>
   * is set to <code>fadeOut</code>.
   * @default 1000
   * @see #hideAction
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-fadeOutDuration Original Ext JS documentation of 'fadeOutDuration'
   */
  public native function get fadeOutDuration():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fadeOutDuration(value:Number):void;

  [ExtConfig]
  /**
   * The method to use to hide the tooltip. Another useful method for this is <code>fadeOut</code>.
   * @default "hide"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-hideAction Original Ext JS documentation of 'hideAction'
   */
  public native function get hideAction():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideAction(value:String):void;

  [ExtConfig]
  /**
   * Delay in milliseconds after the mouse exits the target element but before the tooltip
   * actually hides. Set to 0 for the tooltip to hide immediately.
   * @default 200
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-hideDelay Original Ext JS documentation of 'hideDelay'
   */
  public native function get hideDelay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideDelay(value:Number):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  /**
   * An XY offset from the mouse position where the tooltip should be shown.
   * @default [15, 18]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-mouseOffset Original Ext JS documentation of 'mouseOffset'
   */
  public native function get mouseOffset():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set mouseOffset(value:Array):void;

  [ExtConfig]
  /**
   * Delay in milliseconds before the tooltip displays after the mouse enters the target element.
   * @default 500
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-showDelay Original Ext JS documentation of 'showDelay'
   */
  public native function get showDelay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set showDelay(value:Number):void;

  [ExtConfig]
  /**
   * On touch platforms, if →<code>showOnTap</code> is <code>true</code>, a tap on the target shows the tip.
   * In this case any →<code>showDelay</code> is ignored.
   * <p>This is useful for adding tips on elements which do not have tap listeners. It would
   * not be appropriate for a ToolTip on a →<code>ext.button.Button</code>.</p>
   * @default false
   * @see #showOnTap
   * @see #showDelay
   * @see ext.button.Button
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-showOnTap Original Ext JS documentation of 'showOnTap'
   */
  public native function get showOnTap():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set showOnTap(value:Boolean):void;

  [ExtConfig]
  /**
   * The target element or string id to monitor for mouseover events to trigger
   * showing this ToolTip.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-target Original Ext JS documentation of 'target'
   * @see #setTarget()
   */
  public native function get target():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set target(value:*):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  /**
   * When →<code>anchorToTarget</code> is being used to position this tip relative to its target
   * element, this may be used as an extra XY offset from the target element.
   * @default [0, 0]
   * @see #anchorToTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-targetOffset Original Ext JS documentation of 'targetOffset'
   */
  public native function get targetOffset():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set targetOffset(value:Array):void;

  [ExtConfig]
  /**
   * True to have the tooltip follow the mouse as it moves over the target element.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#cfg-trackMouse Original Ext JS documentation of 'trackMouse'
   */
  public native function get trackMouse():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set trackMouse(value:Boolean):void;

  /**
   * When a ToolTip is configured with the <code>→delegate</code>
   * option to cause selected child elements of the <code>→target</code>
   * Element to each trigger a separate show event, this property is set to
   * the DOM element which triggered the show.
   * @see #delegate
   * @see #target
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#property-triggerElement Original Ext JS documentation of 'triggerElement'
   */
  public native function get triggerElement():HTMLElement;

  /**
   * @private
   */
  public native function set triggerElement(value:HTMLElement):void;

  /**
   * Ensures this tooltip at the current event target XY position.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#method-afterShow Original Ext JS documentation of 'afterShow'
   */
  override protected native function afterShow(animateTarget:* = undefined, callback:Function = null, scope:Object = null):void;

  /**
   * Hides this tooltip if visible.
   * @param animateTarget <b>only valid for
   * →<code>floating</code> Components such as →<code>ext.window.Window</code>s or
   * →<code>ext.tip.ToolTip</code>s, or regular Components which have been configured with
   * <code>floating: true</code>.</b>. The target to which the Component should animate while hiding.
   * @default null
   * @param callback A callback function to call after the Component is hidden.
   * @param scope The scope (<code>this</code> reference) in which the callback is executed.
   * Defaults to this Component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#method-hide Original Ext JS documentation of 'hide'
   * @see #floating
   * @see ext.window.Window
   * @see ext.tip.ToolTip
   */
  override public native function hide(animateTarget:Object = null, callback:Function = null, scope:Object = null):void;

  /**
   * Realign this tooltip to the →<code>target</code>.
   * @since 6.2.1
   * @see #target
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#method-realignToTarget Original Ext JS documentation of 'realignToTarget'
   */
  public native function realignToTarget():void;

  /**
   * Binds this ToolTip to the specified element. The tooltip will be displayed when the mouse
   * moves over the element.
   * @param target The Element, HTMLElement, or
   * ID of an element to bind to
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#method-setTarget Original Ext JS documentation of 'setTarget'
   */
  public native function setTarget(target:*):void;

  /**
   * Shows this ToolTip aligned to the passed Component or element or event according to the
   * →<code>anchor</code> config.
   * @param component The →<code>ext.Component</code> or
   * →<code>ext.dom.Element</code> to show the component by.
   * @param position Alignment position as used by
   * →<code>ext.util.Positionable.getAlignToXY()</code>. Defaults to <code>→defaultAlign</code>.
   * See →<code>alignTo()</code> for possible values.
   * @param offset Alignment offsets as used by
   * →<code>ext.util.Positionable.getAlignToXY()</code>. See →<code>alignTo()</code> for possible values.
   * @see #anchor
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tip.ToolTip.html#method-showBy Original Ext JS documentation of 'showBy'
   * @see ext.Component
   * @see ext.dom.Element
   * @see ext.util.Positionable#getAlignToXY()
   * @see #defaultAlign
   * @see #alignTo()
   */
  override public native function showBy(component:*, position:String = null, offset:Array = null):void;
}
}