package ext.toolbar {
import ext.container.Container;
import ext.data.TreeStore;

[Native("Ext.toolbar.Breadcrumb", require)]
/**
 * @see ext.toolbar.events.Breadcrumb_node_prevNodeEvent.CHANGE
 * @eventType ext.toolbar.events.Breadcrumb_node_prevNodeEvent.CHANGE
 */
[Event(name='onChange', type='ext.toolbar.events.Breadcrumb_node_prevNodeEvent')]
/**
 * @see ext.toolbar.events.Breadcrumb_node_prevNodeEvent.SELECTION_CHANGE
 * @eventType ext.toolbar.events.Breadcrumb_node_prevNodeEvent.SELECTION_CHANGE
 */
[Event(name='onSelectionChange', type='ext.toolbar.events.Breadcrumb_node_prevNodeEvent')]
/**
 * A toolbar that displays hierarchical data from a →<code>ext.data.TreeStore</code>
 * as a trail of breadcrumb buttons. Each button represents a node in the store. A click
 * on a button will "select" that node in the tree. Non-leaf nodes will display their
 * child nodes on a dropdown menu of the corresponding button in the breadcrumb trail,
 * and a click on an item in the menu will trigger selection of the corresponding child
 * node.
 * <p>The selection can be set programmatically using →<code>setSelection()</code>, or retrieved
 * using →<code>getSelection()</code>.</p>
 * @see ext.data.TreeStore
 * @see #setSelection()
 * @see #getSelection()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html Original Ext JS documentation of 'Ext.toolbar.Breadcrumb'
 */
public class Breadcrumb extends Container {
  /**
   * @param config @inheritDoc
   */
  public function Breadcrumb(config:Breadcrumb = null) {
    super();
  }

  [ExtConfig]
  /**
   * The base CSS class to apply to this component's element. This will also be prepended
   * to elements within this component like Panel's body will get a class <code>x-panel-body</code>.
   * This means that if you create a subclass of Panel, and you want it to get all the Panels
   * styling for the element and the body, you leave the <code>→baseCls</code> <code>x-panel</code> and use
   * <code>→componentCls</code> to add specific styling for this component.
   * @default Ext.baseCSSPrefix + 'breadcrumb'
   * @see #baseCls
   * @see #componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Button UI to use for breadcrumb items. Use →<code>extjsBreadcrumbUi</code> to
   * add special styling to the breadcrumb arrows
   * @default 'plain-toolbar'
   * @see #extjsBreadcrumbUi
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html#cfg-buttonUI Original Ext JS documentation of 'buttonUI'
   * @see #getButtonUI()
   * @see #setButtonUI()
   */
  public native function get buttonUI():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set buttonUI(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The name of the field in the data model to display in the navigation items of
   * this breadcrumb toolbar
   * @default 'text'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html#cfg-displayField Original Ext JS documentation of 'displayField'
   * @see #getDisplayField()
   * @see #setDisplayField()
   */
  public native function get displayField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set displayField(value:String):void;

  [ExtConfig]
  /**
   * Enable or disable navigation
   * with arrow keys for this FocusableContainer. This option may be useful
   * with nested FocusableContainers, when only the root container should
   * handle keyboard events.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html#cfg-focusableContainer Original Ext JS documentation of 'focusableContainer'
   */
  override public native function get focusableContainer():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set focusableContainer(value:Boolean):void;

  [ExtConfig]
  /**
   * <b>Important</b>: In order for child items to be correctly sized and
   * positioned, typically a layout manager <b>must</b> be specified through
   * the <code>→layout</code> configuration option.
   * <p>The sizing and positioning of child →<code>items</code> is the responsibility of
   * the Container's layout manager which creates and manages the type of layout
   * you have in mind. For example:</p>
   * <p>If the layout configuration is not explicitly specified for
   * a general purpose container (e.g. Container or Panel) the
   * <i>default layout manager</i> (→<code>ext.layout.container.AutoLayout</code>) will be used
   * which does nothing but render child components sequentially into the
   * Container (no sizing or positioning will be performed in this situation).</p>
   * <p><b>layout</b> may be specified as either as an Object or as a String:</p>
   * <p><b><i>Specify as an Object</i></b></p>
   * <p>Example usage:</p>
   * <pre>
   * layout: {
   *     type: 'vbox',
   *     align: 'left'
   * }
   * </pre>
   * <ul>
   * <li>
   * <p><b>type</b></p>
   * <p>The layout type to be used for this container. If not specified,
   * a default →<code>ext.layout.container.AutoLayout</code> will be created and used.</p>
   * <p>Valid layout <code>type</code> values are listed in →<code>null</code>.</p>
   * </li>
   * <li>
   * <p>Layout specific configuration properties</p>
   * <p>Additional layout specific configuration properties may also be
   * specified. For complete details regarding the valid config options for
   * each layout type, see the layout class corresponding to the <code>type</code>
   * specified.</p>
   * </li>
   * </ul>
   * <p><b><i>Specify as a String</i></b></p>
   * <p>Example usage:</p>
   * <pre>
   * layout: 'vbox'
   * </pre>
   * <ul>
   * <li>
   * <p><b>layout</b></p>
   * <p>The layout <code>type</code> to be used for this container (see →<code>null</code>
   * for list of valid values).</p>
   * <p>Additional layout specific configuration properties. For complete
   * details regarding the valid config options for each layout type, see the
   * layout class corresponding to the <code>→layout</code> specified.</p>
   * </li>
   * </ul>
   * <p><b><i>Configuring the default layout type</i></b></p>
   * <p>If a certain Container class has a default layout (For example a
   * →<code>ext.toolbar.Toolbar</code> with a default <code>Box</code> layout), then to simply configure
   * the default layout, use an object, but without the <code>type</code> property:</p>
   * <pre>
   * xtype: 'toolbar',
   * layout: {
   *     pack: 'center'
   * }
   * </pre>
   * @default {
   *     type: 'hbox',
   *     align: 'middle'
   * }
   * @see #layout
   * @see #items
   * @see ext.layout.container.AutoLayout
   * @see null
   * @see ext.toolbar.Toolbar
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html#cfg-layout Original Ext JS documentation of 'layout'
   * @see #setLayout()
   */
  override public native function get layout():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set layout(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The overflowHandler for this Breadcrumb...
   * <ul>
   * <li><code>null</code> - hidden overflow</li>
   * <li><code>'scroller'</code> to render left/right scroller buttons on either side of the breadcrumb</li>
   * <li><code>'menu'</code> to render the overflowing buttons as items of an overflow menu.</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html#cfg-overflowHandler Original Ext JS documentation of 'overflowHandler'
   * @see #getOverflowHandler()
   * @see #setOverflowHandler()
   */
  public native function get overflowHandler():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set overflowHandler(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default [
   *     'selection'
   * ]
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  override public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set publishes(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The selected node, or <code>"root"</code> to select the root node
   * @default 'root'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html#cfg-selection Original Ext JS documentation of 'selection'
   * @see #getSelection()
   * @see #setSelection()
   */
  public native function get selection():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set selection(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Controls whether or not icons of tree nodes are displayed in the breadcrumb
   * buttons. There are 3 possible values for this config:
   * <ol>
   * <li>
   * <p>unspecified (<code>null</code>) - the default value. In this mode only icons that are
   * specified in the tree data using (→<code>ext.data.NodeInterface.icon</code>
   * or →<code>ext.data.NodeInterface.iconCls</code> will be displayed, but the
   * default "folder" and "leaf" icons will not be displayed.</p>
   * </li>
   * <li>
   * <p><code>true</code> - Icons specified in the tree data will be displayed, and the default
   * "folder" and "leaf" icons will be displayed for nodes that do not specify
   * an <code>icon</code> or <code>iconCls</code>.</p>
   * </li>
   * <li>
   * <p><code>false</code> - No icons will be displayed in the breadcrumb buttons, only text.</p>
   * </li>
   * </ol>
   * @default null
   * @see ext.data.NodeInterface#icon
   * @see ext.data.NodeInterface#iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html#cfg-showIcons Original Ext JS documentation of 'showIcons'
   * @see #getShowIcons()
   * @see #setShowIcons()
   */
  public native function get showIcons():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set showIcons(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Controls whether or not icons of tree nodes are displayed in the breadcrumb
   * menu items. There are 3 possible values for this config:
   * <ol>
   * <li>
   * <p>unspecified (<code>null</code>) - the default value. In this mode only icons that are
   * specified in the tree data using (→<code>ext.data.NodeInterface.icon</code>
   * or →<code>ext.data.NodeInterface.iconCls</code> will be displayed, but the
   * default "folder" and "leaf" icons will not be displayed.</p>
   * </li>
   * <li>
   * <p><code>true</code> - Icons specified in the tree data will be displayed, and the default
   * "folder" and "leaf" icons will be displayed for nodes that do not specify
   * an <code>icon</code> or <code>iconCls</code>.</p>
   * </li>
   * <li>
   * <p><code>false</code> - No icons will be displayed on the breadcrumb menu items, only text.</p>
   * </li>
   * </ol>
   * @default null
   * @see ext.data.NodeInterface#icon
   * @see ext.data.NodeInterface#iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html#cfg-showMenuIcons Original Ext JS documentation of 'showMenuIcons'
   * @see #getShowMenuIcons()
   * @see #setShowMenuIcons()
   */
  public native function get showMenuIcons():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set showMenuIcons(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The TreeStore that this breadcrumb toolbar should use as its data source
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html#cfg-store Original Ext JS documentation of 'store'
   * @see #getStore()
   * @see #setStore()
   */
  public native function get store():TreeStore;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set store(value:TreeStore):void;

  [ExtConfig]
  [Bindable]
  /**
   * This object holds a map of <code>config</code> properties that will update their binding
   * as they are modified. For example, <code>value</code> is a key added by form fields. The
   * form of this config is the same as <code>→publishes</code>.
   * <p>This config is defined so that updaters are not created and added for all
   * bound properties since most cannot be modified by the end-user and hence are
   * not appropriate for two-way binding.</p>
   * @default [
   *     'selection'
   * ]
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html#cfg-twoWayBindable Original Ext JS documentation of 'twoWayBindable'
   * @see #getTwoWayBindable()
   * @see #setTwoWayBindable()
   */
  override public native function get twoWayBindable():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set twoWayBindable(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>false</code> to use regular →<code>ext.button.Button</code>s instead of <i>Split Buttons</i> (→<code>ext.button.SplitButton</code>). When <code>true</code>, a click on the body of a button
   * will navigate to the specified node, and a click on the arrow will show a menu
   * containing the the child nodes. When <code>false</code>, the only mode of navigation is
   * the menu, since a click anywhere on the button will show the menu.
   * @default true
   * @see ext.button.Button
   * @see ext.button.SplitButton
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Breadcrumb.html#cfg-useSplitButtons Original Ext JS documentation of 'useSplitButtons'
   * @see #getUseSplitButtons()
   * @see #setUseSplitButtons()
   */
  public native function get useSplitButtons():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set useSplitButtons(value:Boolean):void;

  /**
   * Returns the value of <code>buttonUI</code>.
   * @see #buttonUI
   */
  public native function getButtonUI():String;

  /**
   * Returns the value of <code>displayField</code>.
   * @see #displayField
   */
  public native function getDisplayField():String;

  /**
   * Returns the value of <code>overflowHandler</code>.
   * @see #overflowHandler
   */
  public native function getOverflowHandler():String;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  override public native function getPublishes():*;

  /**
   * Returns the value of <code>selection</code>.
   * @see #selection
   */
  public native function getSelection():*;

  /**
   * Returns the value of <code>showIcons</code>.
   * @see #showIcons
   */
  public native function getShowIcons():Boolean;

  /**
   * Returns the value of <code>showMenuIcons</code>.
   * @see #showMenuIcons
   */
  public native function getShowMenuIcons():Boolean;

  /**
   * Returns the value of <code>store</code>.
   * @see #store
   */
  public native function getStore():TreeStore;

  /**
   * Returns the value of <code>twoWayBindable</code>.
   * @see #twoWayBindable
   */
  override public native function getTwoWayBindable():*;

  /**
   * Returns the value of <code>useSplitButtons</code>.
   * @see #useSplitButtons
   */
  public native function getUseSplitButtons():Boolean;

  /**
   * Sets the value of <code>buttonUI</code>.
   * @param buttonUI The new value.
   * @see #buttonUI
   */
  public native function setButtonUI(buttonUI:String):void;

  /**
   * Sets the value of <code>displayField</code>.
   * @param displayField The new value.
   * @see #displayField
   */
  public native function setDisplayField(displayField:String):void;

  /**
   * Sets the value of <code>overflowHandler</code>.
   * @param overflowHandler The new value.
   * @see #overflowHandler
   */
  public native function setOverflowHandler(overflowHandler:String):void;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  override public native function setPublishes(publishes:*):void;

  /**
   * Sets the value of <code>selection</code>.
   * @param selection The new value.
   * @see #selection
   */
  public native function setSelection(selection:*):void;

  /**
   * Sets the value of <code>showIcons</code>.
   * @param showIcons The new value.
   * @see #showIcons
   */
  public native function setShowIcons(showIcons:Boolean):void;

  /**
   * Sets the value of <code>showMenuIcons</code>.
   * @param showMenuIcons The new value.
   * @see #showMenuIcons
   */
  public native function setShowMenuIcons(showMenuIcons:Boolean):void;

  /**
   * Sets the value of <code>store</code>.
   * @param store The new value.
   * @see #store
   */
  public native function setStore(store:TreeStore):void;

  /**
   * Sets the value of <code>twoWayBindable</code>.
   * @param twoWayBindable The new value.
   * @see #twoWayBindable
   */
  override public native function setTwoWayBindable(twoWayBindable:*):void;

  /**
   * Sets the value of <code>useSplitButtons</code>.
   * @param useSplitButtons The new value.
   * @see #useSplitButtons
   */
  public native function setUseSplitButtons(useSplitButtons:Boolean):void;
}
}