package ext.toolbar {
import ext.Component;

[Native("Ext.toolbar.Fill", require)]
/**
 * A non-rendering placeholder item which instructs the Toolbar's Layout to begin using
 * the right-justified button container.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.panel.Panel', {
 *      title: 'Toolbar Fill Example',
 *      width: 300,
 *      height: 200,
 *      tbar : [
 *          'Item 1',
 *          { xtype: 'tbfill' },
 *          'Item 2'
 *      ],
 *      renderTo: Ext.getBody()
 *  });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Fill.html Original Ext JS documentation of 'Ext.toolbar.Fill'
 */
public class Fill extends Component {
  /**
   * @param config @inheritDoc
   */
  public function Fill(config:Fill = null) {
    super();
  }

  /**
   * <code>true</code> in this class to identify an object as an instantiated Fill, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Fill.html#property-isFill Original Ext JS documentation of 'isFill'
   */
  public native function get isFill():Boolean;

  /**
   * @private
   */
  public native function set isFill(value:Boolean):void;
}
}