package ext.toolbar {
import ext.Component;

[Native("Ext.toolbar.Item", require)]
/**
 * The base class that other non-interacting Toolbar Item classes should extend in order to
 * get some basic common toolbar item functionality.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Item.html Original Ext JS documentation of 'Ext.toolbar.Item'
 */
public class Item extends Component {
  /**
   * @param config @inheritDoc
   */
  public function Item(config:Item = null) {
    super();
  }

  [ExtConfig]
  /**
   * Text to be used for the menu if the item is overflowed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Item.html#cfg-overflowText Original Ext JS documentation of 'overflowText'
   */
  public native function get overflowText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set overflowText(value:String):void;
}
}