package ext.toolbar {
import ext.data.AbstractStore;
import ext.data.Store;
import ext.util.IStoreHolder;

[Native("Ext.toolbar.Paging", require)]
/**
 * @see ext.toolbar.events.PagingToolbar_pageEvent.BEFORE_CHANGE
 * @eventType ext.toolbar.events.PagingToolbar_pageEvent.BEFORE_CHANGE
 */
[Event(name='onBeforeChange', type='ext.toolbar.events.PagingToolbar_pageEvent')]
/**
 * @see ext.toolbar.events.PagingToolbar_pageDataEvent.CHANGE
 * @eventType ext.toolbar.events.PagingToolbar_pageDataEvent.CHANGE
 */
[Event(name='onChange', type='ext.toolbar.events.PagingToolbar_pageDataEvent')]
/**
 * As the number of records increases, the time required for the browser to render them increases.
 * Paging is used to reduce the amount of data exchanged with the client.
 * Note: if there are more records/rows than can be viewed in the available screen area,
 * vertical scrollbars will be added.
 * <p>Paging is typically handled on the server side (see exception below). The client sends parameters
 * to the server side, which the server needs to interpret and then respond with the appropriate
 * data.</p>
 * <p>Ext.toolbar.Paging is a specialized toolbar that is bound to a →<code>ext.data.Store</code>
 * and provides automatic paging control. This Component →<code>ext.data.Store.load()</code>s
 * blocks of data into the →<code>store</code> by passing parameters used for paging criteria.</p>
 * <p>Note: The →<code>store</code> specified must support paging as defined by <code>→ext.data.Store</code>.
 * In particular, this means that <code>→ext.data.ChainedStore</code> is not supported.</p>
 * <p>Paging Toolbar is typically used as one of the Grid's toolbars:</p>
 * <pre>
 * var itemsPerPage = 2; // set the number of items you want per page
 *
 * Ext.create('Ext.data.Store', {
 *     id: 'simpsonsStore',
 *     autoLoad: false,
 *     fields: ['name', 'email', 'phone'],
 *     pageSize: itemsPerPage, // items per page
 *     proxy: {
 *         type: 'ajax',
 *         // url that will load data with respect to start and limit params
 *         url: 'pagingstore.js',
 *         reader: {
 *             type: 'json',
 *             rootProperty: 'items',
 *             totalProperty: 'total'
 *         }
 *     }
 * });
 *
 * // specify segment of data you want to load using params
 * store.load({
 *     params: {
 *         start: 0,
 *         limit: itemsPerPage
 *     }
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     title: 'Simpsons',
 *     width: 400,
 *     height: 125,
 *     renderTo: Ext.getBody(),
 *
 *     store: 'simpsonsStore',
 *
 *     columns: [{
 *         text: 'Name',
 *         dataIndex: 'name'
 *     }, {
 *         text: 'Email',
 *         dataIndex: 'email',
 *         flex: 1
 *     }, {
 *         text: 'Phone',
 *         dataIndex: 'phone'
 *     }],
 *
 *     bbar: {
 *         xtype: 'pagingtoolbar',
 *         displayInfo: true
 *     }
 * });
 * </pre>
 * <p>To use paging, you need to set a pageSize configuration on the Store, and pass the paging
 * requirements to the server when the store is first loaded.</p>
 * <pre>
 * store.load({
 *     params: {
 *         // specify params for the first page load if using paging
 *         start: 0,
 *         limit: myPageSize,
 *         // other params
 *         foo:   'bar'
 *     }
 * });
 * </pre>
 * <p>If using <i>store's autoLoad</i> (→<code>ext.data.Store.autoLoad</code>) configuration:</p>
 * <pre>
 * var myStore = Ext.create('Ext.data.Store', {
 *     autoLoad: {start: 0, limit: 25},
 *     ...
 * });
 * </pre>
 * <p>The packet sent back from the server would have this form:</p>
 * <pre>
 * {
 *     "success": true,
 *     "results": 2000,
 *     "items": [ // &#42;&#42;&#42;Note:&#42;&#42; this must be an Array
 *         { "id":  1, "name": "Bill", "occupation": "Gardener" },
 *         { "id":  2, "name":  "Ben", "occupation": "Horticulturalist" },
 *         ...
 *         { "id": 25, "name":  "Sue", "occupation": "Botanist" }
 *     ]
 * }
 * </pre>
 * <p><b><i>Paging with Local Data</i></b></p>
 * <p>Paging can also be accomplished with local data using extensions:</p>
 * <ul>
 * <li><a href="http://sencha.com/forum/showthread.php?t=71532">Ext.ux.data.PagingStore</a></li>
 * <li>Paging Memory Proxy (examples/ux/PagingMemoryProxy.js)</li>
 * </ul>
 * @see ext.data.Store
 * @see ext.data.Store#load()
 * @see #store
 * @see ext.data.ChainedStore
 * @see ext.data.Store#autoLoad
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html Original Ext JS documentation of 'Ext.toolbar.Paging'
 */
public class PagingToolbar extends Toolbar implements IStoreHolder {
  /**
   * @param config @inheritDoc
   */
  public function PagingToolbar(config:PagingToolbar = null) {
    super();
  }

  [ExtConfig]
  /**
   * Customizable piece of the default paging text. Note that this string is formatted using
   * {0} as a token that is replaced by the number of total pages. This token should be preserved
   * when overriding this string if showing the total page count is desired.
   * @default 'of {0}'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#cfg-afterPageText Original Ext JS documentation of 'afterPageText'
   */
  public native function get afterPageText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterPageText(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get autoDestroyBoundStore():Boolean;

  /**
   * @inheritDoc
   */
  public native function set autoDestroyBoundStore(value:Boolean):void;

  [ExtConfig]
  /**
   * The text displayed before the input item.
   * @default 'Page'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#cfg-beforePageText Original Ext JS documentation of 'beforePageText'
   */
  public native function get beforePageText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforePageText(value:String):void;

  /**
   * This property is used to determine the property of a <code>→bind</code> config that is just
   * the value. For example, if <code>defaultBindProperty="value"</code>, then this shorthand
   * <code>→bind</code> config:
   * <pre>
   *  bind: '{name}'
   * </pre>
   * <p>Is equivalent to this object form:</p>
   * <pre>
   *  bind: {
   *      value: '{name}'
   *  }
   * </pre>
   * <p>The <code>→defaultBindProperty</code> is set to "value" for form fields and to "store" for
   * grids and trees.</p>
   * @default 'store'
   * @see #bind
   * @see #defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#property-defaultBindProperty Original Ext JS documentation of 'defaultBindProperty'
   */
  override public native function get defaultBindProperty():String;

  /**
   * @private
   */
  override public native function set defaultBindProperty(value:String):void;

  [ExtConfig]
  /**
   * true to display the displayMsg
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#cfg-displayInfo Original Ext JS documentation of 'displayInfo'
   */
  public native function get displayInfo():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set displayInfo(value:Boolean):void;

  [ExtConfig]
  /**
   * The paging status message to display. Note that this string is
   * formatted using the braced numbers {0}-{2} as tokens that are replaced by the values
   * for start, end and total respectively. These tokens should be preserved when overriding
   * this string if showing those values is desired.
   * @default 'Displaying {0} - {1} of {2}'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#cfg-displayMsg Original Ext JS documentation of 'displayMsg'
   */
  public native function get displayMsg():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set displayMsg(value:String):void;

  [ExtConfig]
  /**
   * The message to display when no records are found.
   * @default 'No data to display'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#cfg-emptyMsg Original Ext JS documentation of 'emptyMsg'
   */
  public native function get emptyMsg():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set emptyMsg(value:String):void;

  [ExtConfig]
  /**
   * The quicktip text displayed for the first page button.
   * <b>Note</b>: quick tips must be initialized for the quicktip to show.
   * @default 'First Page'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#cfg-firstText Original Ext JS documentation of 'firstText'
   */
  public native function get firstText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set firstText(value:String):void;

  [ExtConfig]
  /**
   * The width in pixels of the input field used to display and change the current page number.
   * @default 30
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#cfg-inputItemWidth Original Ext JS documentation of 'inputItemWidth'
   */
  public native function get inputItemWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set inputItemWidth(value:Number):void;

  [ExtConfig]
  /**
   * The quicktip text displayed for the last page button.
   * <b>Note</b>: quick tips must be initialized for the quicktip to show.
   * @default 'Last Page'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#cfg-lastText Original Ext JS documentation of 'lastText'
   */
  public native function get lastText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lastText(value:String):void;

  [ExtConfig]
  /**
   * The quicktip text displayed for the next page button.
   * <b>Note</b>: quick tips must be initialized for the quicktip to show.
   * @default 'Next Page'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#cfg-nextText Original Ext JS documentation of 'nextText'
   */
  public native function get nextText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nextText(value:String):void;

  [ExtConfig]
  /**
   * true to insert any configured items <i>before</i> the paging buttons.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#cfg-prependButtons Original Ext JS documentation of 'prependButtons'
   */
  public native function get prependButtons():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set prependButtons(value:Boolean):void;

  [ExtConfig]
  /**
   * The quicktip text displayed for the previous page button.
   * <b>Note</b>: quick tips must be initialized for the quicktip to show.
   * @default 'Previous Page'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#cfg-prevText Original Ext JS documentation of 'prevText'
   */
  public native function get prevText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set prevText(value:String):void;

  [ExtConfig]
  /**
   * The quicktip text displayed for the Refresh button.
   * <b>Note</b>: quick tips must be initialized for the quicktip to show.
   * @default 'Refresh'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#cfg-refreshText Original Ext JS documentation of 'refreshText'
   */
  public native function get refreshText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set refreshText(value:String):void;

  [ExtConfig]
  /**
   * The data source to which the paging toolbar is bound (must be the same store instance
   * used in the grid / tree). Acceptable values for this property are:
   * <ul>
   * <li>Any →<code>ext.data.Store</code> class or subclass</li>
   * <li>An <i>ID of a store</i> (→<code>ext.data.Store.storeId</code>)</li>
   * </ul>
   * <p>If no <code>→store</code> is provided, the <code>→store</code> of the owner component (if there is an
   * owner and it has a store) is used. The owner store is bound when this component
   * is rendered.</p>
   * @see ext.data.Store
   * @see ext.data.Store#storeId
   * @see #store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#cfg-store Original Ext JS documentation of 'store'
   * @see #setStore()
   */
  public native function get store():Store;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set store(value:*):void;

  /**
   * @inheritDoc
   */
  public native function bindStore(store:Store = undefined, initial:Boolean = undefined, propertyName:* = undefined):void;

  /**
   * Binds listeners for this component to the store. By default it will add
   * anything bound by the getStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to bind to
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-bindStoreListeners Original Ext JS documentation of 'bindStoreListeners'
   */
  protected native function bindStoreListeners(store:AbstractStore):void;

  /**
   * Refresh the current page, has the same effect as clicking the 'refresh' button.
   * Fires the →<code>event:onBeforeChange</code> event. If the event returns <code>false</code>, then
   * the load will not be attempted.
   * @return <code>true</code> if the load was passed to the store.
   * @see #event:onBeforeChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#method-doRefresh Original Ext JS documentation of 'doRefresh'
   */
  public native function doRefresh():Boolean;

  /**
   * @inheritDoc
   */
  public native function getStore():AbstractStore;

  /**
   * Gets the listeners to bind to a new store.
   * @param store The Store which is being bound to for which a listeners object
   * should be returned.
   * @return The listeners to be bound to the store in object literal form. The scope
   * may be omitted, it is assumed to be the current instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-getStoreListeners Original Ext JS documentation of 'getStoreListeners'
   */
  protected native function getStoreListeners(store:Store):Object;

  /**
   * Move to the first page, has the same effect as clicking the 'first' button.
   * Fires the →<code>event:onBeforeChange</code> event. If the event returns <code>false</code>, then
   * the load will not be attempted.
   * @return <code>true</code> if the load was passed to the store.
   * @see #event:onBeforeChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#method-moveFirst Original Ext JS documentation of 'moveFirst'
   */
  public native function moveFirst():Boolean;

  /**
   * Move to the last page, has the same effect as clicking the 'last' button.
   * Fires the →<code>event:onBeforeChange</code> event. If the event returns <code>false</code>, then
   * the load will not be attempted.
   * @return <code>true</code> if the load was passed to the store.
   * @see #event:onBeforeChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#method-moveLast Original Ext JS documentation of 'moveLast'
   */
  public native function moveLast():Boolean;

  /**
   * Move to the next page, has the same effect as clicking the 'next' button.
   * Fires the →<code>event:onBeforeChange</code> event. If the event returns <code>false</code>, then
   * the load will not be attempted.
   * @return <code>true</code> if the load was passed to the store.
   * @see #event:onBeforeChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#method-moveNext Original Ext JS documentation of 'moveNext'
   */
  public native function moveNext():Boolean;

  /**
   * Move to the previous page, has the same effect as clicking the 'previous' button.
   * Fires the →<code>event:onBeforeChange</code> event. If the event returns <code>false</code>, then
   * the load will not be attempted.
   * @return <code>true</code> if the load was passed to the store.
   * @see #event:onBeforeChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Paging.html#method-movePrevious Original Ext JS documentation of 'movePrevious'
   */
  public native function movePrevious():Boolean;

  /**
   * Template method, it is called when a new store is bound
   * to the current instance.
   * @param store The store being bound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onBindStore Original Ext JS documentation of 'onBindStore'
   */
  protected native function onBindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * Template method, it is called when an existing store is unbound
   * from the current instance.
   * @param store The store being unbound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onUnbindStore Original Ext JS documentation of 'onUnbindStore'
   */
  protected native function onUnbindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function setStore(store:Object):void;

  /**
   * Unbinds listeners from this component to the store. By default it will remove
   * anything bound by the bindStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to unbind from
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-unbindStoreListeners Original Ext JS documentation of 'unbindStoreListeners'
   */
  protected native function unbindStoreListeners(store:AbstractStore):void;
}
}