package ext.toolbar {
import ext.Component;

[Native("Ext.toolbar.Spacer", require)]
/**
 * A simple element that adds extra horizontal space between items in a toolbar.
 * By default a 2px wide space is added via CSS specification:
 * <pre>
 * .x-toolbar .x-toolbar-spacer {
 *     width: 2px;
 * }
 * </pre>
 * <p>Example:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.panel.Panel', {
 *     title: 'Toolbar Spacer Example',
 *     width: 300,
 *     height: 200,
 *     tbar : [
 *         'Item 1',
 *         { xtype: 'tbspacer' }, // or ' '
 *         'Item 2',
 *         // space width is also configurable via javascript
 *         { xtype: 'tbspacer', width: 50 }, // add a 50px space
 *         'Item 3'
 *     ],
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Spacer.html Original Ext JS documentation of 'Ext.toolbar.Spacer'
 */
public class Spacer extends Component {
  /**
   * @param config @inheritDoc
   */
  public function Spacer(config:Spacer = null) {
    super();
  }
}
}