package ext.toolbar {

[Native("Ext.toolbar.TextItem", require)]
/**
 * A simple class that renders text directly into a toolbar.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.panel.Panel', {
 *     title: 'Panel with TextItem',
 *     width: 300,
 *     height: 200,
 *     tbar: [
 *         { xtype: 'tbtext', html: 'Sample Text Item' }
 *     ],
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.TextItem.html Original Ext JS documentation of 'Ext.toolbar.TextItem'
 */
public class TextItem extends Item {
  /**
   * @param config @inheritDoc
   */
  public function TextItem(config:TextItem = null) {
    super();
  }

  [Deprecated(replacement="html", since="5.1.0")]
  [ExtConfig]
  /**
   * The text to be used as innerHTML (html tags are accepted).
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.TextItem.html#cfg-text Original Ext JS documentation of 'text'
   * @see #setText()
   */
  public native function get text():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set text(value:String):void;

  [Deprecated(replacement="update", since="5.1.0")]
  /**
   * Updates this item's text, setting the text to be used as innerHTML.
   * @param text The text to display (html accepted).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.TextItem.html#method-setText Original Ext JS documentation of 'setText'
   */
  public native function setText(text:String):void;
}
}