package ext.toolbar {
import ext.container.Container;

[Native("Ext.toolbar.Toolbar", require)]
/**
 * @see ext.toolbar.events.Toolbar_lastHiddenCount_hiddenCount_hiddenItemsEvent.OVERFLOW_CHANGE
 * @eventType ext.toolbar.events.Toolbar_lastHiddenCount_hiddenCount_hiddenItemsEvent.OVERFLOW_CHANGE
 */
[Event(name='onOverflowChange', type='ext.toolbar.events.Toolbar_lastHiddenCount_hiddenCount_hiddenItemsEvent')]
/**
 * Basic Toolbar class. Although the →<code>ext.container.Container.defaultType</code> for
 * Toolbar is <i>button</i> (→<code>ext.button.Button</code>), Toolbar elements (child items for the Toolbar container)
 * may be virtually any type of Component. Toolbar elements can be created explicitly via their
 * constructors, or implicitly via their xtypes, and can be →<code>add()</code>ed dynamically.
 * <p><b><i>Some items have shortcut strings for creation:</i></b></p>
 * <table>
 * <thead>
 * <tr><th align="left">Shortcut</th><th align="left">xtype</th><th align="left">Class</th><th align="left">Description</th></tr>
 * </thead>
 * <tbody>
 * <tr><td align="left">'-&gt;'</td><td align="left"><code>tbfill</code></td><td align="left">→<code>ext.toolbar.Fill</code></td><td align="left">begin using the right-justified button container</td></tr>
 * <tr><td align="left">'-'</td><td align="left"><code>tbseparator</code></td><td align="left">→<code>ext.toolbar.Separator</code></td><td align="left">add a vertical separator bar between toolbar items</td></tr>
 * <tr><td align="left">' '</td><td align="left"><code>tbspacer</code></td><td align="left">→<code>ext.toolbar.Spacer</code></td><td align="left">add horizontal space between elements</td></tr>
 * </tbody>
 * </table>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.toolbar.Toolbar', {
 *     renderTo: document.body,
 *     width   : 500,
 *     items: [
 *         {
 *             // xtype: 'button', // default for Toolbars
 *             text: 'Button'
 *         },
 *         {
 *             xtype: 'splitbutton',
 *             text : 'Split Button'
 *         },
 *         // begin using the right-justified button container
 *         '-&gt;', // same as { xtype: 'tbfill' }
 *         {
 *             xtype    : 'textfield',
 *             name     : 'field1',
 *             emptyText: 'enter search term'
 *         },
 *         // add a vertical separator bar between toolbar items
 *         '-', // same as {xtype: 'tbseparator'} to create Ext.toolbar.Separator
 *         'text 1', // same as {xtype: 'tbtext', text: 'text1'} to create Ext.toolbar.TextItem
 *         { xtype: 'tbspacer' },// same as ' ' to create Ext.toolbar.Spacer
 *         'text 2',
 *         { xtype: 'tbspacer', width: 50 }, // add a 50px space
 *         'text 3'
 *     ]
 * });
 * </pre>
 * <p>Toolbars have →<code>enable()</code> and →<code>disable()</code> methods which when called, will
 * enable/disable all items within your toolbar.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.toolbar.Toolbar', {
 *     renderTo: document.body,
 *     width   : 400,
 *     items: [
 *         {
 *             text: 'Button'
 *         },
 *         {
 *             xtype: 'splitbutton',
 *             text : 'Split Button'
 *         },
 *         '-&gt;',
 *         {
 *             xtype    : 'textfield',
 *             name     : 'field1',
 *             emptyText: 'enter search term'
 *         }
 *     ]
 * });
 * </pre>
 * <p>Example</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var enableBtn = Ext.create('Ext.button.Button', {
 *     text    : 'Enable All Items',
 *     disabled: true,
 *     scope   : this,
 *     handler : function() {
 *         //disable the enable button and enable the disable button
 *         enableBtn.disable();
 *         disableBtn.enable();
 *
 *         //enable the toolbar
 *         toolbar.enable();
 *     }
 * });
 *
 * var disableBtn = Ext.create('Ext.button.Button', {
 *     text    : 'Disable All Items',
 *     scope   : this,
 *     handler : function() {
 *         //enable the enable button and disable button
 *         disableBtn.disable();
 *         enableBtn.enable();
 *
 *         //disable the toolbar
 *         toolbar.disable();
 *     }
 * });
 *
 * var toolbar = Ext.create('Ext.toolbar.Toolbar', {
 *     renderTo: document.body,
 *     width   : 400,
 *     margin  : '5 0 0 0',
 *     items   : [enableBtn, disableBtn]
 * });
 * </pre>
 * <p>Adding items to and removing items from a toolbar is as simple as calling the →<code>add()</code>
 * and →<code>remove()</code> methods. There is also a →<code>removeAll()</code> method
 * which remove all items within the toolbar.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var toolbar = Ext.create('Ext.toolbar.Toolbar', {
 *     renderTo: document.body,
 *     width   : 700,
 *     items: [
 *         {
 *             text: 'Example Button'
 *         }
 *     ]
 * });
 *
 * var addedItems = [];
 *
 * Ext.create('Ext.toolbar.Toolbar', {
 *     renderTo: document.body,
 *     width   : 700,
 *     margin  : '5 0 0 0',
 *     items   : [
 *         {
 *             text   : 'Add a button',
 *             scope  : this,
 *             handler: function() {
 *                 var text = prompt('Please enter the text for your button:');
 *                 addedItems.push(toolbar.add({
 *                     text: text
 *                 }));
 *             }
 *         },
 *         {
 *             text   : 'Add a text item',
 *             scope  : this,
 *             handler: function() {
 *                 var text = prompt('Please enter the text for your item:');
 *                 addedItems.push(toolbar.add(text));
 *             }
 *         },
 *         {
 *             text   : 'Add a toolbar separator',
 *             scope  : this,
 *             handler: function() {
 *                 addedItems.push(toolbar.add('-'));
 *             }
 *         },
 *         {
 *             text   : 'Add a toolbar spacer',
 *             scope  : this,
 *             handler: function() {
 *                 addedItems.push(toolbar.add('-&gt;'));
 *             }
 *         },
 *         '-&gt;',
 *         {
 *             text   : 'Remove last inserted item',
 *             scope  : this,
 *             handler: function() {
 *                 if (addedItems.length) {
 *                     toolbar.remove(addedItems.pop());
 *                 } else if (toolbar.items.length) {
 *                     toolbar.remove(toolbar.items.last());
 *                 } else {
 *                     alert('No items in the toolbar');
 *                 }
 *             }
 *         },
 *         {
 *             text   : 'Remove all items',
 *             scope  : this,
 *             handler: function() {
 *                 toolbar.removeAll();
 *             }
 *         }
 *     ]
 * });
 * </pre>
 * @see ext.container.Container#defaultType
 * @see ext.button.Button
 * @see #add()
 * @see ext.toolbar.Fill
 * @see ext.toolbar.Separator
 * @see ext.toolbar.Spacer
 * @see #enable()
 * @see #disable()
 * @see #remove()
 * @see #removeAll()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Toolbar.html Original Ext JS documentation of 'Ext.toolbar.Toolbar'
 */
public class Toolbar extends Container {
  /**
   * Creates a new Toolbar
   * @param config A config object or an array of buttons to →<code>add()</code>
   * eslint-enable max-len
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Toolbar.html#method-constructor Original Ext JS documentation of 'constructor'
   * @see #add()
   */
  public function Toolbar(config:Toolbar = null) {
    super();
  }

  [ExtConfig]
  /**
   * A default →<code>ext.Component.ui</code> to use for →<code>ext.button.Button</code> items. This is a quick and simple
   * way to change the look of all child <i>Buttons</i> (→<code>ext.button.Button</code>).
   * <p>If there is no value for defaultButtonUI, the button's →<code>ext.Component.ui</code> value will get <code>-toolbar</code>
   * appended so the →<code>ext.button.Button</code> has a different look when it's a child of a →<code>ext.toolbar.Toolbar</code>.
   * To prevent this and have the same look as buttons outside of a toolbar, you can provide a string value to the defaultButtonUI:</p>
   * <pre>
   * Ext.create('Ext.panel.Panel', {
   *     renderTo    : document.body,
   *     width       : 300,
   *     title       : 'Panel',
   *     html        : 'Some Body',
   *     dockedItems : [
   *         {
   *             xtype           : 'toolbar',
   *             dock            : 'top',
   *             defaultButtonUI : 'default',
   *             items           : [
   *                 {
   *                     text : 'Save'
   *                 },
   *                 {
   *                     text : 'Remove'
   *                 }
   *             ]
   *         }
   *     ]
   * });
   * </pre>
   * @default 'default-toolbar'
   * @see ext.Component#ui
   * @see ext.button.Button
   * @see ext.toolbar.Toolbar
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Toolbar.html#cfg-defaultButtonUI Original Ext JS documentation of 'defaultButtonUI'
   */
  public native function get defaultButtonUI():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultButtonUI(value:String):void;

  [ExtConfig]
  /**
   * Default UI for form field items.
   * @default 'default'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Toolbar.html#cfg-defaultFieldUI Original Ext JS documentation of 'defaultFieldUI'
   */
  public native function get defaultFieldUI():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultFieldUI(value:String):void;

  [ExtConfig]
  /**
   * Default UI for Buttons if the toolbar has a UI of 'footer'
   * @default 'default'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Toolbar.html#cfg-defaultFooterButtonUI Original Ext JS documentation of 'defaultFooterButtonUI'
   */
  public native function get defaultFooterButtonUI():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultFooterButtonUI(value:String):void;

  [ExtConfig]
  /**
   * Default UI for Form Fields if the toolbar has a UI of 'footer'
   * @default 'default'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Toolbar.html#cfg-defaultFooterFieldUI Original Ext JS documentation of 'defaultFooterFieldUI'
   */
  public native function get defaultFooterFieldUI():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultFooterFieldUI(value:String):void;

  [ExtConfig]
  /**
   * Configure true to make the toolbar provide a button which activates a dropdown Menu to show
   * items which overflow the Toolbar's width. Setting this too true is the equivalent
   * of setting <code>→overflowHandler:'menu'</code>.
   * @default false
   * @see #overflowHandler
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Toolbar.html#cfg-enableOverflow Original Ext JS documentation of 'enableOverflow'
   */
  public native function get enableOverflow():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableOverflow(value:Boolean):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Toolbar, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Toolbar.html#property-isToolbar Original Ext JS documentation of 'isToolbar'
   */
  public native function get isToolbar():Boolean;

  /**
   * @private
   */
  public native function set isToolbar(value:Boolean):void;

  [ExtConfig]
  /**
   * This class assigns a default layout (<code>layout: 'hbox'</code> or <code>layout: 'vbox'</code> depending upon orientation).
   * <p>Developers <i>may</i> override this configuration option if another layout is required.
   * See →<code>ext.container.Container.layout</code> for additional information.</p>
   * @default undefined
   * @see ext.container.Container#layout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Toolbar.html#cfg-layout Original Ext JS documentation of 'layout'
   * @see #setLayout()
   */
  override public native function get layout():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set layout(value:*):void;

  [ExtConfig]
  /**
   * <ul>
   * <li><code>null</code> - hidden overflow</li>
   * <li><code>'scroller'</code> to render left/right scroller buttons on either side of the breadcrumb</li>
   * <li><code>'menu'</code> to render the overflowing buttons as items of an overflow menu.</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Toolbar.html#cfg-overflowHandler Original Ext JS documentation of 'overflowHandler'
   */
  public native function get overflowHandler():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set overflowHandler(value:String):void;

  [ExtConfig]
  /**
   * If <code>true</code>, when a toolbar button has a menu open, then mousing over other
   * toolbar buttons opens their menus.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Toolbar.html#cfg-trackMenus Original Ext JS documentation of 'trackMenus'
   */
  public native function get trackMenus():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set trackMenus(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to <code>true</code> to make the toolbar vertical. The layout will become a <code>vbox</code>.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Toolbar.html#cfg-vertical Original Ext JS documentation of 'vertical'
   */
  public native function get vertical():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set vertical(value:Boolean):void;

  /**
   * Adds element(s) to the toolbar -- this function takes a variable number of
   * arguments of mixed type and adds them to the toolbar.
   * <p><b>Note</b>: See the notes within →<code>ext.container.Container.add()</code>.</p>
   * @param args The following types
   * of arguments are all valid:
   * <ul>
   * <li>
   * <p><code>config (→ext.button.Button)</code>: A valid button config object</p>
   * </li>
   * <li>
   * <p><code>HTMLElement</code>: Any standard HTML element</p>
   * </li>
   * <li>
   * <p><code>Field</code>: Any form field</p>
   * </li>
   * <li>
   * <p><code>Item</code>: Any subclass of →<code>ext.toolbar.Item</code></p>
   * </li>
   * <li>
   * <p><code>→String</code>: Any generic string (gets wrapped in a →<code>ext.toolbar.TextItem</code>).</p>
   * <p>Note that there are a few special strings that are treated differently as explained next:</p>
   * <ul>
   * <li><code>'-'</code>: Creates a separator element</li>
   * <li><code>' '</code>: Creates a spacer element</li>
   * <li><code>'-&gt;'</code>: Creates a fill element</li>
   * </ul>
   * </li>
   * </ul>
   * @return The Components that were added.
   * @see ext.container.Container#add()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.toolbar.Toolbar.html#method-add Original Ext JS documentation of 'add'
   * @see ext.button.Button
   * @see ext.toolbar.Item
   * @see String
   * @see ext.toolbar.TextItem
   */
  override public native function add(...args):*;
}
}