package ext.tree {
import ext.grid.column.Column;

[Native("Ext.tree.Column", require)]
/**
 * Provides indentation and folder structure markup for a Tree taking into account
 * depth and position within the tree hierarchy.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Column.html Original Ext JS documentation of 'Ext.tree.Column'
 */
public class TreeColumn extends Column {
  /**
   * @param config @inheritDoc
   */
  public function TreeColumn(config:TreeColumn = null) {
    super();
  }

  [ExtConfig]
  /**
   * A renderer is an 'interceptor' method which can be used to transform data (value,
   * appearance, etc.) before it is rendered. Note that a <i>tree column</i> renderer yields
   * the <i>text</i> of the node. The lines and icons are produced by configurations. See
   * below for more information.
   * <p><b>NOTE:</b> In previous releases, a string was treated as a method on
   * <code>→ext.util.Format</code> but that is now handled by the →<code>formatter</code> config.</p>
   * <ul>
   * <li><code>value:Object</code> —
   * The data value for the current cell
   * <pre>
   * renderer: function(value){
   *     // evaluates `value` to append either `person' or `people`
   *     return Ext.util.Format.plural(value, 'person', 'people');
   * }
   * </pre>
   * </li>
   * <li><code>metaData:Object</code> —
   * A collection of metadata about the current cell; can be
   * used or modified by the renderer. Recognized properties are: <code>→tdCls</code>, <code>tdAttr</code>,
   * <code>tdStyle</code>, <code>icon</code>, <code>iconCls</code> and <code>glyph</code>.
   * <p>For the standard grid column metaData propertyes see
   * <i>column renderer</i> (→<code>ext.grid.column.Column.renderer</code>)</p>
   * <p>To change the icon used in the node, you can use the glyph metaData property as below.</p>
   * <p>You can see an example of using the metaData parameter below.</p>
   * <pre>
   *  renderer: function(v, metaData, record) {
   *      metaData.glyph = record.glyph;
   *      return v;
   *  }
   * </pre>
   * <p>or</p>
   * <pre>
   *  renderer: function(v, metaData, record) {
   *      metaData.icon = record.icon;
   *      return v;
   *  }
   * </pre>
   * </li>
   * <li><code>record:ext.data.Model</code> —
   * The record for the current row
   * <pre>
   * renderer: function (value, metaData, record) {
   *     // evaluate the record's `updated` field and if truthy return the value
   *     // from the `newVal` field, else return value
   *     var updated = record.get('updated');
   *     return updated ? record.get('newVal') : value;
   * }
   * </pre>
   * </li>
   * <li><code>rowIndex:Number</code> —
   * The index of the current row
   * <pre>
   * renderer: function (value, metaData, record, rowIndex) {
   *     // style the cell differently for even / odd values
   *     var odd = (rowIndex % 2 === 0);
   *     metaData.tdStyle = 'color:' + (odd ? 'gray' : 'red');
   * }
   * </pre>
   * </li>
   * <li><code>colIndex:Number</code> —
   * The index of the current column
   * <pre>
   * var myRenderer = function(value, metaData, record, rowIndex, colIndex) {
   *     if (colIndex === 0) {
   *         metaData.tdAttr = 'data-qtip=' + value;
   *     }
   *     // additional logic to apply to values in all columns
   *     return value;
   * }
   *
   * // using the same renderer on all columns you can process the value for
   * // each column with the same logic and only set a tooltip on the first column
   * renderer: myRenderer
   * </pre>
   * <p><i>See also →<code>ext.tip.QuickTipManager</code></i></p>
   * </li>
   * <li><code>store:ext.data.Store</code> —
   * The data store
   * <pre>
   * renderer: function (value, metaData, record, rowIndex, colIndex, store) {
   *     // style the cell differently depending on how the value relates to the
   *     // average of all values
   *     var average = store.average('grades');
   *     metaData.tdCls = (value &lt; average) ? 'needsImprovement' : 'satisfactory';
   *     return value;
   * }
   * </pre>
   * </li>
   * <li><code>view:ext.view.DataView</code> —
   * The data view
   * <pre>
   * renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
   *     // style the cell using the dataIndex of the column
   *     var headerCt = this.getHeaderContainer(),
   *         column = headerCt.getHeaderAtIndex(colIndex);
   *
   *     metaData.tdCls = 'app-' + column.dataIndex;
   *     return value;
   * }
   * </pre>
   * </li>
   * <li><code>null:String</code> —
   * The HTML string to be rendered into the text portion of the tree node.
   * </li>
   * </ul>
   * @see ext.util.#Format ext.util.Format
   * @see #formatter
   * @see #tdCls
   * @see ext.grid.column.Column#renderer
   * @see ext.tip.#QuickTipManager ext.tip.QuickTipManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Column.html#cfg-renderer Original Ext JS documentation of 'renderer'
   */
  override public native function get renderer():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set renderer(value:*):void;
}
}