package ext.tree {
import ext.data.Model;
import ext.data.TreeModel;
import ext.panel.TablePanel;

[Native("Ext.tree.Panel", require)]
/**
 * @see ext.tree.events.TreePanel_node_index_itemEvent.AFTER_ITEM_COLLAPSE
 * @eventType ext.tree.events.TreePanel_node_index_itemEvent.AFTER_ITEM_COLLAPSE
 */
[Event(name='onAfterItemCollapse', type='ext.tree.events.TreePanel_node_index_itemEvent')]
/**
 * @see ext.tree.events.TreePanel_node_index_itemEvent.AFTER_ITEM_EXPAND
 * @eventType ext.tree.events.TreePanel_node_index_itemEvent.AFTER_ITEM_EXPAND
 */
[Event(name='onAfterItemExpand', type='ext.tree.events.TreePanel_node_index_itemEvent')]
/**
 * @see ext.tree.events.TreePanel_node_checked_eEvent.BEFORE_CHECK_CHANGE
 * @eventType ext.tree.events.TreePanel_node_checked_eEvent.BEFORE_CHECK_CHANGE
 */
[Event(name='onBeforeCheckChange', type='ext.tree.events.TreePanel_node_checked_eEvent')]
/**
 * @see ext.tree.events.TreePanel_nodeEvent.BEFORE_ITEM_APPEND
 * @eventType ext.tree.events.TreePanel_nodeEvent.BEFORE_ITEM_APPEND
 */
[Event(name='onBeforeItemAppend', type='ext.tree.events.TreePanel_nodeEvent')]
/**
 * @see ext.tree.events.TreePanelEvent.BEFORE_ITEM_COLLAPSE
 * @eventType ext.tree.events.TreePanelEvent.BEFORE_ITEM_COLLAPSE
 */
[Event(name='onBeforeItemCollapse', type='ext.tree.events.TreePanelEvent')]
/**
 * @see ext.tree.events.TreePanelEvent.BEFORE_ITEM_EXPAND
 * @eventType ext.tree.events.TreePanelEvent.BEFORE_ITEM_EXPAND
 */
[Event(name='onBeforeItemExpand', type='ext.tree.events.TreePanelEvent')]
/**
 * @see ext.tree.events.TreePanel_node_refNodeEvent.BEFORE_ITEM_INSERT
 * @eventType ext.tree.events.TreePanel_node_refNodeEvent.BEFORE_ITEM_INSERT
 */
[Event(name='onBeforeItemInsert', type='ext.tree.events.TreePanel_node_refNodeEvent')]
/**
 * @see ext.tree.events.TreePanel_oldParent_newParent_indexEvent.BEFORE_ITEM_MOVE
 * @eventType ext.tree.events.TreePanel_oldParent_newParent_indexEvent.BEFORE_ITEM_MOVE
 */
[Event(name='onBeforeItemMove', type='ext.tree.events.TreePanel_oldParent_newParent_indexEvent')]
/**
 * @see ext.tree.events.TreePanel_node_isMoveEvent.BEFORE_ITEM_REMOVE
 * @eventType ext.tree.events.TreePanel_node_isMoveEvent.BEFORE_ITEM_REMOVE
 */
[Event(name='onBeforeItemRemove', type='ext.tree.events.TreePanel_node_isMoveEvent')]
/**
 * @see ext.tree.events.TreePanel_store_operationEvent.BEFORE_LOAD
 * @eventType ext.tree.events.TreePanel_store_operationEvent.BEFORE_LOAD
 */
[Event(name='onBeforeLoad', type='ext.tree.events.TreePanel_store_operationEvent')]
/**
 * @see ext.tree.events.TreePanel_node_checked_eEvent.CHECK_CHANGE
 * @eventType ext.tree.events.TreePanel_node_checked_eEvent.CHECK_CHANGE
 */
[Event(name='onCheckChange', type='ext.tree.events.TreePanel_node_checked_eEvent')]
/**
 * @see ext.tree.events.TreePanel_node_indexEvent.ITEM_APPEND
 * @eventType ext.tree.events.TreePanel_node_indexEvent.ITEM_APPEND
 */
[Event(name='onItemAppend', type='ext.tree.events.TreePanel_node_indexEvent')]
/**
 * @see ext.tree.events.TreePanelEvent.ITEM_COLLAPSE
 * @eventType ext.tree.events.TreePanelEvent.ITEM_COLLAPSE
 */
[Event(name='onItemCollapse', type='ext.tree.events.TreePanelEvent')]
/**
 * @see ext.tree.events.TreePanelEvent.ITEM_EXPAND
 * @eventType ext.tree.events.TreePanelEvent.ITEM_EXPAND
 */
[Event(name='onItemExpand', type='ext.tree.events.TreePanelEvent')]
/**
 * @see ext.tree.events.TreePanel_node_refNodeEvent.ITEM_INSERT
 * @eventType ext.tree.events.TreePanel_node_refNodeEvent.ITEM_INSERT
 */
[Event(name='onItemInsert', type='ext.tree.events.TreePanel_node_refNodeEvent')]
/**
 * @see ext.tree.events.TreePanel_oldParent_newParent_indexEvent.ITEM_MOVE
 * @eventType ext.tree.events.TreePanel_oldParent_newParent_indexEvent.ITEM_MOVE
 */
[Event(name='onItemMove', type='ext.tree.events.TreePanel_oldParent_newParent_indexEvent')]
/**
 * @see ext.tree.events.TreePanel_node_isMove_contextEvent.ITEM_REMOVE
 * @eventType ext.tree.events.TreePanel_node_isMove_contextEvent.ITEM_REMOVE
 */
[Event(name='onItemRemove', type='ext.tree.events.TreePanel_node_isMove_contextEvent')]
/**
 * @see ext.tree.events.TreePanel_records_successful_operation_nodeEvent.LOAD
 * @eventType ext.tree.events.TreePanel_records_successful_operation_nodeEvent.LOAD
 */
[Event(name='onLoad', type='ext.tree.events.TreePanel_records_successful_operation_nodeEvent')]
/**
 * The TreePanel provides tree-structured UI representation of tree-structured data.
 * A TreePanel must be bound to a →<code>ext.data.TreeStore</code>.
 * <p>TreePanels support multiple columns through the →<code>columns</code> configuration.</p>
 * <p>By default a TreePanel contains a single column which uses the <code>text</code> Field of
 * the store's nodes.</p>
 * <p>Simple TreePanel using inline data:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var store = Ext.create('Ext.data.TreeStore', {
 *     root: {
 *         expanded: true,
 *         children: [
 *             { text: 'detention', leaf: true },
 *             { text: 'homework', expanded: true, children: [
 *                 { text: 'book report', leaf: true },
 *                 { text: 'algebra', leaf: true}
 *             ] },
 *             { text: 'buy lottery tickets', leaf: true }
 *         ]
 *     }
 * });
 *
 * Ext.create('Ext.tree.Panel', {
 *     title: 'Simple Tree',
 *     width: 200,
 *     height: 200,
 *     store: store,
 *     rootVisible: false,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p>For the tree node config options (like <code>text</code>, <code>leaf</code>, <code>expanded</code>), see the documentation of
 * →<code>ext.data.NodeInterface</code> config options.</p>
 * <p>Unless the TreeStore is configured with a <i>model</i> (→<code>ext.data.Model</code>) of your choosing,
 * nodes in the →<code>ext.data.TreeStore</code> are by default, instances of →<code>ext.data.TreeModel</code>.</p>
 * <p><b>Heterogeneous node types.</b></p>
 * <p>If the tree needs to use different data model classes at different levels there is much
 * flexibility in how to specify this.</p>
 * <p><i>Configuring the Reader.</i></p>
 * <p>If you configure the proxy's reader with a
 * →<code>ext.data.reader.DataReader.typeProperty</code>, then the server is in control of which
 * data model types are created. A discriminator field is used in the raw data to decide which class
 * to instantiate. <b>If this is configured, then the data from the server is prioritized over other
 * ways of determining node class</b>.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('myApp.Territory', {
 *     extend: 'Ext.data.TreeModel',
 *     fields: [{
 *         name: 'text',
 *         mapping: 'name'
 *     }]
 * });
 * Ext.define('myApp.Country', {
 *     extend: 'Ext.data.TreeModel',
 *     fields: [{
 *         name: 'text',
 *         mapping: 'name'
 *     }]
 * });
 * Ext.define('myApp.City', {
 *     extend: 'Ext.data.TreeModel',
 *     fields: [{
 *         name: 'text',
 *         mapping: 'name'
 *     }]
 * });
 * Ext.create('Ext.tree.Panel', {
 *     renderTo: document.body,
 *     height: 200,
 *     width: 400,
 *     title: 'Sales Areas - using typeProperty',
 *     rootVisible: false,
 *     store: {
 *         // Child types use namespace of store's model by default
 *         model: 'myApp.Territory',
 *         proxy: {
 *             type: 'memory',
 *             reader: {
 *                 typeProperty: 'mtype'
 *             }
 *         },
 *         root: {
 *             children: [{
 *                 name: 'Europe, ME, Africa',
 *                 mtype: 'Territory',
 *                 children: [{
 *                     name: 'UK of GB &amp; NI',
 *                     mtype: 'Country',
 *                     children: [{
 *                         name: 'London',
 *                         mtype: 'City',
 *                         leaf: true
 *                     }]
 *                 }]
 *             }, {
 *                 name: 'North America',
 *                 mtype: 'Territory',
 *                 children: [{
 *                     name: 'USA',
 *                     mtype: 'Country',
 *                     children: [{
 *                         name: 'Redwood City',
 *                         mtype: 'City',
 *                         leaf: true
 *                     }]
 *                 }]
 *             }]
 *         }
 *     }
 * });
 * </pre>
 * <p><i>Node being loaded decides.</i></p>
 * <p>You can declare your TreeModel subclasses with a →<code>ext.data.TreeModel.childType</code>
 * which means that the node being loaded decides the class to instantiate for all of its
 * child nodes.</p>
 * <p>It is important to note that if the root node is <i>hidden</i> (→<code>ext.tree.TreePanel.rootVisible</code>),
 * its type will default to the store's model type, and if left as the default
 * (<code>→ext.data.TreeModel</code>) this will have no knowledge of creation of special child node
 * types. So be sure to specify a store model in this case:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('myApp.TerritoryRoot', {
 *     extend: 'Ext.data.TreeModel',
 *     childType: 'myApp.Territory',
 *     fields: [{
 *         name: 'text',
 *         mapping: 'name'
 *     }]
 * });
 * Ext.define('myApp.Territory', {
 *     extend: 'Ext.data.TreeModel',
 *     childType: 'myApp.Country',
 *     fields: [{
 *         name: 'text',
 *         mapping: 'name'
 *     }]
 * });
 * Ext.define('myApp.Country', {
 *     extend: 'Ext.data.TreeModel',
 *     childType: 'myApp.City',
 *     fields: [{
 *         name: 'text',
 *         mapping: 'name'
 *     }]
 * });
 * Ext.define('myApp.City', {
 *     extend: 'Ext.data.TreeModel',
 *     fields: [{
 *         name: 'text',
 *         mapping: 'name'
 *     }]
 * });
 * Ext.create('Ext.tree.Panel', {
 *     renderTo: document.body,
 *     height: 200,
 *     width: 400,
 *     title: 'Sales Areas',
 *     rootVisible: false,
 *     store: {
 *         // Needs to be this so it knows to create 'Country' child nodes
 *         model: 'myApp.TerritoryRoot',
 *         root: {
 *             children: [{
 *                 name: 'Europe, ME, Africa',
 *                 children: [{
 *                     name: 'UK of GB &amp; NI',
 *                     children: [{
 *                         name: 'London',
 *                         leaf: true
 *                     }]
 *                 }]
 *             }, {
 *                 name: 'North America',
 *                 children: [{
 *                     name: 'USA',
 *                     children: [{
 *                         name: 'Redwood City',
 *                         leaf: true
 *                     }]
 *                 }]
 *             }]
 *         }
 *     }
 * });
 * </pre>
 * <p><b>Data structure</b></p>
 * <p>The →<code>ext.data.TreeStore</code> maintains a <i>root node</i> (→<code>ext.data.TreeStore.getRoot</code>)
 * and a hierarchical structure of <i>node</i> (→<code>ext.data.TreeModel</code>)s.</p>
 * <p>The <i>UI</i> (→<code>ext.tree.TreeView</code>) of the tree is driven by a {Ext.data.NodeStore NodeStore} which is
 * a flattened view of <i>visible</i> nodes. The NodeStore is dynamically updated to reflect
 * the visibility state of nodes as nodes are added, removed or expanded. The UI responds
 * to mutation events fire by the NodeStore.</p>
 * <p>Note that nodes have several more →<code>ext.data.Model.fields</code> in order to describe
 * their state within the hierarchy.</p>
 * <p>If you add store listeners to the →<code>ext.data.Store.event:onUpdate</code> event, then you will
 * receive notification when any of this state changes. You should check the array of modified field
 * names passed to the listener to decide whether the listener should take action
 * or ignore the event.</p>
 * <p><b>Tree Grid</b></p>
 * <p>Trees may be configured using the →<code>columns</code> config including a
 * <i>treecolumn</i> (→<code>ext.tree.TreeColumn</code>) to give the tree panel a hybrid tree /
 * <i>grid</i> (→<code>ext.grid.GridPanel</code>) structure.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *     xtype: 'treepanel',
 *     renderTo: Ext.getBody(),
 *     height: 200,
 *     width: 300,
 *     rootVisible: false,
 *     store: Ext.create('Ext.data.TreeStore', {
 *         fields: ['text', 'duration', 'isLayover'],
 *         root: {
 *             expanded: true,
 *             children: [{
 *                 text: 'SFO  &amp;nbsp;✈&amp;nbsp; DFW',
 *                 duration: '6h 55m',
 *                 expanded: true,
 *                 children: [{
 *                     text: 'SFO &amp;nbsp;✈&amp;nbsp; PHX',
 *                     duration: '2h 04m',
 *                     leaf: true
 *                 }, {
 *                     text: 'PHX layover',
 *                     duration: '2h 36m',
 *                     isLayover: true,
 *                     leaf: true
 *                 }, {
 *                     text: 'PHX &amp;nbsp;✈&amp;nbsp; DFW',
 *                     duration: '2h 15m',
 *                     leaf: true
 *                 }]
 *             }]
 *         }
 *     }),
 *     columns: [{
 *         xtype: 'treecolumn',
 *         text: 'Flight Endpoints',
 *         dataIndex: 'text',
 *         flex: 1,
 *         renderer: function (val, meta, rec) {
 *             if (rec.get('isLayover')) {
 *                 meta.tdStyle = 'color: gray; font-style: italic;';
 *             }
 *             return val;
 *         }
 *     }, {
 *         text: 'Duration',
 *         dataIndex: 'duration',
 *         width: 100
 *     }]
 * });
 * </pre>
 * @see ext.data.TreeStore
 * @see #columns
 * @see ext.data.NodeInterface
 * @see ext.data.Model
 * @see ext.data.TreeModel
 * @see ext.data.reader.DataReader#typeProperty
 * @see ext.data.TreeModel#childType
 * @see ext.tree.TreePanel#rootVisible
 * @see ext.data.TreeStore#getRoot
 * @see ext.tree.TreeView
 * @see ext.data.Model#fields
 * @see ext.data.Store#event:onUpdate
 * @see ext.tree.TreeColumn
 * @see ext.grid.GridPanel
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html Original Ext JS documentation of 'Ext.tree.Panel'
 */
public class TreePanel extends TablePanel {
  /**
   * @param config @inheritDoc
   */
  public function TreePanel(config:TreePanel = null) {
    super();
  }

  [ExtConfig]
  /**
   * True to enable animated expand/collapse. Defaults to the value of →<code>ext.Ext.enableFx</code>.
   * @see ext.SExt#enableFx ext.Ext.enableFx
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#cfg-animate Original Ext JS documentation of 'animate'
   */
  public native function get animated():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set animated(value:Boolean):void;

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default 'treegrid'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  override public native function set ariaRole(value:String):void;

  [ExtConfig]
  /**
   * This configuration controls whether, and how checkbox click gestures are propagated to
   * child nodes, or to a parent node.
   * <p>Valid values are</p>
   * <pre>
   *  - `'none'` Checking a check node does not affect any other nodes.
   *  - `'up'` Checking a check node synchronizes the value of its parent node with the state
   *     of its children.
   *  - `'down'` Checking a check node propagates the value to its child nodes.
   *  - `'both'` Checking a check node updates its child nodes, and syncs its parent node.
   * </pre>
   * @default none
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#cfg-checkPropagation Original Ext JS documentation of 'checkPropagation'
   */
  public native function get checkPropagation():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checkPropagation(value:String):void;

  [ExtConfig]
  /**
   * The field inside the model that will be used as the node's text.
   * @default text
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#cfg-displayField Original Ext JS documentation of 'displayField'
   */
  public native function get displayField():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set displayField(value:String):void;

  [ExtConfig]
  /**
   * True to automatically prepend a leaf sorter to the store.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#cfg-folderSort Original Ext JS documentation of 'folderSort'
   */
  public native function get folderSort():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set folderSort(value:Boolean):void;

  [ExtConfig]
  /**
   * False to disable tree lines.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#cfg-lines Original Ext JS documentation of 'lines'
   */
  public native function get lines():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lines(value:Boolean):void;

  [ExtConfig]
  /**
   * Allows you to not specify a store on this TreePanel. This is useful for creating a simple
   * tree with preloaded data without having to specify a TreeStore and Model. A store and model
   * will be created and root will be passed
   * to that store. For example:
   * <pre>
   * Ext.create('Ext.tree.Panel', {
   *     title: 'Simple Tree',
   *     root: {
   *         text: "Root node",
   *         expanded: true,
   *         children: [
   *             { text: "Child 1", leaf: true },
   *             { text: "Child 2", leaf: true }
   *         ]
   *     },
   *     renderTo: Ext.getBody()
   * });
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#cfg-root Original Ext JS documentation of 'root'
   */
  public native function get root():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set root(value:*):void;

  [ExtConfig]
  /**
   * False to hide the root node.
   * <p>Note that trees <i>always</i> have a root node. If you do not specify a →<code>root</code> node,
   * one will be created.</p>
   * <p>If the root node is not visible, then in order for a tree to appear to the end user,
   * the root node is autoloaded with its child nodes.</p>
   * @default true
   * @see #root
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#cfg-rootVisible Original Ext JS documentation of 'rootVisible'
   */
  public native function get rootVisible():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set rootVisible(value:Boolean):void;

  [ExtConfig]
  /**
   * Configure as true to separate rows with visible horizontal lines (depends on theme).
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#cfg-rowLines Original Ext JS documentation of 'rowLines'
   */
  override public native function get rowLines():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set rowLines(value:Boolean):void;

  [ExtConfig]
  /**
   * True if only 1 node per branch may be expanded.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#cfg-singleExpand Original Ext JS documentation of 'singleExpand'
   */
  public native function get singleExpand():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set singleExpand(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * <b>This is a required setting</b>. The <i>Store</i> (→<code>ext.data.TreeStore</code>) the tree should use as its data source.
   * @see ext.data.TreeStore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#cfg-store Original Ext JS documentation of 'store'
   * @see #getStore()
   * @see #setStore()
   */
  override public native function get store():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set store(value:*):void;

  [ExtConfig]
  /**
   * True to use Vista-style arrows in the tree.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#cfg-useArrows Original Ext JS documentation of 'useArrows'
   */
  public native function get useArrows():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set useArrows(value:Boolean):void;

  /**
   * Collapse all nodes
   * @param callback A function to execute when the collapse finishes.
   * @param scope The scope of the callback function
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#method-collapseAll Original Ext JS documentation of 'collapseAll'
   */
  public native function collapseAll(callback:Function = null, scope:Object = null):void;

  /**
   * Collapses a record that is loaded in the tree.
   * @param record The record to collapse
   * @param deep True to collapse nodes all the way up the tree hierarchy.
   * @param callback The function to run after the collapse is completed
   * @param scope The scope of the callback function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#method-collapseNode Original Ext JS documentation of 'collapseNode'
   */
  public native function collapseNode(record:Model, deep:Boolean = false, callback:Function = null, scope:Object = null):void;

  /**
   * Expand the tree to the path of a particular node, then scroll it into view.
   * @param record The record, record id, or the zero-based
   * position in the dataset to scroll to.
   * @param options An object containing options to modify the operation.
   * <ul>
   * <li><code>column</code> (optional) —
   * The column to scroll into view.
   * </li>
   * <li><code>animate:Boolean</code> (optional) —
   * Pass <code>true</code> to animate the row into view.
   * </li>
   * <li><code>highlight:Boolean</code> (optional) —
   * Pass <code>true</code> to highlight the row with a glow animation
   * when it is in view.
   * </li>
   * <li><code>select:Boolean</code> (optional) —
   * Pass as <code>true</code> to select the specified row.
   * </li>
   * <li><code>focus:Boolean</code> (optional) —
   * Pass as <code>true</code> to focus the specified row.
   * </li>
   * <li><code>callback:Function</code> (optional) —
   * A function to execute when the record is in view.
   * This may be necessary if the first parameter is a record index and the view is backed by a
   * <i>buffered store</i> (→<code>ext.data.BufferedStore</code>) which does not contain that record.
   * <ul>
   * <li><code>success:Boolean</code> (optional) —
   * <code>true</code> if acquiring the record's view node
   * was successful.
   * </li>
   * <li><code>record:ext.data.Model</code> (optional) —
   * If successful, the target record.
   * </li>
   * <li><code>node:js.HTMLElement</code> (optional) —
   * If successful, the record's view node.
   * </li>
   * </ul>
   * </li>
   * <li><code>scope:Object</code> (optional) —
   * The scope (<code>this</code> reference) in which the callback function
   * is executed.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#method-ensureVisible Original Ext JS documentation of 'ensureVisible'
   * @see ext.data.BufferedStore
   */
  override public native function ensureVisible(record:*, options:Object = null):void;

  /**
   * Expand all nodes
   * @param callback A function to execute when the expand finishes.
   * @param scope The scope of the callback function
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#method-expandAll Original Ext JS documentation of 'expandAll'
   */
  public native function expandAll(callback:Function = null, scope:Object = null):void;

  /**
   * Expands a record that is loaded in the tree.
   * @param record The record to expand
   * @param deep True to expand nodes all the way down the tree hierarchy.
   * @param callback The function to run after the expand is completed
   * @param scope The scope of the callback function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#method-expandNode Original Ext JS documentation of 'expandNode'
   */
  public native function expandNode(record:Model, deep:Boolean = false, callback:Function = null, scope:Object = null):void;

  /**
   * Expand the tree to the path of a particular node. This is the way to expand a known path
   * when the intervening nodes are not yet loaded.
   * <p>The path may be an absolute path (beginning with a <code>'/'</code> character) from the root, eg:</p>
   * <pre>
   * '/rootId/nodeA/nodeB/nodeC'
   * </pre>
   * <p>Or, the path may be relative, starting from an <b>existing</b> node in the tree:</p>
   * <pre>
   * 'nodeC/nodeD'
   * </pre>
   * @param path The path to expand. The path may be absolute, including a leading
   * separator and starting from the root node id, or relative with no leading separator,
   * starting from an <i>existing</i> node in the tree.
   * @param options An object containing options to modify the operation.
   * <ul>
   * <li><code>field:String</code> (optional) —
   * The field to get the data from. Defaults to the model
   * idProperty.
   * </li>
   * <li><code>separator:String</code> (default = <code>'/'</code>) —
   * A separator to use.
   * </li>
   * <li><code>select:Boolean</code> (optional) —
   * Pass as <code>true</code> to select the specified row.
   * </li>
   * <li><code>focus:Boolean</code> (optional) —
   * Pass as <code>true</code> to focus the specified row.
   * </li>
   * <li><code>callback:Function</code> (optional) —
   * A function to execute when the expand finishes.
   * <ul>
   * <li><code>success:Boolean</code> (optional) —
   * <code>true</code> if the node expansion was successful.
   * </li>
   * <li><code>record:ext.data.Model</code> (optional) —
   * If successful, the target record.
   * </li>
   * <li><code>node:js.HTMLElement</code> (optional) —
   * If successful, the record's view node.
   * If unsuccessful, the last view node encountered while expanding the path.
   * </li>
   * </ul>
   * </li>
   * <li><code>scope:Object</code> (optional) —
   * The scope (<code>this</code> reference) in which the callback function
   * is executed.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#method-expandPath Original Ext JS documentation of 'expandPath'
   */
  public native function expandPath(path:String, options:Object = null):void;

  [ArrayElementType("ext.data.TreeModel")]
  /**
   * Retrieve an array of checked records.
   * @return An array containing the checked records
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#method-getChecked Original Ext JS documentation of 'getChecked'
   */
  public native function getChecked():Array;

  /**
   * Returns the root node for this tree.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#method-getRootNode Original Ext JS documentation of 'getRootNode'
   */
  public native function getRootNode():TreeModel;

  /**
   * Expand the tree to the path of a particular node, then select it.
   * @param path The path to expand. The path may be absolute, including a leading
   * separator and starting from the root node id, or relative with no leading separator,
   * starting from an <i>existing</i> node in the tree.
   * @param field The field to get the data from. Defaults to the model idProperty.
   * @param separator A separator to use.
   * @default '/'
   * @param callback A function to execute when the select finishes.
   * <ul>
   * <li><code>success:Boolean</code> (optional) —
   * <code>true</code> if the node expansion was successful.
   * </li>
   * <li><code>lastNode:ext.data.NodeInterface</code> (optional) —
   * If successful, the target node.
   * If unsuccessful, the last tree node encountered while expanding the path.
   * </li>
   * <li><code>node:js.HTMLElement</code> (optional) —
   * If successful, the record's view node.
   * </li>
   * </ul>
   * @param scope The scope of the callback function
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#method-selectPath Original Ext JS documentation of 'selectPath'
   */
  public native function selectPath(path:String, field:String = null, separator:String = '/', callback:Function = null, scope:Object = null):void;

  /**
   * Sets root node of this tree. All trees <i>always</i> have a root node. It may be
   * <i>hidden</i> (→<code>rootVisible</code>).
   * <p>If the passed node has not already been loaded with child nodes, and has its expanded
   * field set, this triggers the →<code>store</code> to load the child nodes of the root.</p>
   * @return The new root
   * @see #rootVisible
   * @see #store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#method-setRootNode Original Ext JS documentation of 'setRootNode'
   */
  public native function setRootNode(root:*):TreeModel;
}
}