package ext.tree {
import ext.data.Model;
import ext.selection.SelectionModel;
import ext.view.TableView;

[Native("Ext.tree.View", require)]
/**
 * @see ext.tree.events.TreeView_node_index_itemEvent.AFTER_ITEM_COLLAPSE
 * @eventType ext.tree.events.TreeView_node_index_itemEvent.AFTER_ITEM_COLLAPSE
 */
[Event(name='onAfterItemCollapse', type='ext.tree.events.TreeView_node_index_itemEvent')]
/**
 * @see ext.tree.events.TreeView_node_index_itemEvent.AFTER_ITEM_EXPAND
 * @eventType ext.tree.events.TreeView_node_index_itemEvent.AFTER_ITEM_EXPAND
 */
[Event(name='onAfterItemExpand', type='ext.tree.events.TreeView_node_index_itemEvent')]
/**
 * @see ext.tree.events.TreeView_targetNode_position_dragData_eEvent.NODE_DRAG_OVER
 * @eventType ext.tree.events.TreeView_targetNode_position_dragData_eEvent.NODE_DRAG_OVER
 */
[Event(name='onNodeDragOver', type='ext.tree.events.TreeView_targetNode_position_dragData_eEvent')]
/**
 * Used as a view by →<code>ext.tree.TreePanel</code>.
 * @see ext.tree.TreePanel
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.View.html Original Ext JS documentation of 'Ext.tree.View'
 */
public class TreeView extends TableView {
  /**
   * @param config @inheritDoc
   */
  public function TreeView(config:TreeView = null) {
    super();
  }

  [ExtConfig]
  /**
   * True to enable animated expand/collapse (defaults to the value of
   * →<code>ext.Ext.enableFx</code>)
   * @see ext.SExt#enableFx ext.Ext.enableFx
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.View.html#cfg-animate Original Ext JS documentation of 'animate'
   */
  public native function get animated():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set animated(value:Boolean):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated TreeView, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.View.html#property-isTreeView Original Ext JS documentation of 'isTreeView'
   */
  public native function get isTreeView():Boolean;

  /**
   * @private
   */
  public native function set isTreeView(value:Boolean):void;

  [ExtConfig]
  /**
   * False to disable a load mask from displaying while the view is loading. This can also be a
   * →<code>ext.LoadMask</code> configuration object.
   * @default false
   * @see ext.LoadMask
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.View.html#cfg-loadMask Original Ext JS documentation of 'loadMask'
   */
  override public native function get loadMask():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set loadMask(value:*):void;

  [ExtConfig]
  /**
   * The CSS class to apply to the loading message element. Defaults to
   * Ext.LoadMask.prototype.msgCls "x-mask-loading".
   * @default Ext.baseCSSPrefix + 'grid-tree-loading'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.View.html#cfg-loadingCls Original Ext JS documentation of 'loadingCls'
   */
  override public native function get loadingCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set loadingCls(value:String):void;

  [ExtConfig]
  /**
   * False to hide the root node.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.View.html#cfg-rootVisible Original Ext JS documentation of 'rootVisible'
   */
  public native function get rootVisible():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set rootVisible(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The <i>selection model</i> (→<code>ext.selection.SelectionModel</code>) [dataviewmodel] config or alias to use.
   * @default {
   *     type: 'treemodel'
   * }
   * @see ext.selection.SelectionModel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.View.html#cfg-selectionModel Original Ext JS documentation of 'selectionModel'
   * @see #getSelectionModel()
   * @see #setSelectionModel()
   */
  override public native function get selectionModel():SelectionModel;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set selectionModel(value:SelectionModel):void;

  [ExtConfig]
  /**
   * True to stripe the rows.
   * <p>This causes the CSS class <b><code>x-grid-row-alt</code></b> to be added to alternate rows of
   * the grid. A default CSS rule is provided which sets a background color, but you can override
   * this with a rule which either overrides the <b>background-color</b> style using the <code>!important</code>
   * modifier, or which uses a CSS selector of higher specificity.</p>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.View.html#cfg-stripeRows Original Ext JS documentation of 'stripeRows'
   */
  override public native function get stripeRows():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set stripeRows(value:Boolean):void;

  [ExtConfig]
  /**
   * True to toggle expand or collapse with a double click.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.View.html#cfg-toggleOnDblClick Original Ext JS documentation of 'toggleOnDblClick'
   */
  public native function get toggleOnDblClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set toggleOnDblClick(value:Boolean):void;

  /**
   * Collapses a record that is loaded in the view.
   * <p>If an animated collapse or expand of the record is in progress, this call will be ignored.</p>
   * @param record The record to collapse
   * @param deep True to collapse nodes all the way up the tree hierarchy.
   * @param callback The function to run after the collapse is completed
   * @param scope The scope of the callback function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.View.html#method-collapse Original Ext JS documentation of 'collapse'
   */
  public native function collapse(record:Model, deep:Boolean = false, callback:Function = null, scope:Object = null):void;

  /**
   * Expands a record that is loaded in the view.
   * <p>If an animated collapse or expand of the record is in progress, this call will be ignored.</p>
   * @param record The record to expand
   * @param deep True to expand nodes all the way down the tree hierarchy.
   * @param callback The function to run after the expand is completed
   * @param scope The scope of the callback function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.View.html#method-expand Original Ext JS documentation of 'expand'
   */
  public native function expand(record:Model, deep:Boolean = false, callback:Function = null, scope:Object = null):void;

  /**
   * Returns the value of <code>selectionModel</code>.
   * @see #selectionModel
   */
  override public native function getSelectionModel():SelectionModel;

  /**
   * Sets the value of <code>selectionModel</code>.
   * @param selectionModel The new value.
   * @see #selectionModel
   */
  override public native function setSelectionModel(selectionModel:*):void;

  /**
   * Toggles a record between expanded and collapsed.
   * <p>If an animated collapse or expand of the record is in progress, this call will be ignored.</p>
   * @param record
   * @param deep True to collapse nodes all the way up the tree hierarchy.
   * @param callback The function to run after the expand/collapse is completed
   * @param scope The scope of the callback function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.View.html#method-toggle Original Ext JS documentation of 'toggle'
   */
  public native function toggle(record:Model, deep:Boolean = false, callback:Function = null, scope:Object = null):void;
}
}