package ext.tree.events {
import ext.data.NodeInterface;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.tree.events.TreePanelEvent")]
public class TreePanelEvent extends FlExtEvent {
  /**
   * Fires before this node is collapsed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#event-beforeitemcollapse Original Ext JS documentation of 'beforeitemcollapse'
   * @see ext.tree.TreePanel
   * @eventType onBeforeItemCollapse
   */
  public static const BEFORE_ITEM_COLLAPSE:String = "onBeforeItemCollapse";
  /**
   * Fires before this node is expanded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#event-beforeitemexpand Original Ext JS documentation of 'beforeitemexpand'
   * @see ext.tree.TreePanel
   * @eventType onBeforeItemExpand
   */
  public static const BEFORE_ITEM_EXPAND:String = "onBeforeItemExpand";
  /**
   * Fires when this node is collapsed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#event-itemcollapse Original Ext JS documentation of 'itemcollapse'
   * @see ext.tree.TreePanel
   * @eventType onItemCollapse
   */
  public static const ITEM_COLLAPSE:String = "onItemCollapse";
  /**
   * Fires when this node is expanded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#event-itemexpand Original Ext JS documentation of 'itemexpand'
   * @see ext.tree.TreePanel
   * @eventType onItemExpand
   */
  public static const ITEM_EXPAND:String = "onItemExpand";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "eOpts"];

  public function TreePanelEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The collapsing node
   */
  public native function get source():NodeInterface;
}
}