package ext.tree.events {
import ext.data.NodeInterface;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.tree.events.TreePanel_nodeEvent")]
public class TreePanel_nodeEvent extends FlExtEvent {
  /**
   * Fires before a new child is appended, return false to cancel the append.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#event-beforeitemappend Original Ext JS documentation of 'beforeitemappend'
   * @see ext.tree.TreePanel
   * @eventType onBeforeItemAppend
   */
  public static const BEFORE_ITEM_APPEND:String = "onBeforeItemAppend";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "node", "eOpts"];

  public function TreePanel_nodeEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The child node to be appended
   */
  public native function get node():NodeInterface;

  /**
   * This node
   */
  public native function get source():NodeInterface;
}
}