package ext.tree.events {
import ext.data.TreeModel;
import ext.event.Event;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.tree.events.TreePanel_node_checked_eEvent")]
public class TreePanel_node_checked_eEvent extends FlExtEvent {
  /**
   * Fires when a node with a checkbox's checked property changes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#event-beforecheckchange Original Ext JS documentation of 'beforecheckchange'
   * @see ext.tree.TreePanel
   * @eventType onBeforeCheckChange
   */
  public static const BEFORE_CHECK_CHANGE:String = "onBeforeCheckChange";
  /**
   * Fires when a node with a checkbox's checked property changes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#event-checkchange Original Ext JS documentation of 'checkchange'
   * @see ext.tree.TreePanel
   * @eventType onCheckChange
   */
  public static const CHECK_CHANGE:String = "onCheckChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["node", "checked", "e", "eOpts"];

  public function TreePanel_node_checked_eEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The node's current checked state.
   */
  public native function get checked():Boolean;

  /**
   * The click event.
   */
  public native function get e():Event;

  /**
   * The node who's checked property is to be changed.
   */
  public native function get node():TreeModel;
}
}