package ext.tree.events {
import ext.data.NodeInterface;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.tree.events.TreePanel_node_indexEvent")]
public class TreePanel_node_indexEvent extends FlExtEvent {
  /**
   * Fires when a new child node is appended
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.tree.Panel.html#event-itemappend Original Ext JS documentation of 'itemappend'
   * @see ext.tree.TreePanel
   * @eventType onItemAppend
   */
  public static const ITEM_APPEND:String = "onItemAppend";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "node", "index", "eOpts"];

  public function TreePanel_node_indexEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The index of the newly appended node
   */
  public native function get index():Number;

  /**
   * The newly appended node
   */
  public native function get node():NodeInterface;

  /**
   * This node
   */
  public native function get source():NodeInterface;
}
}